/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.lang.invoke.LambdaMetafactory;
import org.hipparchus.CalculusFieldElement;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.RangeRate;
import org.orekit.estimation.measurements.modifiers.BaseRangeRateTroposphericDelayModifier;
import org.orekit.estimation.measurements.modifiers.ModifierGradientConverter;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffectGradient;
import org.orekit.estimation.measurements.modifiers.RangeRateModifierUtil;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;

public class RangeRateTroposphericDelayModifier
extends BaseRangeRateTroposphericDelayModifier
implements EstimationModifier<RangeRate> {
    private final double fTwoWay;

    public RangeRateTroposphericDelayModifier(DiscreteTroposphericModel model, boolean tw) {
        super(model);
        this.fTwoWay = tw ? 2.0 : 1.0;
    }

    @Override
    public double rangeRateErrorTroposphericModel(GroundStation station, SpacecraftState state) {
        return this.fTwoWay * super.rangeRateErrorTroposphericModel(station, state);
    }

    @Override
    public <T extends CalculusFieldElement<T>> T rangeRateErrorTroposphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        return (T)((CalculusFieldElement)super.rangeRateErrorTroposphericModel(station, state, parameters).multiply(this.fTwoWay));
    }

    @Override
    public void modify(EstimatedMeasurement<RangeRate> estimated) {
        RangeRate measurement = estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        RangeRateModifierUtil.modify(estimated, this.getTropoModel(), new ModifierGradientConverter(state, 6, new InertialProvider(state.getFrame())), station, this::rangeRateErrorTroposphericModel, (ParametricModelEffectGradient)LambdaMetafactory.metafactory(null, null, null, (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;, rangeRateErrorTroposphericModel(org.orekit.estimation.measurements.GroundStation org.orekit.propagation.FieldSpacecraftState org.hipparchus.CalculusFieldElement[] ), (Lorg/orekit/estimation/measurements/GroundStation;Lorg/orekit/propagation/FieldSpacecraftState;[Lorg/hipparchus/analysis/differentiation/Gradient;)Lorg/hipparchus/analysis/differentiation/Gradient;)((RangeRateTroposphericDelayModifier)this));
    }
}

