/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffect;
import org.orekit.estimation.measurements.modifiers.ParametricModelEffectGradient;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AbstractGradientConverter;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParametersDriversProvider;

public class RangeRateModifierUtil {
    private RangeRateModifierUtil() {
    }

    public static <T extends ObservedMeasurement<T>> void modify(EstimatedMeasurement<T> estimated, ParametersDriversProvider parametricModel, AbstractGradientConverter converter, GroundStation station, ParametricModelEffect modelEffect, ParametricModelEffectGradient modelEffectGradient) {
        double parameterDerivative;
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        FieldSpacecraftState<Gradient> gState = converter.getState(parametricModel);
        Gradient[] gParameters = converter.getParameters(gState, parametricModel);
        Gradient gDelay = modelEffectGradient.evaluate(station, gState, gParameters);
        double[] derivatives = gDelay.getGradient();
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
            double[] dArray = stateDerivatives[0];
            int n = jcol;
            dArray[n] = dArray[n] + derivatives[jcol];
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int index = 0;
        for (ParameterDriver driver : parametricModel.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += derivatives[index + converter.getFreeStateParameters()]);
            ++index;
        }
        for (ParameterDriver driver : Arrays.asList(station.getClockOffsetDriver(), station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += Differentiation.differentiate(d -> modelEffect.evaluate(station, state), 3, 10.0 * driver.getScale()).value(driver));
        }
        double[] newValue = (double[])oldValue.clone();
        newValue[0] = newValue[0] + gDelay.getValue();
        estimated.setEstimatedValue(newValue);
    }
}

