/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.FieldTimeInterpolable;
import org.orekit.utils.ParameterDriver;

public abstract class BaseRangeRateIonosphericDelayModifier {
    private final IonosphericModel ionoModel;
    private final double frequency;

    protected BaseRangeRateIonosphericDelayModifier(IonosphericModel model, double freq) {
        this.ionoModel = model;
        this.frequency = freq;
    }

    protected IonosphericModel getIonoModel() {
        return this.ionoModel;
    }

    protected double rangeRateErrorIonosphericModel(GroundStation station, SpacecraftState state) {
        double dt = 10.0;
        TopocentricFrame baseFrame = station.getBaseFrame();
        double delay1 = this.ionoModel.pathDelay(state, baseFrame, this.frequency, this.ionoModel.getParameters());
        SpacecraftState state2 = state.shiftedBy(10.0);
        double delay2 = this.ionoModel.pathDelay(state2, baseFrame, this.frequency, this.ionoModel.getParameters());
        return (delay2 - delay1) / 10.0;
    }

    protected <T extends CalculusFieldElement<T>> T rangeRateErrorIonosphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        double dt = 10.0;
        TopocentricFrame baseFrame = station.getBaseFrame();
        CalculusFieldElement delay1 = this.ionoModel.pathDelay(state, baseFrame, this.frequency, (CalculusFieldElement[])parameters);
        FieldTimeInterpolable state2 = state.shiftedBy(10.0);
        CalculusFieldElement delay2 = this.ionoModel.pathDelay((FieldSpacecraftState)state2, baseFrame, this.frequency, (CalculusFieldElement[])parameters);
        return (T)((CalculusFieldElement)((CalculusFieldElement)delay2.subtract((FieldElement)delay1)).divide(10.0));
    }

    public List<ParameterDriver> getParametersDrivers() {
        return this.ionoModel.getParametersDrivers();
    }
}

