/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.generation.AbstractScheduler;
import org.orekit.estimation.measurements.generation.MeasurementBuilder;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DatesSelector;

public class ContinuousScheduler<T extends ObservedMeasurement<T>>
extends AbstractScheduler<T> {
    public ContinuousScheduler(MeasurementBuilder<T> builder, DatesSelector selector) {
        super(builder, selector);
    }

    @Override
    public SortedSet<T> generate(List<OrekitStepInterpolator> interpolators) {
        List<AbsoluteDate> dates = this.getSelector().selectDates(interpolators.get(0).getPreviousState().getDate(), interpolators.get(0).getCurrentState().getDate());
        TreeSet measurements = new TreeSet();
        for (AbsoluteDate date : dates) {
            SpacecraftState[] states = new SpacecraftState[interpolators.size()];
            for (int i = 0; i < states.length; ++i) {
                states[i] = interpolators.get(i).getInterpolatedState(date);
            }
            measurements.add(this.getBuilder().build(states));
        }
        return measurements;
    }
}

