/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.filtering;

import java.util.ArrayList;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.filtering.HatchFilter;
import org.orekit.gnss.ObservationData;

public class DualFrequencyHatchFilter
extends HatchFilter {
    private double wavelengthFreq1;
    private double wavelengthFreq2;
    private ArrayList<Double> phase1History;
    private ArrayList<Double> phase2History;

    public DualFrequencyHatchFilter(ObservationData initCode, ObservationData initPhaseFreq1, ObservationData initPhaseFreq2, double wavelengthFreq1, double wavelengthFreq2, double threshold, int N) {
        super(threshold, N);
        this.wavelengthFreq1 = wavelengthFreq1;
        this.wavelengthFreq2 = wavelengthFreq2;
        this.phase1History = new ArrayList();
        this.phase2History = new ArrayList();
        this.phase1History.add(initPhaseFreq1.getValue() * wavelengthFreq1);
        this.phase2History.add(initPhaseFreq2.getValue() * wavelengthFreq2);
        this.updatePreviousSmoothedCode(initCode.getValue());
        this.updatePreviousSmoothingValue(DualFrequencyHatchFilter.divergenceFreeCombination(initPhaseFreq1.getValue(), initPhaseFreq2.getValue(), wavelengthFreq1, wavelengthFreq2));
        this.addToSmoothedCodeHistory(initCode.getValue());
        this.addToCodeHistory(initCode.getValue());
    }

    public ObservationData filterData(ObservationData codeData, ObservationData phaseDataFreq1, ObservationData phaseDataFreq2) {
        double code = codeData.getValue();
        this.addToCodeHistory(code);
        double phaseFreq1 = this.wavelengthFreq1 * phaseDataFreq1.getValue();
        double phaseFreq2 = this.wavelengthFreq2 * phaseDataFreq2.getValue();
        double phaseDF = DualFrequencyHatchFilter.divergenceFreeCombination(phaseDataFreq1.getValue(), phaseDataFreq2.getValue(), this.wavelengthFreq1, this.wavelengthFreq2);
        this.phase1History.add(phaseFreq1);
        this.phase2History.add(phaseFreq2);
        boolean cycleSlip = FastMath.floorMod((int)phaseDataFreq1.getLossOfLockIndicator(), (int)2) != 0 || FastMath.floorMod((int)phaseDataFreq2.getLossOfLockIndicator(), (int)2) != 0;
        double smoothedValue = this.smoothedCode(code, phaseDF);
        this.updatePreviousSmoothingValue(phaseDF);
        smoothedValue = this.checkValidData(code, smoothedValue, cycleSlip);
        this.addToSmoothedCodeHistory(smoothedValue);
        this.updatePreviousSmoothedCode(smoothedValue);
        return new ObservationData(codeData.getObservationType(), smoothedValue, codeData.getLossOfLockIndicator(), codeData.getSignalStrength());
    }

    public ArrayList<Double> getFirstFrequencyPhaseHistory() {
        return this.phase1History;
    }

    public ArrayList<Double> getSecondFrequencyPhaseHistory() {
        return this.phase2History;
    }

    private static double divergenceFreeCombination(double phase1, double phase2, double lambda1, double lambda2) {
        double phaseFreq1 = lambda1 * phase1;
        double phaseFreq2 = lambda2 * phase2;
        double f1 = 2.99792458E8 / lambda1;
        double f2 = 2.99792458E8 / lambda2;
        double alpha = 1.0 / (f1 * f1 / (f2 * f2) - 1.0);
        return phaseFreq1 + 2.0 * alpha * (phaseFreq1 - phaseFreq2);
    }
}

