/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.leastsquares;

import java.util.List;
import org.orekit.estimation.leastsquares.AbstractBatchLSModel;
import org.orekit.estimation.leastsquares.PreCompensation;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.MultiSatStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

class MeasurementHandler
implements MultiSatStepHandler {
    private final AbstractBatchLSModel model;
    private final List<PreCompensation> precompensated;
    private int number;
    private int index;

    MeasurementHandler(AbstractBatchLSModel model, List<PreCompensation> precompensated) {
        this.model = model;
        this.precompensated = precompensated;
    }

    @Override
    public void init(List<SpacecraftState> initialStates, AbsoluteDate target) {
        this.number = 0;
        this.index = 0;
    }

    @Override
    public void handleStep(List<OrekitStepInterpolator> interpolators) {
        while (this.number < this.precompensated.size()) {
            PreCompensation next = this.precompensated.get(this.number);
            AbsoluteDate currentDate = interpolators.get(0).getCurrentState().getDate();
            if (this.model.isForwardPropagation() && next.getDate().compareTo(currentDate) > 0 || !this.model.isForwardPropagation() && next.getDate().compareTo(currentDate) < 0) {
                return;
            }
            ObservedMeasurement<?> observed = next.getMeasurement();
            SpacecraftState[] states = new SpacecraftState[observed.getSatellites().size()];
            for (int i = 0; i < states.length; ++i) {
                ObservableSatellite satellite = observed.getSatellites().get(i);
                states[i] = interpolators.get(satellite.getPropagatorIndex()).getInterpolatedState(next.getDate());
            }
            EstimatedMeasurement<?> estimated = observed.estimate(this.model.getIterationsCount(), this.model.getEvaluationsCount(), states);
            this.model.fetchEvaluatedMeasurement(this.index, estimated);
            ++this.number;
            this.index += observed.getDimension();
        }
    }
}

