/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.leastsquares;

import java.util.List;
import org.orekit.estimation.leastsquares.AbstractBatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.MatricesHarvester;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.propagation.numerical.JacobiansMapper;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.numerical.PartialDerivativesEquations;
import org.orekit.utils.ParameterDriversList;

public class BatchLSModel
extends AbstractBatchLSModel {
    private static final String STM_NAME = BatchLSModel.class.getName() + "-derivatives";

    public BatchLSModel(OrbitDeterminationPropagatorBuilder[] propagatorBuilders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer) {
        super(propagatorBuilders, measurements, estimatedMeasurementsParameters, observer);
    }

    @Override
    protected MatricesHarvester configureHarvester(Propagator propagator) {
        return propagator.setupMatricesComputation(STM_NAME, null, null);
    }

    @Override
    @Deprecated
    protected JacobiansMapper configureDerivatives(Propagator propagator) {
        PartialDerivativesEquations partials = new PartialDerivativesEquations(STM_NAME, (NumericalPropagator)propagator);
        SpacecraftState rawState = propagator.getInitialState();
        SpacecraftState stateWithDerivatives = partials.setInitialJacobians(rawState);
        propagator.resetInitialState(stateWithDerivatives);
        return partials.getMapper();
    }

    @Override
    protected Orbit configureOrbits(MatricesHarvester harvester, Propagator propagator) {
        return propagator.getInitialState().getOrbit();
    }
}

