/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.orekit.data.BodiesElements;
import org.orekit.data.FieldBodiesElements;
import org.orekit.data.SeriesTerm;

class TideTerm
extends SeriesTerm {
    private final int cGamma;
    private final int cL;
    private final int cLPrime;
    private final int cF;
    private final int cD;
    private final int cOmega;

    TideTerm(int cGamma, int cL, int cLPrime, int cF, int cD, int cOmega) {
        this.cGamma = cGamma;
        this.cL = cL;
        this.cLPrime = cLPrime;
        this.cF = cF;
        this.cD = cD;
        this.cOmega = cOmega;
    }

    @Override
    protected double argument(BodiesElements elements) {
        return (double)this.cGamma * elements.getGamma() + (double)this.cL * elements.getL() + (double)this.cLPrime * elements.getLPrime() + (double)this.cF * elements.getF() + (double)this.cD * elements.getD() + (double)this.cOmega * elements.getOmega();
    }

    @Override
    protected double argumentDerivative(BodiesElements elements) {
        return (double)this.cGamma * elements.getGammaDot() + (double)this.cL * elements.getLDot() + (double)this.cLPrime * elements.getLPrimeDot() + (double)this.cF * elements.getFDot() + (double)this.cD * elements.getDDot() + (double)this.cOmega * elements.getOmegaDot();
    }

    @Override
    protected <T extends CalculusFieldElement<T>> T argument(FieldBodiesElements<T> elements) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)elements.getGamma().multiply(this.cGamma)).add((FieldElement)((CalculusFieldElement)elements.getL().multiply(this.cL)))).add((FieldElement)((CalculusFieldElement)elements.getLPrime().multiply(this.cLPrime)))).add((FieldElement)((CalculusFieldElement)elements.getF().multiply(this.cF)))).add((FieldElement)((CalculusFieldElement)elements.getD().multiply(this.cD)))).add((FieldElement)((CalculusFieldElement)elements.getOmega().multiply(this.cOmega))));
    }

    @Override
    protected <T extends CalculusFieldElement<T>> T argumentDerivative(FieldBodiesElements<T> elements) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)elements.getGammaDot().multiply(this.cGamma)).add((FieldElement)((CalculusFieldElement)elements.getLDot().multiply(this.cL)))).add((FieldElement)((CalculusFieldElement)elements.getLPrimeDot().multiply(this.cLPrime)))).add((FieldElement)((CalculusFieldElement)elements.getFDot().multiply(this.cF)))).add((FieldElement)((CalculusFieldElement)elements.getDDot().multiply(this.cD)))).add((FieldElement)((CalculusFieldElement)elements.getOmegaDot().multiply(this.cOmega))));
    }
}

