/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.GillStateInterpolator;
import org.hipparchus.ode.nonstiff.RungeKuttaIntegrator;
import org.hipparchus.util.FastMath;

public class GillIntegrator
extends RungeKuttaIntegrator {
    public GillIntegrator(double step) {
        super("Gill", step);
    }

    @Override
    public double[] getC() {
        return new double[]{0.5, 0.5, 1.0};
    }

    @Override
    public double[][] getA() {
        return new double[][]{{0.5}, {(FastMath.sqrt((double)2.0) - 1.0) / 2.0, (2.0 - FastMath.sqrt((double)2.0)) / 2.0}, {0.0, -FastMath.sqrt((double)2.0) / 2.0, (2.0 + FastMath.sqrt((double)2.0)) / 2.0}};
    }

    @Override
    public double[] getB() {
        return new double[]{0.16666666666666666, (2.0 - FastMath.sqrt((double)2.0)) / 6.0, (2.0 + FastMath.sqrt((double)2.0)) / 6.0, 0.16666666666666666};
    }

    @Override
    protected GillStateInterpolator createInterpolator(boolean forward, double[][] yDotK, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, EquationsMapper mapper) {
        return new GillStateInterpolator(forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }
}

