/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import java.io.Serializable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.StatUtils;
import org.hipparchus.stat.descriptive.AbstractUnivariateStatistic;
import org.hipparchus.util.MathArrays;

public class SemiVariance
extends AbstractUnivariateStatistic
implements Serializable {
    public static final Direction UPSIDE_VARIANCE = Direction.UPSIDE;
    public static final Direction DOWNSIDE_VARIANCE = Direction.DOWNSIDE;
    private static final long serialVersionUID = 20150412L;
    private final boolean biasCorrected;
    private final Direction varianceDirection;

    public SemiVariance() {
        this(true, Direction.DOWNSIDE);
    }

    public SemiVariance(boolean biasCorrected) {
        this(biasCorrected, Direction.DOWNSIDE);
    }

    public SemiVariance(Direction direction) {
        this(true, direction);
    }

    public SemiVariance(boolean corrected, Direction direction) {
        this.biasCorrected = corrected;
        this.varianceDirection = direction;
    }

    public SemiVariance(SemiVariance original) throws NullArgumentException {
        super(original);
        this.biasCorrected = original.biasCorrected;
        this.varianceDirection = original.varianceDirection;
    }

    @Override
    public SemiVariance copy() {
        return new SemiVariance(this);
    }

    @Override
    public double evaluate(double[] values, int start, int length) throws MathIllegalArgumentException {
        double m = StatUtils.mean(values, start, length);
        return this.evaluate(values, m, this.varianceDirection, this.biasCorrected, start, length);
    }

    public double evaluate(double[] values, Direction direction) throws MathIllegalArgumentException {
        double m = StatUtils.mean(values);
        return this.evaluate(values, m, direction, this.biasCorrected, 0, values.length);
    }

    public double evaluate(double[] values, double cutoff) throws MathIllegalArgumentException {
        return this.evaluate(values, cutoff, this.varianceDirection, this.biasCorrected, 0, values.length);
    }

    public double evaluate(double[] values, double cutoff, Direction direction) throws MathIllegalArgumentException {
        return this.evaluate(values, cutoff, direction, this.biasCorrected, 0, values.length);
    }

    public double evaluate(double[] values, double cutoff, Direction direction, boolean corrected, int start, int length) throws MathIllegalArgumentException {
        MathArrays.verifyValues((double[])values, (int)start, (int)length);
        if (values.length == 0) {
            return Double.NaN;
        }
        if (values.length == 1) {
            return 0.0;
        }
        double sumsq = 0.0;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            if (!direction.considerObservation(values[i], cutoff)) continue;
            double dev = values[i] - cutoff;
            sumsq += dev * dev;
        }
        if (corrected) {
            return sumsq / ((double)length - 1.0);
        }
        return sumsq / (double)length;
    }

    public boolean isBiasCorrected() {
        return this.biasCorrected;
    }

    public SemiVariance withBiasCorrected(boolean isBiasCorrected) {
        return new SemiVariance(isBiasCorrected, this.varianceDirection);
    }

    public Direction getVarianceDirection() {
        return this.varianceDirection;
    }

    public SemiVariance withVarianceDirection(Direction direction) {
        return new SemiVariance(this.biasCorrected, direction);
    }

    public static enum Direction {
        UPSIDE(true),
        DOWNSIDE(false);

        private boolean direction;

        private Direction(boolean b) {
            this.direction = b;
        }

        boolean considerObservation(double value, double cutoff) {
            return value > cutoff == this.direction;
        }
    }
}

