/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.analysis.integration.gauss.FieldGaussIntegrator;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.Pair;

public class SymmetricFieldGaussIntegrator<T extends CalculusFieldElement<T>>
extends FieldGaussIntegrator<T> {
    public SymmetricFieldGaussIntegrator(T[] points, T[] weights) throws MathIllegalArgumentException {
        super(points, weights);
    }

    public SymmetricFieldGaussIntegrator(Pair<T[], T[]> pointsAndWeights) throws MathIllegalArgumentException {
        this((CalculusFieldElement[])pointsAndWeights.getFirst(), (CalculusFieldElement[])pointsAndWeights.getSecond());
    }

    @Override
    public T integrate(CalculusFieldUnivariateFunction<T> f) {
        int ruleLength = this.getNumberOfPoints();
        CalculusFieldElement zero = (CalculusFieldElement)this.getPoint(0).getField().getZero();
        if (ruleLength == 1) {
            return (T)this.getWeight(0).multiply((CalculusFieldElement)f.value(zero));
        }
        int iMax = ruleLength / 2;
        CalculusFieldElement s = zero;
        CalculusFieldElement c = zero;
        for (int i = 0; i < iMax; ++i) {
            Object p = this.getPoint(i);
            CalculusFieldElement w = this.getWeight(i);
            CalculusFieldElement f1 = f.value((CalculusFieldElement)p);
            CalculusFieldElement f2 = f.value((CalculusFieldElement)p.negate());
            CalculusFieldElement y = w.multiply((CalculusFieldElement)f1.add((CalculusFieldElement)f2)).subtract(c);
            CalculusFieldElement t = s.add(y);
            c = t.subtract(s).subtract(y);
            s = t;
        }
        if (ruleLength % 2 != 0) {
            CalculusFieldElement t;
            CalculusFieldElement w = this.getWeight(iMax);
            CalculusFieldElement y = w.multiply((CalculusFieldElement)f.value(zero)).subtract(c);
            s = t = s.add(y);
        }
        return (T)s;
    }
}

