/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import java.util.Arrays;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.analysis.integration.gauss.FieldRuleFactory;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Incrementor;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Pair;

public abstract class FieldAbstractRuleFactory<T extends CalculusFieldElement<T>>
implements FieldRuleFactory<T> {
    private final Field<T> field;
    private final SortedMap<Integer, Pair<T[], T[]>> pointsAndWeights;

    public FieldAbstractRuleFactory(Field<T> field) {
        this.field = field;
        this.pointsAndWeights = new TreeMap<Integer, Pair<T[], T[]>>();
    }

    public Field<T> getField() {
        return this.field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<T[], T[]> getRule(int numberOfPoints) throws MathIllegalArgumentException {
        Pair<T[], T[]> rule;
        if (numberOfPoints <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, numberOfPoints);
        }
        if (numberOfPoints > 1000) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, numberOfPoints, 1000);
        }
        SortedMap<Integer, Pair<T[], T[]>> sortedMap = this.pointsAndWeights;
        synchronized (sortedMap) {
            rule = (Pair<T[], T[]>)this.pointsAndWeights.get(numberOfPoints);
            if (rule == null) {
                rule = this.computeRule(numberOfPoints);
                this.pointsAndWeights.put(numberOfPoints, rule);
            }
        }
        return new Pair<Object, Object>(((CalculusFieldElement[])rule.getFirst()).clone(), ((CalculusFieldElement[])rule.getSecond()).clone());
    }

    protected abstract Pair<T[], T[]> computeRule(int var1) throws MathIllegalArgumentException;

    protected T[] findRoots(int n, CalculusFieldUnivariateFunction<T> ratioEvaluator) {
        double tol;
        double maxOffset;
        CalculusFieldElement[] roots = (CalculusFieldElement[])MathArrays.buildArray(this.field, (int)n);
        if (n == 1) {
            roots[0] = (CalculusFieldElement)this.field.getZero();
        } else if (n == 2) {
            roots[0] = (CalculusFieldElement)((CalculusFieldElement)this.field.getOne()).negate();
            roots[1] = (CalculusFieldElement)this.field.getOne();
        } else {
            CalculusFieldElement[] previousPoints = (CalculusFieldElement[])this.getRule(n - 1).getFirst();
            roots[0] = previousPoints[0];
            for (int i = 1; i < n - 1; ++i) {
                roots[i] = (CalculusFieldElement)previousPoints[i - 1].add(previousPoints[i]).multiply(0.5);
            }
            roots[n - 1] = previousPoints[n - 2];
        }
        CalculusFieldElement[] ratio = (CalculusFieldElement[])MathArrays.buildArray(this.field, (int)n);
        Incrementor incrementor = new Incrementor(1000);
        do {
            int i;
            incrementor.increment();
            for (i = 0; i < n; ++i) {
                ratio[i] = ratioEvaluator.value(roots[i]);
            }
            maxOffset = 0.0;
            for (i = 0; i < n; ++i) {
                CalculusFieldElement sum = (CalculusFieldElement)this.field.getZero();
                for (int j = 0; j < n; ++j) {
                    if (j == i) continue;
                    sum = (CalculusFieldElement)sum.add(roots[i].subtract(roots[j]).reciprocal());
                }
                CalculusFieldElement offset = (CalculusFieldElement)ratio[i].divide(((CalculusFieldElement)sum.multiply(ratio[i]).negate()).add(1.0));
                maxOffset = FastMath.max(maxOffset, FastMath.abs(offset).getReal());
                roots[i] = roots[i].subtract(offset);
            }
            tol = 0.0;
            for (CalculusFieldElement r : roots) {
                tol = FastMath.max(tol, FastMath.ulp(r.getReal()));
            }
        } while (maxOffset > tol);
        Arrays.sort(roots, (r1, r2) -> Double.compare(r1.getReal(), r2.getReal()));
        return roots;
    }

    protected void enforceSymmetry(T[] roots) {
        int n = roots.length;
        for (int i = 0; i < n / 2; ++i) {
            int idx = n - i - 1;
            CalculusFieldElement c = (CalculusFieldElement)((CalculusFieldElement)roots[i].subtract(roots[idx])).multiply(0.5);
            roots[i] = c;
            roots[idx] = (CalculusFieldElement)c.negate();
        }
        if (n % 2 != 0) {
            roots[n / 2] = (CalculusFieldElement)this.field.getZero();
        }
    }
}

