/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.function;

import java.util.Arrays;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.MathArrays;

public class StepFunction
implements UnivariateFunction {
    private final double[] abscissa;
    private final double[] ordinate;

    public StepFunction(double[] x, double[] y) throws MathIllegalArgumentException, NullArgumentException {
        if (x == null || y == null) {
            throw new NullArgumentException();
        }
        if (x.length == 0 || y.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NO_DATA, new Object[0]);
        }
        MathArrays.checkEqualLength(y, x);
        MathArrays.checkOrder(x);
        this.abscissa = (double[])x.clone();
        this.ordinate = (double[])y.clone();
    }

    @Override
    public double value(double x) {
        int index = Arrays.binarySearch(this.abscissa, x);
        if (index < -1) {
            return this.ordinate[-index - 2];
        }
        if (index >= 0) {
            return this.ordinate[index];
        }
        return this.ordinate[0];
    }
}

