/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import java.io.Serializable;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.UnivariateMatrixFunction;
import org.hipparchus.analysis.UnivariateVectorFunction;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableFunction;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableMatrixFunction;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableVectorFunction;
import org.hipparchus.analysis.differentiation.UnivariateFunctionDifferentiator;
import org.hipparchus.analysis.differentiation.UnivariateMatrixFunctionDifferentiator;
import org.hipparchus.analysis.differentiation.UnivariateVectorFunctionDifferentiator;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class FiniteDifferencesDifferentiator
implements UnivariateFunctionDifferentiator,
UnivariateVectorFunctionDifferentiator,
UnivariateMatrixFunctionDifferentiator,
Serializable {
    private static final long serialVersionUID = 20120917L;
    private final int nbPoints;
    private final double stepSize;
    private final double halfSampleSpan;
    private final double tMin;
    private final double tMax;

    public FiniteDifferencesDifferentiator(int nbPoints, double stepSize) throws MathIllegalArgumentException {
        this(nbPoints, stepSize, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public FiniteDifferencesDifferentiator(int nbPoints, double stepSize, double tLower, double tUpper) throws MathIllegalArgumentException {
        if (nbPoints <= 1) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, stepSize, 1);
        }
        this.nbPoints = nbPoints;
        if (stepSize <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, stepSize, 0);
        }
        this.stepSize = stepSize;
        this.halfSampleSpan = 0.5 * stepSize * (double)(nbPoints - 1);
        if (2.0 * this.halfSampleSpan >= tUpper - tLower) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, 2.0 * this.halfSampleSpan, tUpper - tLower);
        }
        double safety = FastMath.ulp(this.halfSampleSpan);
        this.tMin = tLower + this.halfSampleSpan + safety;
        this.tMax = tUpper - this.halfSampleSpan - safety;
    }

    public int getNbPoints() {
        return this.nbPoints;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    private <T extends Derivative<T>> T evaluate(T t, double t0, double[] y) throws MathIllegalArgumentException {
        double[] top = new double[this.nbPoints];
        double[] bottom = new double[this.nbPoints];
        for (int i = 0; i < this.nbPoints; ++i) {
            bottom[i] = y[i];
            for (int j = 1; j <= i; ++j) {
                bottom[i - j] = (bottom[i - j + 1] - bottom[i - j]) / ((double)j * this.stepSize);
            }
            top[i] = bottom[0];
        }
        Derivative interpolation = (Derivative)t.getField().getZero();
        Derivative monomial = null;
        for (int i = 0; i < this.nbPoints; ++i) {
            if (i == 0) {
                monomial = (Derivative)t.getField().getOne();
            } else {
                Derivative deltaX = (Derivative)t.subtract(t0 + (double)(i - 1) * this.stepSize);
                monomial = monomial.multiply(deltaX);
            }
            interpolation = (Derivative)interpolation.add(monomial.multiply(top[i]));
        }
        return (T)interpolation;
    }

    @Override
    public UnivariateDifferentiableFunction differentiate(final UnivariateFunction function) {
        return new UnivariateDifferentiableFunction(){

            @Override
            public double value(double x) throws MathIllegalArgumentException {
                return function.value(x);
            }

            @Override
            public <T extends Derivative<T>> T value(T t) throws MathIllegalArgumentException {
                if (t.getOrder() >= FiniteDifferencesDifferentiator.this.nbPoints) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, t.getOrder(), FiniteDifferencesDifferentiator.this.nbPoints);
                }
                double t0 = FastMath.max(FastMath.min(t.getValue(), FiniteDifferencesDifferentiator.this.tMax), FiniteDifferencesDifferentiator.this.tMin) - FiniteDifferencesDifferentiator.this.halfSampleSpan;
                double[] y = new double[FiniteDifferencesDifferentiator.this.nbPoints];
                for (int i = 0; i < FiniteDifferencesDifferentiator.this.nbPoints; ++i) {
                    y[i] = function.value(t0 + (double)i * FiniteDifferencesDifferentiator.this.stepSize);
                }
                return (T)FiniteDifferencesDifferentiator.this.evaluate(t, t0, y);
            }
        };
    }

    @Override
    public UnivariateDifferentiableVectorFunction differentiate(final UnivariateVectorFunction function) {
        return new UnivariateDifferentiableVectorFunction(){

            @Override
            public double[] value(double x) throws MathIllegalArgumentException {
                return function.value(x);
            }

            @Override
            public <T extends Derivative<T>> T[] value(T t) throws MathIllegalArgumentException {
                if (t.getOrder() >= FiniteDifferencesDifferentiator.this.nbPoints) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, t.getOrder(), FiniteDifferencesDifferentiator.this.nbPoints);
                }
                double t0 = FastMath.max(FastMath.min(t.getValue(), FiniteDifferencesDifferentiator.this.tMax), FiniteDifferencesDifferentiator.this.tMin) - FiniteDifferencesDifferentiator.this.halfSampleSpan;
                double[][] y = null;
                for (int i = 0; i < FiniteDifferencesDifferentiator.this.nbPoints; ++i) {
                    double[] v = function.value(t0 + (double)i * FiniteDifferencesDifferentiator.this.stepSize);
                    if (i == 0) {
                        y = new double[v.length][FiniteDifferencesDifferentiator.this.nbPoints];
                    }
                    for (int j = 0; j < v.length; ++j) {
                        y[j][i] = v[j];
                    }
                }
                Derivative[] value = (Derivative[])MathArrays.buildArray(t.getField(), (int)y.length);
                for (int j = 0; j < value.length; ++j) {
                    value[j] = FiniteDifferencesDifferentiator.this.evaluate(t, t0, y[j]);
                }
                return value;
            }
        };
    }

    @Override
    public UnivariateDifferentiableMatrixFunction differentiate(final UnivariateMatrixFunction function) {
        return new UnivariateDifferentiableMatrixFunction(){

            @Override
            public double[][] value(double x) throws MathIllegalArgumentException {
                return function.value(x);
            }

            @Override
            public <T extends Derivative<T>> T[][] value(T t) throws MathIllegalArgumentException {
                if (t.getOrder() >= FiniteDifferencesDifferentiator.this.nbPoints) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, t.getOrder(), FiniteDifferencesDifferentiator.this.nbPoints);
                }
                double t0 = FastMath.max(FastMath.min(t.getValue(), FiniteDifferencesDifferentiator.this.tMax), FiniteDifferencesDifferentiator.this.tMin) - FiniteDifferencesDifferentiator.this.halfSampleSpan;
                double[][][] y = null;
                for (int i = 0; i < FiniteDifferencesDifferentiator.this.nbPoints; ++i) {
                    double[][] v = function.value(t0 + (double)i * FiniteDifferencesDifferentiator.this.stepSize);
                    if (i == 0) {
                        y = new double[v.length][v[0].length][FiniteDifferencesDifferentiator.this.nbPoints];
                    }
                    for (int j = 0; j < v.length; ++j) {
                        for (int k = 0; k < v[j].length; ++k) {
                            y[j][k][i] = v[j][k];
                        }
                    }
                }
                Derivative[][] value = (Derivative[][])MathArrays.buildArray(t.getField(), (int)y.length, (int)y[0].length);
                for (int j = 0; j < value.length; ++j) {
                    for (int k = 0; k < y[j].length; ++k) {
                        value[j][k] = FiniteDifferencesDifferentiator.this.evaluate(t, t0, y[j][k]);
                    }
                }
                return value;
            }
        };
    }
}

