/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.nonlinear.vector.leastsquares;

import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.DecompositionSolver;
import org.hipparchus.linear.QRDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.util.FastMath;

public abstract class AbstractEvaluation
implements LeastSquaresProblem.Evaluation {
    private final int observationSize;

    public AbstractEvaluation(int observationSize) {
        this.observationSize = observationSize;
    }

    @Override
    public RealMatrix getCovariances(double threshold) {
        RealMatrix j = this.getJacobian();
        RealMatrix jTj = j.transposeMultiply(j);
        DecompositionSolver solver = new QRDecomposition(jTj, threshold).getSolver();
        return solver.getInverse();
    }

    @Override
    public RealVector getSigma(double covarianceSingularityThreshold) {
        RealMatrix cov = this.getCovariances(covarianceSingularityThreshold);
        int nC = cov.getColumnDimension();
        ArrayRealVector sig = new ArrayRealVector(nC);
        for (int i = 0; i < nC; ++i) {
            sig.setEntry(i, FastMath.sqrt((double)cov.getEntry(i, i)));
        }
        return sig;
    }

    @Override
    public double getRMS() {
        return FastMath.sqrt((double)this.getReducedChiSquare(1));
    }

    @Override
    public double getCost() {
        return FastMath.sqrt((double)this.getChiSquare());
    }

    @Override
    public double getChiSquare() {
        ArrayRealVector r = new ArrayRealVector(this.getResiduals());
        return r.dotProduct((RealVector)r);
    }

    @Override
    public double getReducedChiSquare(int numberOfFittedParameters) {
        return this.getChiSquare() / (double)(this.observationSize - numberOfFittedParameters + 1);
    }
}

