/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.frames.EOPHistory;
import org.orekit.time.BDTScale;
import org.orekit.time.GLONASSScale;
import org.orekit.time.GMSTScale;
import org.orekit.time.GPSScale;
import org.orekit.time.GalileoScale;
import org.orekit.time.IRNSSScale;
import org.orekit.time.LazyLoadedTimeScales;
import org.orekit.time.QZSSScale;
import org.orekit.time.TAIScale;
import org.orekit.time.TCBScale;
import org.orekit.time.TCGScale;
import org.orekit.time.TDBScale;
import org.orekit.time.TTScale;
import org.orekit.time.UT1Scale;
import org.orekit.time.UTCScale;
import org.orekit.time.UTCTAIOffsetsLoader;
import org.orekit.utils.IERSConventions;

public class TimeScalesFactory
implements Serializable {
    private static final long serialVersionUID = 20190927L;

    private TimeScalesFactory() {
    }

    @DefaultDataContext
    public static LazyLoadedTimeScales getTimeScales() {
        return DataContext.getDefault().getTimeScales();
    }

    @DefaultDataContext
    public static void addUTCTAIOffsetsLoader(UTCTAIOffsetsLoader loader) {
        TimeScalesFactory.getTimeScales().addUTCTAIOffsetsLoader(loader);
    }

    @DefaultDataContext
    public static void addDefaultUTCTAIOffsetsLoaders() {
        TimeScalesFactory.getTimeScales().addDefaultUTCTAIOffsetsLoaders();
    }

    @DefaultDataContext
    public static void clearUTCTAIOffsetsLoaders() {
        TimeScalesFactory.getTimeScales().clearUTCTAIOffsetsLoaders();
    }

    @DefaultDataContext
    public static TAIScale getTAI() {
        return TimeScalesFactory.getTimeScales().getTAI();
    }

    @DefaultDataContext
    public static UTCScale getUTC() {
        return TimeScalesFactory.getTimeScales().getUTC();
    }

    @DefaultDataContext
    public static UT1Scale getUT1(IERSConventions conventions, boolean simpleEOP) {
        return TimeScalesFactory.getTimeScales().getUT1(conventions, simpleEOP);
    }

    @DefaultDataContext
    public static UT1Scale getUT1(EOPHistory history) {
        return TimeScalesFactory.getTimeScales().getUT1(history);
    }

    @DefaultDataContext
    public static TTScale getTT() {
        return TimeScalesFactory.getTimeScales().getTT();
    }

    @DefaultDataContext
    public static GalileoScale getGST() {
        return TimeScalesFactory.getTimeScales().getGST();
    }

    @DefaultDataContext
    public static GLONASSScale getGLONASS() {
        return TimeScalesFactory.getTimeScales().getGLONASS();
    }

    @DefaultDataContext
    public static QZSSScale getQZSS() {
        return TimeScalesFactory.getTimeScales().getQZSS();
    }

    @DefaultDataContext
    public static GPSScale getGPS() {
        return TimeScalesFactory.getTimeScales().getGPS();
    }

    @DefaultDataContext
    public static TCGScale getTCG() {
        return TimeScalesFactory.getTimeScales().getTCG();
    }

    @DefaultDataContext
    public static TDBScale getTDB() {
        return TimeScalesFactory.getTimeScales().getTDB();
    }

    @DefaultDataContext
    public static TCBScale getTCB() {
        return TimeScalesFactory.getTimeScales().getTCB();
    }

    @DefaultDataContext
    public static GMSTScale getGMST(IERSConventions conventions, boolean simpleEOP) {
        return TimeScalesFactory.getTimeScales().getGMST(conventions, simpleEOP);
    }

    @DefaultDataContext
    public static IRNSSScale getIRNSS() {
        return TimeScalesFactory.getTimeScales().getIRNSS();
    }

    @DefaultDataContext
    public static BDTScale getBDT() {
        return TimeScalesFactory.getTimeScales().getBDT();
    }
}

