/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.ArrayList;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.hipparchus.util.FastMath;
import org.orekit.time.AbsoluteDate;

public class ShortPeriodicsInterpolatedCoefficient {
    private ArrayList<double[]> values;
    private ArrayList<AbsoluteDate> abscissae;
    private int interpolationPoints;
    private int latestClosestNeighbor;

    public ShortPeriodicsInterpolatedCoefficient(int interpolationPoints) {
        this.interpolationPoints = interpolationPoints;
        this.abscissae = new ArrayList();
        this.values = new ArrayList();
        this.latestClosestNeighbor = 0;
    }

    public double[] value(AbsoluteDate date) {
        int[] neighbors = this.getNeighborsIndices(date);
        HermiteInterpolator interpolator = new HermiteInterpolator();
        for (int i : neighbors) {
            interpolator.addSamplePoint(this.abscissae.get(i).durationFrom(date), (double[][])new double[][]{this.values.get(i)});
        }
        return interpolator.value(0.0);
    }

    private int[] getNeighborsIndices(AbsoluteDate date) {
        int sizeofNeighborhood = FastMath.min((int)this.interpolationPoints, (int)this.abscissae.size());
        int[] neighborsIndices = new int[sizeofNeighborhood];
        if (this.interpolationPoints >= this.abscissae.size()) {
            for (int i = 0; i < sizeofNeighborhood; ++i) {
                neighborsIndices[i] = i;
            }
        } else {
            int inf = this.getClosestNeighbor(date);
            int sup = inf + 1;
            while (sup - inf < this.interpolationPoints) {
                double upperNeighborDistance;
                if (inf == 0) {
                    ++sup;
                    continue;
                }
                if (sup >= this.abscissae.size()) {
                    --inf;
                    continue;
                }
                double lowerNeighborDistance = FastMath.abs((double)this.abscissae.get(inf - 1).durationFrom(date));
                if (lowerNeighborDistance <= (upperNeighborDistance = FastMath.abs((double)this.abscissae.get(sup).durationFrom(date)))) {
                    --inf;
                    continue;
                }
                ++sup;
            }
            for (int i = 0; i < this.interpolationPoints; ++i) {
                neighborsIndices[i] = inf + i;
            }
        }
        return neighborsIndices;
    }

    private int getClosestNeighbor(AbsoluteDate date) {
        int closestNeighbor = this.latestClosestNeighbor;
        if (date.compareTo(this.abscissae.get(0)) <= 0) {
            closestNeighbor = 0;
        } else if (date.compareTo(this.abscissae.get(this.abscissae.size() - 1)) >= 0) {
            closestNeighbor = this.abscissae.size() - 1;
        } else {
            double upperDistance;
            double lowerDistance;
            int lowerBorder = this.latestClosestNeighbor;
            int upperBorder = this.latestClosestNeighbor;
            int searchDirection = date.compareTo(this.abscissae.get(this.latestClosestNeighbor));
            if (searchDirection > 0) {
                ++upperBorder;
                while (date.compareTo(this.abscissae.get(upperBorder)) > 0) {
                    ++upperBorder;
                    ++lowerBorder;
                }
            } else {
                --lowerBorder;
                while (date.compareTo(this.abscissae.get(lowerBorder)) < 0) {
                    --upperBorder;
                    --lowerBorder;
                }
            }
            closestNeighbor = (lowerDistance = FastMath.abs((double)date.durationFrom(this.abscissae.get(lowerBorder)))) < (upperDistance = FastMath.abs((double)date.durationFrom(this.abscissae.get(upperBorder)))) ? lowerBorder : upperBorder;
        }
        this.latestClosestNeighbor = closestNeighbor;
        return closestNeighbor;
    }

    public void clearHistory() {
        this.abscissae.clear();
        this.values.clear();
    }

    public void addGridPoint(AbsoluteDate date, double[] value) {
        if (this.abscissae.isEmpty()) {
            this.abscissae.add(date);
            this.values.add(value);
        } else if (this.abscissae.contains(date)) {
            this.values.set(this.abscissae.indexOf(date), value);
        } else {
            int closestNeighbor = this.getClosestNeighbor(date);
            int index = date.compareTo(this.abscissae.get(closestNeighbor)) < 0 ? closestNeighbor : closestNeighbor + 1;
            this.abscissae.add(index, date);
            this.values.add(index, value);
        }
    }
}

