/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.QRDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.Precision;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.forces.ForceModel;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.integration.CombinedDerivatives;
import org.orekit.propagation.numerical.NumericalGradientConverter;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.ParameterDriver;

class StateTransitionMatrixGenerator
implements AdditionalDerivativesProvider {
    private static final double THRESHOLD = Precision.SAFE_MIN;
    private static final int SPACE_DIMENSION = 3;
    public static final int STATE_DIMENSION = 6;
    private final String stmName;
    private final List<ForceModel> forceModels;
    private final AttitudeProvider attitudeProvider;
    private final Map<String, PartialsObserver> partialsObservers;

    StateTransitionMatrixGenerator(String stmName, List<ForceModel> forceModels, AttitudeProvider attitudeProvider) {
        this.stmName = stmName;
        this.forceModels = forceModels;
        this.attitudeProvider = attitudeProvider;
        this.partialsObservers = new HashMap<String, PartialsObserver>();
    }

    void addObserver(String name, PartialsObserver observer) {
        this.partialsObservers.put(name, observer);
    }

    @Override
    public String getName() {
        return this.stmName;
    }

    @Override
    public int getDimension() {
        return 36;
    }

    @Override
    public boolean yield(SpacecraftState state) {
        return !state.hasAdditionalState(this.getName());
    }

    SpacecraftState setInitialStateTransitionMatrix(SpacecraftState state, RealMatrix dYdY0, OrbitType orbitType, PositionAngle positionAngle) {
        RealMatrix dCdY0;
        RealMatrix nonNullDYdY0;
        if (dYdY0 == null) {
            nonNullDYdY0 = MatrixUtils.createRealIdentityMatrix((int)6);
        } else {
            if (dYdY0.getRowDimension() != 6 || dYdY0.getColumnDimension() != 6) {
                throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH_2x2, dYdY0.getRowDimension(), dYdY0.getColumnDimension(), 6, 6);
            }
            nonNullDYdY0 = dYdY0;
        }
        if (state.isOrbitDefined()) {
            double[][] dYdC = new double[6][6];
            orbitType.convertType(state.getOrbit()).getJacobianWrtCartesian(positionAngle, dYdC);
            dCdY0 = new QRDecomposition(MatrixUtils.createRealMatrix((double[][])dYdC), THRESHOLD).getSolver().solve(nonNullDYdY0);
        } else {
            dCdY0 = nonNullDYdY0;
        }
        double[] flat = new double[36];
        int k = 0;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                flat[k++] = dCdY0.getEntry(i, j);
            }
        }
        return state.addAdditionalState(this.stmName, flat);
    }

    @Override
    @Deprecated
    public double[] derivatives(SpacecraftState state) {
        return this.combinedDerivatives(state).getAdditionalDerivatives();
    }

    @Override
    public CombinedDerivatives combinedDerivatives(SpacecraftState state) {
        double[] factor = this.computePartials(state);
        double[] p = state.getAdditionalState(this.getName());
        double[] pDot = new double[p.length];
        StateTransitionMatrixGenerator.multiplyMatrix(factor, p, pDot, 6);
        return new CombinedDerivatives(pDot, null);
    }

    static void multiplyMatrix(double[] factor, double[] x, double[] y, int columns) {
        int n = 3 * columns;
        System.arraycopy(x, n, y, 0, n);
        for (int j = 0; j < columns; ++j) {
            y[n + j] = factor[0] * x[j] + factor[1] * x[j + columns] + factor[2] * x[j + 2 * columns] + factor[3] * x[j + 3 * columns] + factor[4] * x[j + 4 * columns] + factor[5] * x[j + 5 * columns];
            y[n + j + columns] = factor[6] * x[j] + factor[7] * x[j + columns] + factor[8] * x[j + 2 * columns] + factor[9] * x[j + 3 * columns] + factor[10] * x[j + 4 * columns] + factor[11] * x[j + 5 * columns];
            y[n + j + 2 * columns] = factor[12] * x[j] + factor[13] * x[j + columns] + factor[14] * x[j + 2 * columns] + factor[15] * x[j + 3 * columns] + factor[16] * x[j + 4 * columns] + factor[17] * x[j + 5 * columns];
        }
    }

    private double[] computePartials(SpacecraftState state) {
        double[] factor = new double[18];
        DoubleArrayDictionary accelerationPartials = new DoubleArrayDictionary();
        NumericalGradientConverter fullConverter = new NumericalGradientConverter(state, 6, this.attitudeProvider);
        NumericalGradientConverter posOnlyConverter = new NumericalGradientConverter(state, 3, this.attitudeProvider);
        for (ForceModel forceModel : this.forceModels) {
            DoubleArrayDictionary.Entry entry;
            NumericalGradientConverter converter = forceModel.dependsOnPositionOnly() ? posOnlyConverter : fullConverter;
            FieldSpacecraftState<Gradient> dsState = converter.getState(forceModel);
            Gradient[] parameters = converter.getParameters(dsState, forceModel);
            FieldVector3D acceleration = forceModel.acceleration(dsState, (CalculusFieldElement[])parameters);
            double[] gradX = ((Gradient)acceleration.getX()).getGradient();
            double[] gradY = ((Gradient)acceleration.getY()).getGradient();
            double[] gradZ = ((Gradient)acceleration.getZ()).getGradient();
            factor[0] = factor[0] + gradX[0];
            factor[1] = factor[1] + gradX[1];
            factor[2] = factor[2] + gradX[2];
            factor[6] = factor[6] + gradY[0];
            factor[7] = factor[7] + gradY[1];
            factor[8] = factor[8] + gradY[2];
            factor[12] = factor[12] + gradZ[0];
            factor[13] = factor[13] + gradZ[1];
            factor[14] = factor[14] + gradZ[2];
            if (!forceModel.dependsOnPositionOnly()) {
                factor[3] = factor[3] + gradX[3];
                factor[4] = factor[4] + gradX[4];
                factor[5] = factor[5] + gradX[5];
                factor[9] = factor[9] + gradY[3];
                factor[10] = factor[10] + gradY[4];
                factor[11] = factor[11] + gradY[5];
                factor[15] = factor[15] + gradZ[3];
                factor[16] = factor[16] + gradZ[4];
                factor[17] = factor[17] + gradZ[5];
            }
            int paramsIndex = converter.getFreeStateParameters();
            for (ParameterDriver parameterDriver : forceModel.getParametersDrivers()) {
                if (!parameterDriver.isSelected()) continue;
                entry = accelerationPartials.getEntry(parameterDriver.getName());
                if (entry == null) {
                    accelerationPartials.put(parameterDriver.getName(), new double[3]);
                    entry = accelerationPartials.getEntry(parameterDriver.getName());
                }
                entry.increment(new double[]{gradX[paramsIndex], gradY[paramsIndex], gradZ[paramsIndex]});
                ++paramsIndex;
            }
            for (Map.Entry entry2 : this.partialsObservers.entrySet()) {
                entry = accelerationPartials.getEntry((String)entry2.getKey());
                ((PartialsObserver)entry2.getValue()).partialsComputed(state, factor, entry == null ? new double[3] : entry.getValue());
            }
        }
        return factor;
    }

    public static interface PartialsObserver {
        public void partialsComputed(SpacecraftState var1, double[] var2, double[] var3);
    }
}

