/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.ode.DenseOutputModel;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.ODEIntegrator;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.SecondaryODE;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.EventHandlerConfiguration;
import org.hipparchus.ode.events.ODEEventHandler;
import org.hipparchus.ode.sampling.AbstractODEStateInterpolator;
import org.hipparchus.ode.sampling.ODEStateInterpolator;
import org.hipparchus.ode.sampling.ODEStepHandler;
import org.hipparchus.util.Precision;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.AbstractPropagator;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.EphemerisGenerator;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.integration.AdditionalEquationsAdapter;
import org.orekit.propagation.integration.CombinedDerivatives;
import org.orekit.propagation.integration.IntegratedEphemeris;
import org.orekit.propagation.integration.StateMapper;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.DoubleArrayDictionary;

public abstract class AbstractIntegratedPropagator
extends AbstractPropagator {
    private static final String SECONDARY_DIMENSION = "Orekit-secondary-dimension";
    private final List<EventDetector> detectors = new ArrayList<EventDetector>();
    private final List<StoringStepHandler> ephemerisGenerators = new ArrayList<StoringStepHandler>();
    private final ODEIntegrator integrator;
    private final Map<String, Integer> secondaryOffsets;
    private List<AdditionalDerivativesProvider> additionalDerivativesProviders = new ArrayList<AdditionalDerivativesProvider>();
    private int calls;
    private StateMapper stateMapper;
    private boolean resetAtEnd;
    private PropagationType propagationType;

    protected AbstractIntegratedPropagator(ODEIntegrator integrator, PropagationType propagationType) {
        this.secondaryOffsets = new HashMap<String, Integer>();
        this.integrator = integrator;
        this.propagationType = propagationType;
        this.resetAtEnd = true;
    }

    public void setResetAtEnd(boolean resetAtEnd) {
        this.resetAtEnd = resetAtEnd;
    }

    protected void initMapper() {
        this.stateMapper = this.createMapper(null, Double.NaN, null, null, null, null);
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        super.setAttitudeProvider(attitudeProvider);
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), attitudeProvider, this.stateMapper.getFrame());
    }

    protected void setOrbitType(OrbitType orbitType) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), orbitType, this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    protected OrbitType getOrbitType() {
        return this.stateMapper.getOrbitType();
    }

    @Deprecated
    protected PropagationType isMeanOrbit() {
        return this.getPropagationType();
    }

    public PropagationType getPropagationType() {
        return this.propagationType;
    }

    protected void setPositionAngleType(PositionAngle positionAngleType) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), positionAngleType, this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    protected PositionAngle getPositionAngleType() {
        return this.stateMapper.getPositionAngleType();
    }

    public void setMu(double mu) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), mu, this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    public double getMu() {
        return this.stateMapper.getMu();
    }

    public int getCalls() {
        return this.calls;
    }

    @Override
    public boolean isAdditionalStateManaged(String name) {
        if (super.isAdditionalStateManaged(name)) {
            return true;
        }
        for (AdditionalDerivativesProvider provider : this.additionalDerivativesProviders) {
            if (!provider.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getManagedAdditionalStates() {
        String[] alreadyIntegrated = super.getManagedAdditionalStates();
        String[] managed = new String[alreadyIntegrated.length + this.additionalDerivativesProviders.size()];
        System.arraycopy(alreadyIntegrated, 0, managed, 0, alreadyIntegrated.length);
        for (int i = 0; i < this.additionalDerivativesProviders.size(); ++i) {
            managed[i + alreadyIntegrated.length] = this.additionalDerivativesProviders.get(i).getName();
        }
        return managed;
    }

    @Deprecated
    public void addAdditionalEquations(AdditionalEquations additional) {
        this.addAdditionalDerivativesProvider(new AdditionalEquationsAdapter(additional, this::getInitialState));
    }

    public void addAdditionalDerivativesProvider(AdditionalDerivativesProvider provider) {
        if (this.isAdditionalStateManaged(provider.getName())) {
            throw new OrekitException((Localizable)OrekitMessages.ADDITIONAL_STATE_NAME_ALREADY_IN_USE, provider.getName());
        }
        this.additionalDerivativesProviders.add(provider);
        this.secondaryOffsets.clear();
    }

    public List<AdditionalDerivativesProvider> getAdditionalDerivativesProviders() {
        return Collections.unmodifiableList(this.additionalDerivativesProviders);
    }

    public void addEventDetector(EventDetector detector) {
        this.detectors.add(detector);
    }

    @Override
    public Collection<EventDetector> getEventsDetectors() {
        return Collections.unmodifiableCollection(this.detectors);
    }

    @Override
    public void clearEventsDetectors() {
        this.detectors.clear();
    }

    protected void setUpUserEventDetectors() {
        for (EventDetector detector : this.detectors) {
            this.setUpEventDetector(this.integrator, detector);
        }
    }

    protected void setUpEventDetector(ODEIntegrator integ, EventDetector detector) {
        integ.addEventHandler((ODEEventHandler)new AdaptedEventDetector(detector), detector.getMaxCheckInterval(), detector.getThreshold(), detector.getMaxIterationCount());
    }

    @Override
    public EphemerisGenerator getEphemerisGenerator() {
        StoringStepHandler storingHandler = new StoringStepHandler();
        this.ephemerisGenerators.add(storingHandler);
        return storingHandler;
    }

    protected abstract StateMapper createMapper(AbsoluteDate var1, double var2, OrbitType var4, PositionAngle var5, AttitudeProvider var6, Frame var7);

    protected abstract MainStateEquations getMainStateEquations(ODEIntegrator var1);

    @Override
    public SpacecraftState propagate(AbsoluteDate target) {
        if (this.getStartDate() == null) {
            if (this.getInitialState() == null) {
                throw new OrekitException((Localizable)OrekitMessages.INITIAL_STATE_NOT_SPECIFIED_FOR_ORBIT_PROPAGATION, new Object[0]);
            }
            this.setStartDate(this.getInitialState().getDate());
        }
        return this.propagate(this.getStartDate(), target);
    }

    @Override
    public SpacecraftState propagate(AbsoluteDate tStart, AbsoluteDate tEnd) {
        if (this.getInitialState() == null) {
            throw new OrekitException((Localizable)OrekitMessages.INITIAL_STATE_NOT_SPECIFIED_FOR_ORBIT_PROPAGATION, new Object[0]);
        }
        try (IntegratorResetter resetter = new IntegratorResetter(this.integrator);){
            SpacecraftState finalState;
            this.setUpStmAndJacobianGenerators();
            this.initializeAdditionalStates(tEnd);
            if (!tStart.equals(this.getInitialState().getDate())) {
                try (Iterator<StoringStepHandler> startResetter = new IntegratorResetter(this.integrator);){
                    this.integrateDynamics(tStart);
                }
            }
            this.setUpUserEventDetectors();
            for (OrekitStepHandler handler : this.getMultiplexer().getHandlers()) {
                this.integrator.addStepHandler((ODEStepHandler)new AdaptedStepHandler(handler));
            }
            for (StoringStepHandler generator : this.ephemerisGenerators) {
                generator.setEndDate(tEnd);
                this.integrator.addStepHandler((ODEStepHandler)generator);
            }
            SpacecraftState spacecraftState = finalState = this.integrateDynamics(tEnd);
            return spacecraftState;
        }
    }

    protected void setUpStmAndJacobianGenerators() {
    }

    private SpacecraftState integrateDynamics(AbsoluteDate tEnd) {
        try {
            this.initializePropagation();
            if (this.getInitialState().getDate().equals(tEnd)) {
                return this.getInitialState();
            }
            this.stateMapper = this.createMapper(this.getInitialState().getDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.getInitialState().getFrame());
            if (Double.isNaN(this.getMu())) {
                this.setMu(this.getInitialState().getMu());
            }
            if (this.getInitialState().getMass() <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.SPACECRAFT_MASS_BECOMES_NEGATIVE, this.getInitialState().getMass());
            }
            SpacecraftState initialIntegrationState = this.getInitialIntegrationState();
            ODEState mathInitialState = this.createInitialState(initialIntegrationState);
            ExpandableODE mathODE = this.createODE(this.integrator, mathInitialState);
            this.beforeIntegration(initialIntegrationState, tEnd);
            ODEStateAndDerivative mathFinalState = this.integrator.integrate(mathODE, mathInitialState, tEnd.durationFrom(this.getInitialState().getDate()));
            this.afterIntegration();
            SpacecraftState finalState = this.stateMapper.mapArrayToState(this.stateMapper.mapDoubleToDate(mathFinalState.getTime(), tEnd), mathFinalState.getPrimaryState(), mathFinalState.getPrimaryDerivative(), this.propagationType);
            if (!this.additionalDerivativesProviders.isEmpty()) {
                double[] secondary = mathFinalState.getSecondaryState(1);
                double[] secondaryDerivatives = mathFinalState.getSecondaryDerivative(1);
                for (AdditionalDerivativesProvider provider : this.additionalDerivativesProviders) {
                    String name = provider.getName();
                    int offset = this.secondaryOffsets.get(name);
                    int dimension = provider.getDimension();
                    finalState = finalState.addAdditionalState(name, Arrays.copyOfRange(secondary, offset, offset + dimension)).addAdditionalStateDerivative(name, Arrays.copyOfRange(secondaryDerivatives, offset, offset + dimension));
                }
            }
            finalState = this.updateAdditionalStates(finalState);
            if (this.resetAtEnd) {
                this.resetInitialState(finalState);
                this.setStartDate(finalState.getDate());
            }
            return finalState;
        }
        catch (MathRuntimeException mre) {
            throw OrekitException.unwrap(mre);
        }
    }

    protected SpacecraftState getInitialIntegrationState() {
        return this.getInitialState();
    }

    private ODEState createInitialState(SpacecraftState initialState) {
        double[] primary = new double[this.getBasicDimension()];
        this.stateMapper.mapStateToArray(initialState, primary, null);
        if (this.secondaryOffsets.isEmpty()) {
            int offset = 0;
            for (AdditionalDerivativesProvider provider : this.additionalDerivativesProviders) {
                this.secondaryOffsets.put(provider.getName(), offset);
                offset += provider.getDimension();
            }
            this.secondaryOffsets.put(SECONDARY_DIMENSION, offset);
        }
        return new ODEState(0.0, primary, this.secondary(initialState));
    }

    private double[][] secondary(SpacecraftState state) {
        if (this.secondaryOffsets.isEmpty()) {
            return null;
        }
        double[][] secondary = new double[1][this.secondaryOffsets.get(SECONDARY_DIMENSION).intValue()];
        for (AdditionalDerivativesProvider provider : this.additionalDerivativesProviders) {
            String name = provider.getName();
            int offset = this.secondaryOffsets.get(name);
            double[] additional = state.getAdditionalState(name);
            System.arraycopy(additional, 0, secondary[0], offset, additional.length);
        }
        return secondary;
    }

    private double[][] secondaryDerivative(SpacecraftState state) {
        if (this.secondaryOffsets.isEmpty()) {
            return null;
        }
        double[][] secondaryDerivative = new double[1][this.secondaryOffsets.get(SECONDARY_DIMENSION).intValue()];
        for (AdditionalDerivativesProvider provider : this.additionalDerivativesProviders) {
            String name = provider.getName();
            int offset = this.secondaryOffsets.get(name);
            double[] additionalDerivative = state.getAdditionalStateDerivative(name);
            System.arraycopy(additionalDerivative, 0, secondaryDerivative[0], offset, additionalDerivative.length);
        }
        return secondaryDerivative;
    }

    private ExpandableODE createODE(ODEIntegrator integ, ODEState mathInitialState) {
        ExpandableODE ode = new ExpandableODE((OrdinaryDifferentialEquation)new ConvertedMainStateEquations(this.getMainStateEquations(integ)));
        if (!this.additionalDerivativesProviders.isEmpty()) {
            ode.addSecondaryEquations((SecondaryODE)new ConvertedSecondaryStateEquations());
        }
        return ode;
    }

    protected void beforeIntegration(SpacecraftState initialState, AbsoluteDate tEnd) {
    }

    protected void afterIntegration() {
    }

    public int getBasicDimension() {
        return 7;
    }

    protected ODEIntegrator getIntegrator() {
        return this.integrator;
    }

    private SpacecraftState convert(ODEStateAndDerivative os) {
        SpacecraftState s = this.stateMapper.mapArrayToState(os.getTime(), os.getPrimaryState(), os.getPrimaryDerivative(), this.propagationType);
        if (os.getNumberOfSecondaryStates() > 0) {
            double[] secondary = os.getSecondaryState(1);
            double[] secondaryDerivative = os.getSecondaryDerivative(1);
            for (AdditionalDerivativesProvider provider : this.additionalDerivativesProviders) {
                String name = provider.getName();
                int offset = this.secondaryOffsets.get(name);
                int dimension = provider.getDimension();
                s = s.addAdditionalState(name, Arrays.copyOfRange(secondary, offset, offset + dimension));
                s = s.addAdditionalStateDerivative(name, Arrays.copyOfRange(secondaryDerivative, offset, offset + dimension));
            }
        }
        s = this.updateAdditionalStates(s);
        return s;
    }

    private ODEStateAndDerivative convert(SpacecraftState state) {
        double[] primary = new double[this.getBasicDimension()];
        double[] primaryDot = new double[this.getBasicDimension()];
        this.stateMapper.mapStateToArray(state, primary, primaryDot);
        double[][] secondary = this.secondary(state);
        double[][] secondaryDerivative = this.secondaryDerivative(state);
        return new ODEStateAndDerivative(this.stateMapper.mapDateToDouble(state.getDate()), primary, primaryDot, secondary, secondaryDerivative);
    }

    private static class IntegratorResetter
    implements AutoCloseable {
        private final ODEIntegrator integrator;
        private final List<EventHandlerConfiguration> eventHandlersConfigurations;
        private final List<ODEStepHandler> stepHandlers;

        IntegratorResetter(ODEIntegrator integrator) {
            this.integrator = integrator;
            this.eventHandlersConfigurations = new ArrayList<EventHandlerConfiguration>(integrator.getEventHandlersConfigurations());
            this.stepHandlers = new ArrayList<ODEStepHandler>(integrator.getStepHandlers());
        }

        @Override
        public void close() {
            this.integrator.clearEventHandlers();
            this.eventHandlersConfigurations.forEach(c -> this.integrator.addEventHandler(c.getEventHandler(), c.getMaxCheckInterval(), c.getConvergence(), c.getMaxIterationCount(), c.getSolver()));
            this.integrator.clearStepHandlers();
            this.stepHandlers.forEach(stepHandler -> this.integrator.addStepHandler(stepHandler));
        }
    }

    private class StoringStepHandler
    implements ODEStepHandler,
    EphemerisGenerator {
        private DenseOutputModel model;
        private AbsoluteDate endDate;
        private BoundedPropagator ephemeris;
        private ODEStateInterpolator lastInterpolator;

        private StoringStepHandler() {
        }

        public void setEndDate(AbsoluteDate endDate) {
            this.endDate = endDate;
        }

        public void init(ODEStateAndDerivative s0, double t) {
            this.model = new DenseOutputModel();
            this.model.init(s0, t);
            this.ephemeris = null;
            this.lastInterpolator = null;
        }

        @Override
        public BoundedPropagator getGeneratedEphemeris() {
            this.buildEphemeris();
            return this.ephemeris;
        }

        public void handleStep(ODEStateInterpolator interpolator) {
            this.model.handleStep(interpolator);
            this.lastInterpolator = interpolator;
        }

        public void finish(ODEStateAndDerivative finalState) {
            this.buildEphemeris();
        }

        private void buildEphemeris() {
            AbsoluteDate maxDate;
            AbsoluteDate minDate;
            this.model.finish(this.lastInterpolator.getCurrentState());
            double tI = this.model.getInitialTime();
            double tF = this.model.getFinalTime();
            AbsoluteDate startDate = AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(tI);
            AbsoluteDate finalDate = AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(tF, this.endDate);
            if (tF < tI) {
                minDate = finalDate;
                maxDate = startDate;
            } else {
                minDate = startDate;
                maxDate = finalDate;
            }
            DoubleArrayDictionary unmanaged = new DoubleArrayDictionary();
            for (DoubleArrayDictionary.Entry initial : AbstractIntegratedPropagator.this.getInitialState().getAdditionalStatesValues().getData()) {
                if (AbstractIntegratedPropagator.this.isAdditionalStateManaged(initial.getKey())) continue;
                unmanaged.put(initial.getKey(), initial.getValue());
            }
            String[] names = new String[AbstractIntegratedPropagator.this.additionalDerivativesProviders.size()];
            int[] dimensions = new int[AbstractIntegratedPropagator.this.additionalDerivativesProviders.size()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = ((AdditionalDerivativesProvider)AbstractIntegratedPropagator.this.additionalDerivativesProviders.get(i)).getName();
                dimensions[i] = ((AdditionalDerivativesProvider)AbstractIntegratedPropagator.this.additionalDerivativesProviders.get(i)).getDimension();
            }
            this.ephemeris = new IntegratedEphemeris(startDate, minDate, maxDate, AbstractIntegratedPropagator.this.stateMapper, AbstractIntegratedPropagator.this.propagationType, this.model, unmanaged, AbstractIntegratedPropagator.this.getAdditionalStateProviders(), names, dimensions);
        }
    }

    private class AdaptedStepInterpolator
    implements OrekitStepInterpolator {
        private final ODEStateInterpolator mathInterpolator;

        AdaptedStepInterpolator(ODEStateInterpolator mathInterpolator) {
            this.mathInterpolator = mathInterpolator;
        }

        @Override
        public SpacecraftState getPreviousState() {
            return AbstractIntegratedPropagator.this.convert(this.mathInterpolator.getPreviousState());
        }

        @Override
        public boolean isPreviousStateInterpolated() {
            return this.mathInterpolator.isPreviousStateInterpolated();
        }

        @Override
        public SpacecraftState getCurrentState() {
            return AbstractIntegratedPropagator.this.convert(this.mathInterpolator.getCurrentState());
        }

        @Override
        public boolean isCurrentStateInterpolated() {
            return this.mathInterpolator.isCurrentStateInterpolated();
        }

        @Override
        public SpacecraftState getInterpolatedState(AbsoluteDate date) {
            return AbstractIntegratedPropagator.this.convert(this.mathInterpolator.getInterpolatedState(date.durationFrom(AbstractIntegratedPropagator.this.stateMapper.getReferenceDate())));
        }

        @Override
        public boolean isForward() {
            return this.mathInterpolator.isForward();
        }

        @Override
        public AdaptedStepInterpolator restrictStep(SpacecraftState newPreviousState, SpacecraftState newCurrentState) {
            try {
                AbstractODEStateInterpolator aosi = (AbstractODEStateInterpolator)this.mathInterpolator;
                return new AdaptedStepInterpolator((ODEStateInterpolator)aosi.restrictStep(AbstractIntegratedPropagator.this.convert(newPreviousState), AbstractIntegratedPropagator.this.convert(newCurrentState)));
            }
            catch (ClassCastException cce) {
                throw new OrekitInternalError(cce);
            }
        }
    }

    private class AdaptedStepHandler
    implements ODEStepHandler {
        private final OrekitStepHandler handler;

        AdaptedStepHandler(OrekitStepHandler handler) {
            this.handler = handler;
        }

        public void init(ODEStateAndDerivative s0, double t) {
            this.handler.init(AbstractIntegratedPropagator.this.convert(s0), AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(t));
        }

        public void handleStep(ODEStateInterpolator interpolator) {
            this.handler.handleStep(new AdaptedStepInterpolator(interpolator));
        }

        public void finish(ODEStateAndDerivative finalState) {
            this.handler.finish(AbstractIntegratedPropagator.this.convert(finalState));
        }
    }

    private class AdaptedEventDetector
    implements ODEEventHandler {
        private final EventDetector detector;
        private double lastT;
        private double lastG;

        AdaptedEventDetector(EventDetector detector) {
            this.detector = detector;
            this.lastT = Double.NaN;
            this.lastG = Double.NaN;
        }

        public void init(ODEStateAndDerivative s0, double t) {
            this.detector.init(AbstractIntegratedPropagator.this.convert(s0), AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(t));
            this.lastT = Double.NaN;
            this.lastG = Double.NaN;
        }

        public double g(ODEStateAndDerivative s) {
            if (!Precision.equals((double)this.lastT, (double)s.getTime(), (int)0)) {
                this.lastT = s.getTime();
                this.lastG = this.detector.g(AbstractIntegratedPropagator.this.convert(s));
            }
            return this.lastG;
        }

        public Action eventOccurred(ODEStateAndDerivative s, boolean increasing) {
            return this.detector.eventOccurred(AbstractIntegratedPropagator.this.convert(s), increasing);
        }

        public ODEState resetState(ODEStateAndDerivative s) {
            SpacecraftState oldState = AbstractIntegratedPropagator.this.convert(s);
            SpacecraftState newState = this.detector.resetState(oldState);
            AbstractIntegratedPropagator.this.stateChanged(newState);
            double[] primary = new double[s.getPrimaryStateDimension()];
            AbstractIntegratedPropagator.this.stateMapper.mapStateToArray(newState, primary, null);
            double[][] secondary = new double[1][((Integer)AbstractIntegratedPropagator.this.secondaryOffsets.get(AbstractIntegratedPropagator.SECONDARY_DIMENSION)).intValue()];
            for (AdditionalDerivativesProvider provider : AbstractIntegratedPropagator.this.additionalDerivativesProviders) {
                String name = provider.getName();
                int offset = (Integer)AbstractIntegratedPropagator.this.secondaryOffsets.get(name);
                int dimension = provider.getDimension();
                System.arraycopy(newState.getAdditionalState(name), 0, secondary[0], offset, dimension);
            }
            return new ODEState(newState.getDate().durationFrom(AbstractIntegratedPropagator.this.getStartDate()), primary, secondary);
        }
    }

    private class ConvertedSecondaryStateEquations
    implements SecondaryODE {
        private final int combinedDimension;

        ConvertedSecondaryStateEquations() {
            this.combinedDimension = (Integer)AbstractIntegratedPropagator.this.secondaryOffsets.get(AbstractIntegratedPropagator.SECONDARY_DIMENSION);
        }

        public int getDimension() {
            return this.combinedDimension;
        }

        public void init(double t0, double[] primary0, double[] secondary0, double finalTime) {
            SpacecraftState initialState = this.convert(t0, primary0, null, secondary0);
            AbsoluteDate target = AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(finalTime);
            for (AdditionalDerivativesProvider provider : AbstractIntegratedPropagator.this.additionalDerivativesProviders) {
                provider.init(initialState, target);
            }
        }

        public double[] computeDerivatives(double t, double[] primary, double[] primaryDot, double[] secondary) {
            SpacecraftState updated = this.convert(t, primary, primaryDot, secondary);
            LinkedList<AdditionalDerivativesProvider> pending = new LinkedList<AdditionalDerivativesProvider>(AbstractIntegratedPropagator.this.additionalDerivativesProviders);
            double[] secondaryDot = new double[this.combinedDimension];
            int yieldCount = 0;
            while (!pending.isEmpty()) {
                AdditionalDerivativesProvider provider = (AdditionalDerivativesProvider)pending.remove();
                if (provider.yield(updated)) {
                    pending.add(provider);
                    if (++yieldCount < pending.size()) continue;
                    break;
                }
                String name = provider.getName();
                int offset = (Integer)AbstractIntegratedPropagator.this.secondaryOffsets.get(name);
                int dimension = provider.getDimension();
                CombinedDerivatives derivatives = provider.combinedDerivatives(updated);
                double[] additionalPart = derivatives.getAdditionalDerivatives();
                double[] mainPart = derivatives.getMainStateDerivativesIncrements();
                System.arraycopy(additionalPart, 0, secondaryDot, offset, dimension);
                updated = updated.addAdditionalStateDerivative(name, additionalPart);
                if (mainPart != null) {
                    for (int i = 0; i < mainPart.length; ++i) {
                        int n = i;
                        primaryDot[n] = primaryDot[n] + mainPart[i];
                    }
                }
                yieldCount = 0;
            }
            return secondaryDot;
        }

        private SpacecraftState convert(double t, double[] primary, double[] primaryDot, double[] secondary) {
            SpacecraftState initialState = AbstractIntegratedPropagator.this.stateMapper.mapArrayToState(t, primary, primaryDot, PropagationType.MEAN);
            for (AdditionalDerivativesProvider provider : AbstractIntegratedPropagator.this.additionalDerivativesProviders) {
                String name = provider.getName();
                int offset = (Integer)AbstractIntegratedPropagator.this.secondaryOffsets.get(name);
                int dimension = provider.getDimension();
                initialState = initialState.addAdditionalState(name, Arrays.copyOfRange(secondary, offset, offset + dimension));
            }
            return AbstractIntegratedPropagator.this.updateAdditionalStates(initialState);
        }
    }

    private class ConvertedMainStateEquations
    implements OrdinaryDifferentialEquation {
        private final MainStateEquations main;

        ConvertedMainStateEquations(MainStateEquations main) {
            this.main = main;
            AbstractIntegratedPropagator.this.calls = 0;
        }

        public int getDimension() {
            return AbstractIntegratedPropagator.this.getBasicDimension();
        }

        public void init(double t0, double[] y0, double finalTime) {
            SpacecraftState initialState = AbstractIntegratedPropagator.this.stateMapper.mapArrayToState(t0, y0, null, PropagationType.MEAN);
            initialState = AbstractIntegratedPropagator.this.updateAdditionalStates(initialState);
            AbsoluteDate target = AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(finalTime);
            this.main.init(initialState, target);
        }

        public double[] computeDerivatives(double t, double[] y) {
            ++AbstractIntegratedPropagator.this.calls;
            SpacecraftState currentState = AbstractIntegratedPropagator.this.stateMapper.mapArrayToState(t, y, null, PropagationType.MEAN);
            currentState = AbstractIntegratedPropagator.this.updateAdditionalStates(currentState);
            return this.main.computeDerivatives(currentState);
        }
    }

    public static interface MainStateEquations {
        default public void init(SpacecraftState initialState, AbsoluteDate target) {
        }

        public double[] computeDerivatives(SpacecraftState var1);
    }
}

