/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.ode.events.Action;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;

public class FieldRecordAndContinue<T extends FieldEventDetector<E>, E extends CalculusFieldElement<E>>
implements FieldEventHandler<T, E> {
    private final List<Event<T, E>> events;

    public FieldRecordAndContinue() {
        this(new ArrayList<Event<T, E>>());
    }

    public FieldRecordAndContinue(List<Event<T, E>> events) {
        this.events = events;
    }

    public List<Event<T, E>> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public void clear() {
        this.events.clear();
    }

    @Override
    public Action eventOccurred(FieldSpacecraftState<E> s, T detector, boolean increasing) {
        this.events.add(new Event(detector, s, increasing));
        return Action.CONTINUE;
    }

    public static class Event<T, F extends CalculusFieldElement<F>> {
        private final FieldSpacecraftState<F> state;
        private final T detector;
        private final boolean increasing;

        private Event(T detector, FieldSpacecraftState<F> state, boolean increasing) {
            this.detector = detector;
            this.state = state;
            this.increasing = increasing;
        }

        public T getDetector() {
            return this.detector;
        }

        public boolean isIncreasing() {
            return this.increasing;
        }

        public FieldSpacecraftState<F> getState() {
            return this.state;
        }

        public String toString() {
            return "Event{state=" + this.state + ", increasing=" + this.increasing + ", detector=" + this.detector + '}';
        }
    }
}

