/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.ode.events.Action;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.propagation.FieldAbstractPropagator;
import org.orekit.propagation.FieldAdditionalStateProvider;
import org.orekit.propagation.FieldBoundedPropagator;
import org.orekit.propagation.FieldEphemerisGenerator;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.FieldEventState;
import org.orekit.propagation.sampling.FieldOrekitStepInterpolator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public abstract class FieldAbstractAnalyticalPropagator<T extends CalculusFieldElement<T>>
extends FieldAbstractPropagator<T> {
    private FieldPVCoordinatesProvider<T> pvProvider;
    private FieldAbsoluteDate<T> lastPropagationStart;
    private FieldAbsoluteDate<T> lastPropagationEnd;
    private boolean statesInitialized;
    private boolean isLastStep;
    private final Collection<FieldEventState<?, T>> eventsStates;

    protected FieldAbstractAnalyticalPropagator(Field<T> field, AttitudeProvider attitudeProvider) {
        super(field);
        this.setAttitudeProvider(attitudeProvider);
        this.pvProvider = new FieldLocalPVProvider();
        this.lastPropagationStart = FieldAbsoluteDate.getPastInfinity(field);
        this.lastPropagationEnd = FieldAbsoluteDate.getFutureInfinity(field);
        this.statesInitialized = false;
        this.eventsStates = new ArrayList();
    }

    @Override
    public FieldEphemerisGenerator<T> getEphemerisGenerator() {
        return () -> new FieldBoundedPropagatorView(this.lastPropagationStart, this.lastPropagationEnd);
    }

    @Override
    public <D extends FieldEventDetector<T>> void addEventDetector(D detector) {
        this.eventsStates.add(new FieldEventState(detector));
    }

    @Override
    public Collection<FieldEventDetector<T>> getEventsDetectors() {
        ArrayList list = new ArrayList();
        for (FieldEventState<?, T> state : this.eventsStates) {
            list.add(state.getEventDetector());
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public void clearEventsDetectors() {
        this.eventsStates.clear();
    }

    @Override
    public FieldSpacecraftState<T> propagate(FieldAbsoluteDate<T> start, FieldAbsoluteDate<T> target) {
        try {
            this.initializePropagation();
            this.lastPropagationStart = start;
            this.initializeAdditionalStates(target);
            boolean isForward = target.compareTo(start) >= 0;
            FieldSpacecraftState<T> state = this.updateAdditionalStates(this.basicPropagate(start));
            for (FieldEventState<?, T> es : this.eventsStates) {
                es.init(state, target);
            }
            this.getMultiplexer().init(state, target);
            this.statesInitialized = false;
            this.isLastStep = false;
            do {
                FieldSpacecraftState<T> previous = state;
                FieldSpacecraftState<T> current = this.updateAdditionalStates(this.basicPropagate(target));
                FieldBasicStepInterpolator interpolator = new FieldBasicStepInterpolator(isForward, previous, current);
                state = this.acceptStep(interpolator, target);
                state = this.updateAdditionalStates(this.basicPropagate(state.getDate()));
            } while (!this.isLastStep);
            this.lastPropagationEnd = state.getDate();
            this.setStartDate(state.getDate());
            return state;
        }
        catch (MathRuntimeException mrte) {
            throw OrekitException.unwrap(mrte);
        }
    }

    protected FieldSpacecraftState<T> acceptStep(FieldBasicStepInterpolator interpolator, FieldAbsoluteDate<T> target) throws MathRuntimeException {
        FieldSpacecraftState previous = interpolator.getPreviousState();
        FieldSpacecraftState current = interpolator.getCurrentState();
        FieldOrekitStepInterpolator restricted = interpolator;
        if (!this.statesInitialized) {
            if (!this.eventsStates.isEmpty()) {
                for (FieldEventState<?, T> state : this.eventsStates) {
                    state.reinitializeBegin(interpolator);
                }
            }
            this.statesInitialized = true;
        }
        final int orderingSign = interpolator.isForward() ? 1 : -1;
        PriorityQueue occurringEvents = new PriorityQueue(new Comparator<FieldEventState<?, T>>(){

            @Override
            public int compare(FieldEventState<?, T> es0, FieldEventState<?, T> es1) {
                return orderingSign * es0.getEventDate().compareTo(es1.getEventDate());
            }
        });
        boolean doneWithStep = false;
        block1: do {
            occurringEvents.clear();
            for (FieldEventState state : this.eventsStates) {
                if (!state.evaluateStep(interpolator)) continue;
                occurringEvents.add(state);
            }
            block3: while (true) {
                if (!occurringEvents.isEmpty()) {
                    FieldEventState currentEvent = (FieldEventState)occurringEvents.poll();
                    FieldSpacecraftState eventState = ((FieldBasicStepInterpolator)restricted).getInterpolatedState(currentEvent.getEventDate());
                    restricted = ((FieldBasicStepInterpolator)restricted).restrictStep(previous, eventState);
                    for (FieldEventState state : this.eventsStates) {
                        if (state == currentEvent || !state.tryAdvance(eventState, interpolator)) continue;
                        occurringEvents.remove(state);
                        occurringEvents.add(state);
                        occurringEvents.add(currentEvent);
                        continue block3;
                    }
                    this.getMultiplexer().handleStep(restricted);
                    FieldEventState.EventOccurrence occurrence = currentEvent.doEvent(eventState);
                    Action action = occurrence.getAction();
                    boolean bl = this.isLastStep = action == Action.STOP;
                    if (this.isLastStep) {
                        FieldSpacecraftState savedState = eventState;
                        eventState = interpolator.getInterpolatedState(occurrence.getStopDate());
                        restricted = ((FieldBasicStepInterpolator)restricted).restrictStep(savedState, eventState);
                        this.getMultiplexer().handleStep(restricted);
                        this.getMultiplexer().finish(((FieldBasicStepInterpolator)restricted).getCurrentState());
                    }
                    if (this.isLastStep) {
                        return eventState;
                    }
                    if (action == Action.RESET_DERIVATIVES || action == Action.RESET_STATE) {
                        FieldSpacecraftState resetState = occurrence.getNewState();
                        this.resetIntermediateState(resetState, interpolator.isForward());
                        return resetState;
                    }
                    previous = eventState;
                    restricted = new FieldBasicStepInterpolator(((FieldBasicStepInterpolator)restricted).isForward(), eventState, current);
                    if (action == Action.RESET_EVENTS) continue block1;
                    if (!currentEvent.evaluateStep(restricted)) continue;
                    occurringEvents.add(currentEvent);
                    continue;
                }
                for (FieldEventState state : this.eventsStates) {
                    if (!state.tryAdvance(current, interpolator)) continue;
                    occurringEvents.add(state);
                }
                if (occurringEvents.isEmpty()) break;
            }
            doneWithStep = true;
        } while (!doneWithStep);
        this.isLastStep = target.equals(current.getDate());
        this.getMultiplexer().handleStep(restricted);
        if (this.isLastStep) {
            this.getMultiplexer().finish(((FieldBasicStepInterpolator)restricted).getCurrentState());
        }
        return current;
    }

    protected abstract T getMass(FieldAbsoluteDate<T> var1);

    public FieldPVCoordinatesProvider<T> getPvProvider() {
        return this.pvProvider;
    }

    protected abstract void resetIntermediateState(FieldSpacecraftState<T> var1, boolean var2);

    protected abstract FieldOrbit<T> propagateOrbit(FieldAbsoluteDate<T> var1, T[] var2);

    protected abstract List<ParameterDriver> getParametersDrivers();

    public T[] getParameters(Field<T> field) {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        CalculusFieldElement[] parameters = (CalculusFieldElement[])MathArrays.buildArray(field, (int)drivers.size());
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(drivers.get(i).getValue());
        }
        return parameters;
    }

    protected FieldSpacecraftState<T> basicPropagate(FieldAbsoluteDate<T> date) {
        try {
            FieldOrbit orbit = this.propagateOrbit(date, this.getParameters(date.getField()));
            FieldAttitude<T> attitude = this.getAttitudeProvider().getAttitude(this.pvProvider, date, orbit.getFrame());
            return new FieldSpacecraftState<T>(orbit, attitude, this.getMass(date));
        }
        catch (OrekitException oe) {
            throw new OrekitException(oe);
        }
    }

    private class FieldBasicStepInterpolator
    implements FieldOrekitStepInterpolator<T> {
        private final FieldSpacecraftState<T> previousState;
        private final FieldSpacecraftState<T> currentState;
        private final boolean forward;

        FieldBasicStepInterpolator(boolean isForward, FieldSpacecraftState<T> previousState, FieldSpacecraftState<T> currentState) {
            this.forward = isForward;
            this.previousState = previousState;
            this.currentState = currentState;
        }

        @Override
        public FieldSpacecraftState<T> getPreviousState() {
            return this.previousState;
        }

        @Override
        public FieldSpacecraftState<T> getCurrentState() {
            return this.currentState;
        }

        @Override
        public FieldSpacecraftState<T> getInterpolatedState(FieldAbsoluteDate<T> date) {
            FieldSpacecraftState basicState = FieldAbstractAnalyticalPropagator.this.basicPropagate(date);
            return FieldAbstractAnalyticalPropagator.this.updateAdditionalStates(basicState);
        }

        @Override
        public boolean isForward() {
            return this.forward;
        }

        public FieldBasicStepInterpolator restrictStep(FieldSpacecraftState<T> newPreviousState, FieldSpacecraftState<T> newCurrentState) {
            return new FieldBasicStepInterpolator(this.forward, newPreviousState, newCurrentState);
        }
    }

    private class FieldBoundedPropagatorView
    extends FieldAbstractAnalyticalPropagator<T>
    implements FieldBoundedPropagator<T> {
        private final FieldAbsoluteDate<T> minDate;
        private final FieldAbsoluteDate<T> maxDate;

        FieldBoundedPropagatorView(FieldAbsoluteDate<T> startDate, FieldAbsoluteDate<T> endDate) {
            super(startDate.durationFrom(endDate).getField(), FieldAbstractAnalyticalPropagator.this.getAttitudeProvider());
            super.resetInitialState(FieldAbstractAnalyticalPropagator.this.getInitialState());
            if (startDate.compareTo(endDate) <= 0) {
                this.minDate = startDate;
                this.maxDate = endDate;
            } else {
                this.minDate = endDate;
                this.maxDate = startDate;
            }
            try {
                for (FieldAdditionalStateProvider provider : FieldAbstractAnalyticalPropagator.this.getAdditionalStateProviders()) {
                    this.addAdditionalStateProvider(provider);
                }
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(null);
            }
        }

        @Override
        public FieldAbsoluteDate<T> getMinDate() {
            return this.minDate;
        }

        @Override
        public FieldAbsoluteDate<T> getMaxDate() {
            return this.maxDate;
        }

        @Override
        protected FieldOrbit<T> propagateOrbit(FieldAbsoluteDate<T> target, T[] parameters) {
            return FieldAbstractAnalyticalPropagator.this.propagateOrbit(target, (CalculusFieldElement[])parameters);
        }

        @Override
        public T getMass(FieldAbsoluteDate<T> date) {
            return FieldAbstractAnalyticalPropagator.this.getMass(date);
        }

        @Override
        public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> date, Frame frame) {
            return this.propagate(date).getPVCoordinates(frame);
        }

        @Override
        public void resetInitialState(FieldSpacecraftState<T> state) {
            super.resetInitialState(state);
            FieldAbstractAnalyticalPropagator.this.resetInitialState(state);
        }

        @Override
        protected void resetIntermediateState(FieldSpacecraftState<T> state, boolean forward) {
            FieldAbstractAnalyticalPropagator.this.resetIntermediateState(state, forward);
        }

        @Override
        public FieldSpacecraftState<T> getInitialState() {
            return FieldAbstractAnalyticalPropagator.this.getInitialState();
        }

        @Override
        public Frame getFrame() {
            return FieldAbstractAnalyticalPropagator.this.getFrame();
        }

        @Override
        protected List<ParameterDriver> getParametersDrivers() {
            return FieldAbstractAnalyticalPropagator.this.getParametersDrivers();
        }
    }

    private class FieldLocalPVProvider
    implements FieldPVCoordinatesProvider<T> {
        private FieldLocalPVProvider() {
        }

        @Override
        public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> date, Frame frame) {
            return FieldAbstractAnalyticalPropagator.this.propagateOrbit(date, FieldAbstractAnalyticalPropagator.this.getParameters(date.getField())).getPVCoordinates(frame);
        }
    }
}

