/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.AllowedSolution;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.analysis.solvers.FieldBracketingNthOrderBrentSolver;
import org.hipparchus.analysis.solvers.UnivariateSolverUtils;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

class L2TransformProvider
implements TransformProvider {
    private static final double RELATIVE_ACCURACY = 1.0E-14;
    private static final double ABSOLUTE_ACCURACY = 0.001;
    private static final double FUNCTION_ACCURACY = 0.0;
    private static final int MAX_ORDER = 5;
    private static final int MAX_EVALUATIONS = 1000;
    private static final long serialVersionUID = 20170725L;
    private final Frame frame;
    private final CelestialBody primaryBody;
    private final CelestialBody secondaryBody;

    L2TransformProvider(CelestialBody primaryBody, CelestialBody secondaryBody) {
        this.primaryBody = primaryBody;
        this.secondaryBody = secondaryBody;
        this.frame = primaryBody.getInertiallyOrientedFrame();
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        TimeStampedPVCoordinates pv21 = this.secondaryBody.getPVCoordinates(date, this.frame);
        Vector3D translation = this.getL2(pv21.getPosition()).negate();
        Rotation rotation = new Rotation(pv21.getPosition(), pv21.getVelocity(), Vector3D.PLUS_I, Vector3D.PLUS_J);
        return new Transform(date, new Transform(date, translation), new Transform(date, rotation));
    }

    @Override
    public StaticTransform getStaticTransform(AbsoluteDate date) {
        TimeStampedPVCoordinates pv21 = this.secondaryBody.getPVCoordinates(date, this.frame);
        Vector3D translation = this.getL2(pv21.getPosition()).negate();
        Rotation rotation = new Rotation(pv21.getPosition(), pv21.getVelocity(), Vector3D.PLUS_I, Vector3D.PLUS_J);
        return StaticTransform.compose(date, StaticTransform.of(date, translation), StaticTransform.of(date, rotation));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        TimeStampedFieldPVCoordinates<T> pv21 = this.secondaryBody.getPVCoordinates(date, this.frame);
        FieldVector3D translation = this.getL2(pv21.getPosition()).negate();
        Field field = pv21.getPosition().getX().getField();
        FieldRotation rotation = new FieldRotation(pv21.getPosition(), pv21.getVelocity(), FieldVector3D.getPlusI((Field)field), FieldVector3D.getPlusJ((Field)field));
        return new FieldTransform<T>(date, new FieldTransform<T>(date, translation), new FieldTransform<T>(date, rotation));
    }

    private Vector3D getL2(Vector3D primaryToSecondary) {
        double massRatio = this.secondaryBody.getGM() / this.primaryBody.getGM();
        double bigR = primaryToSecondary.getNorm();
        double baseR = bigR * (FastMath.cbrt((double)(massRatio / 3.0)) + 1.0);
        UnivariateFunction l2Equation = r -> {
            double rminusbigR = r - bigR;
            double lhs1 = 1.0 / (r * r);
            double lhs2 = massRatio / (rminusbigR * rminusbigR);
            double rhs1 = 1.0 / (bigR * bigR);
            double rhs2 = (1.0 + massRatio) * rminusbigR * rhs1 / bigR;
            return lhs1 + lhs2 - (rhs1 + rhs2);
        };
        double[] searchInterval = UnivariateSolverUtils.bracket((UnivariateFunction)l2Equation, (double)baseR, (double)0.0, (double)(2.0 * bigR), (double)(0.01 * bigR), (double)1.0, (int)1000);
        BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(1.0E-14, 0.001, 0.0, 5);
        double r2 = solver.solve(1000, l2Equation, searchInterval[0], searchInterval[1], AllowedSolution.ANY_SIDE);
        return new Vector3D(r2 / bigR, primaryToSecondary);
    }

    private <T extends CalculusFieldElement<T>> FieldVector3D<T> getL2(FieldVector3D<T> primaryToSecondary) {
        double massRatio = this.secondaryBody.getGM() / this.primaryBody.getGM();
        CalculusFieldElement bigR = primaryToSecondary.getNorm();
        CalculusFieldElement baseR = (CalculusFieldElement)bigR.multiply(FastMath.cbrt((double)(massRatio / 3.0)) + 1.0);
        CalculusFieldUnivariateFunction l2Equation = r -> {
            CalculusFieldElement rminusbigR = (CalculusFieldElement)r.subtract((FieldElement)bigR);
            CalculusFieldElement lhs1 = (CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)r)).reciprocal();
            CalculusFieldElement lhs2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rminusbigR.multiply((FieldElement)rminusbigR)).reciprocal()).multiply(massRatio);
            CalculusFieldElement rhs1 = (CalculusFieldElement)((CalculusFieldElement)bigR.multiply((FieldElement)bigR)).reciprocal();
            CalculusFieldElement rhs2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rminusbigR.multiply((FieldElement)rhs1)).multiply(1.0 + massRatio)).divide((FieldElement)bigR);
            return (CalculusFieldElement)((CalculusFieldElement)lhs1.add((FieldElement)lhs2)).subtract((FieldElement)((CalculusFieldElement)rhs1.add((FieldElement)rhs2)));
        };
        CalculusFieldElement zero = (CalculusFieldElement)primaryToSecondary.getX().getField().getZero();
        CalculusFieldElement[] searchInterval = UnivariateSolverUtils.bracket((CalculusFieldUnivariateFunction)l2Equation, (CalculusFieldElement)baseR, (CalculusFieldElement)zero, (CalculusFieldElement)((CalculusFieldElement)bigR.multiply(2)), (CalculusFieldElement)((CalculusFieldElement)bigR.multiply(0.01)), (CalculusFieldElement)((CalculusFieldElement)zero.add(1.0)), (int)1000);
        CalculusFieldElement relativeAccuracy = (CalculusFieldElement)zero.add(1.0E-14);
        CalculusFieldElement absoluteAccuracy = (CalculusFieldElement)zero.add(0.001);
        CalculusFieldElement functionAccuracy = (CalculusFieldElement)zero.add(0.0);
        FieldBracketingNthOrderBrentSolver solver = new FieldBracketingNthOrderBrentSolver(relativeAccuracy, absoluteAccuracy, functionAccuracy, 5);
        CalculusFieldElement r2 = solver.solve(1000, l2Equation, searchInterval[0], searchInterval[1], AllowedSolution.ANY_SIDE);
        return new FieldVector3D((CalculusFieldElement)r2.divide((FieldElement)bigR), primaryToSecondary);
    }
}

