/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.jacobians;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.forces.maneuvers.Maneuver;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.integration.CombinedDerivatives;
import org.orekit.time.AbsoluteDate;

public class MassDepletionDelay
implements AdditionalDerivativesProvider {
    public static final String PREFIX = "Orekit-depletion-";
    private final String depletionName;
    private final boolean manageStart;
    private final Maneuver maneuver;
    private boolean forward;

    public MassDepletionDelay(String triggerName, boolean manageStart, Maneuver maneuver) {
        this.depletionName = PREFIX + triggerName;
        this.manageStart = manageStart;
        this.maneuver = maneuver;
    }

    @Override
    public String getName() {
        return this.depletionName;
    }

    @Override
    public int getDimension() {
        return 6;
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        this.forward = target.isAfterOrEqualTo(initialState);
    }

    @Override
    @Deprecated
    public double[] derivatives(SpacecraftState state) {
        return this.combinedDerivatives(state).getAdditionalDerivatives();
    }

    @Override
    public CombinedDerivatives combinedDerivatives(SpacecraftState state) {
        double[] p = state.getAdditionalState(this.getName());
        double[] pDot = new double[6];
        if (this.forward == this.manageStart) {
            double[] parameters = this.maneuver.getParameters();
            Vector3D acceleration = this.maneuver.acceleration(state, parameters);
            double minusQ = this.maneuver.getPropulsionModel().getMassDerivatives(state, parameters);
            double m = state.getMass();
            double ratio = minusQ / m;
            pDot[0] = p[3];
            pDot[1] = p[4];
            pDot[2] = p[5];
            pDot[3] = ratio * acceleration.getX();
            pDot[4] = ratio * acceleration.getY();
            pDot[5] = ratio * acceleration.getZ();
        }
        return new CombinedDerivatives(pDot, null);
    }
}

