/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.jacobians;

import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.SpacecraftState;

public class Duration
implements AdditionalStateProvider {
    private final String startName;
    private final String stopName;
    private final String columnName;

    public Duration(String startName, String stopName, String columnName) {
        this.startName = startName;
        this.stopName = stopName;
        this.columnName = columnName;
    }

    @Override
    public String getName() {
        return this.columnName;
    }

    @Override
    public boolean yield(SpacecraftState state) {
        return !state.hasAdditionalState(this.startName) || !state.hasAdditionalState(this.stopName);
    }

    @Override
    public double[] getAdditionalState(SpacecraftState state) {
        double[] dYdT0 = state.getAdditionalState(this.startName);
        double[] dYdT1 = state.getAdditionalState(this.stopName);
        double[] dYdTm = new double[dYdT0.length];
        for (int i = 0; i < dYdTm.length; ++i) {
            dYdTm[i] = 0.5 * (dYdT1[i] - dYdT0[i]);
        }
        return dYdTm;
    }
}

