/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.forces.maneuvers.Maneuver;
import org.orekit.forces.maneuvers.propulsion.AbstractConstantThrustPropulsionModel;
import org.orekit.forces.maneuvers.propulsion.BasicConstantThrustPropulsionModel;
import org.orekit.forces.maneuvers.propulsion.ThrustDirectionAndAttitudeProvider;
import org.orekit.forces.maneuvers.trigger.EventBasedManeuverTriggers;
import org.orekit.forces.maneuvers.trigger.ManeuverTriggers;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.EventDetector;

public class ConfigurableLowThrustManeuver
extends Maneuver {
    private static String THRUST_MODEL_IDENTIFIER = "ConfigurableLowThrustManeuver";
    private final ThrustDirectionAndAttitudeProvider thrustDirectionProvider;

    public ConfigurableLowThrustManeuver(ThrustDirectionAndAttitudeProvider thrustDirectionProvider, AbstractDetector<? extends EventDetector> startFiringDetector, AbstractDetector<? extends EventDetector> stopFiringDetector, double thrust, double isp) {
        this(thrustDirectionProvider, new EventBasedManeuverTriggers(startFiringDetector, stopFiringDetector), thrust, isp);
    }

    public ConfigurableLowThrustManeuver(ThrustDirectionAndAttitudeProvider thrustDirectionProvider, ManeuverTriggers trigger, double thrust, double isp) {
        super(thrustDirectionProvider.getManeuverAttitudeProvider(), trigger, ConfigurableLowThrustManeuver.buildBasicConstantThrustPropulsionModel(thrust, isp, thrustDirectionProvider.getThrusterAxisInSatelliteFrame()));
        this.thrustDirectionProvider = thrustDirectionProvider;
    }

    private static BasicConstantThrustPropulsionModel buildBasicConstantThrustPropulsionModel(double thrust, double isp, Vector3D thrusterAxisInSatelliteFrame) {
        return new BasicConstantThrustPropulsionModel(thrust, isp, thrusterAxisInSatelliteFrame, THRUST_MODEL_IDENTIFIER);
    }

    public ThrustDirectionAndAttitudeProvider getThrustDirectionProvider() {
        return this.thrustDirectionProvider;
    }

    public double getThrust() {
        return ((AbstractConstantThrustPropulsionModel)this.getPropulsionModel()).getThrustVector().getNorm();
    }

    public double getISP() {
        return ((AbstractConstantThrustPropulsionModel)this.getPropulsionModel()).getIsp();
    }
}

