/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ilrs;

import java.io.IOException;
import java.util.List;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.general.EphemerisFile;
import org.orekit.files.general.EphemerisFileWriter;
import org.orekit.files.ilrs.CPFHeader;
import org.orekit.files.ilrs.StreamingCpfWriter;
import org.orekit.time.TimeScale;
import org.orekit.utils.TimeStampedPVCoordinates;

public class CPFWriter
implements EphemerisFileWriter {
    private final CPFHeader header;
    private final TimeScale timescale;
    private final boolean velocityFlag;

    public CPFWriter(CPFHeader header, TimeScale timescale) {
        this(header, timescale, false);
    }

    public CPFWriter(CPFHeader header, TimeScale timescale, boolean velocityFlag) {
        this.header = header;
        this.timescale = timescale;
        this.velocityFlag = velocityFlag;
    }

    @Override
    public <C extends TimeStampedPVCoordinates, S extends EphemerisFile.EphemerisSegment<C>> void write(Appendable writer, EphemerisFile<C, S> ephemerisFile) throws IOException {
        if (writer == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NULL_ARGUMENT, "writer");
        }
        if (ephemerisFile == null) {
            return;
        }
        EphemerisFile.SatelliteEphemeris<C, S> satEphem = ephemerisFile.getSatellites().get(this.header.getIlrsSatelliteId());
        List<S> segments = satEphem.getSegments();
        StreamingCpfWriter cpfWriter = new StreamingCpfWriter(writer, this.timescale, this.header, this.velocityFlag);
        cpfWriter.writeHeader();
        for (EphemerisFile.EphemerisSegment segment : segments) {
            StreamingCpfWriter.Segment segmentWriter = cpfWriter.newSegment(this.header.getRefFrame());
            for (TimeStampedPVCoordinates coordinates : segment.getCoordinates()) {
                segmentWriter.writeEphemerisLine(coordinates);
            }
        }
        cpfWriter.writeEndOfFile();
    }
}

