/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.tdm;

import java.util.ArrayList;
import java.util.List;
import org.orekit.files.ccsds.ndm.tdm.Observation;
import org.orekit.files.ccsds.ndm.tdm.ObservationType;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.Data;
import org.orekit.time.AbsoluteDate;

public class ObservationsBlock
extends CommentsContainer
implements Data {
    private AbsoluteDate currentObservationEpoch;
    private List<Observation> observations = new ArrayList<Observation>();

    boolean addObservationEpoch(AbsoluteDate epoch) {
        this.refuseFurtherComments();
        this.currentObservationEpoch = epoch;
        return true;
    }

    AbsoluteDate getCurrentObservationEpoch() {
        return this.currentObservationEpoch;
    }

    void addObservationValue(ObservationType type, double measurement) {
        this.addObservation(type, this.currentObservationEpoch, measurement);
        this.currentObservationEpoch = null;
    }

    public List<Observation> getObservations() {
        return this.observations;
    }

    public void setObservations(List<Observation> observations) {
        this.refuseFurtherComments();
        this.observations = new ArrayList<Observation>(observations);
    }

    public void addObservation(Observation observation) {
        this.refuseFurtherComments();
        this.observations.add(observation);
    }

    public void addObservation(ObservationType type, AbsoluteDate epoch, double measurement) {
        this.addObservation(new Observation(type, epoch, measurement));
    }
}

