/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm;

import org.hipparchus.exception.Localizable;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.NdmConstituent;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public abstract class OdmParser<T extends NdmConstituent<?, ?>, P extends OdmParser<T, ?>>
extends AbstractConstituentParser<T, P> {
    private final AbsoluteDate missionReferenceDate;
    private final double muSet;
    private double muParsed;
    private double muCreated;

    protected OdmParser(String root, String formatVersionKey, IERSConventions conventions, boolean simpleEOP, DataContext dataContext, AbsoluteDate missionReferenceDate, double mu, ParsedUnitsBehavior parsedUnitsBehavior) {
        super(root, formatVersionKey, conventions, simpleEOP, dataContext, parsedUnitsBehavior);
        this.missionReferenceDate = missionReferenceDate;
        this.muSet = mu;
        this.muParsed = Double.NaN;
        this.muCreated = Double.NaN;
    }

    public AbsoluteDate getMissionReferenceDate() {
        return this.missionReferenceDate;
    }

    protected double getMuSet() {
        return this.muSet;
    }

    protected void setMuParsed(double muParsed) {
        this.muParsed = muParsed;
    }

    protected void setMuCreated(double muCreated) {
        this.muCreated = muCreated;
    }

    public double getSelectedMu() {
        if (!Double.isNaN(this.muParsed)) {
            return this.muParsed;
        }
        if (!Double.isNaN(this.muSet)) {
            return this.muSet;
        }
        if (!Double.isNaN(this.muCreated)) {
            return this.muCreated;
        }
        throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_GM, new Object[0]);
    }
}

