/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.cdm;

import java.util.ArrayList;
import java.util.List;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.cdm.AdditionalParameters;
import org.orekit.files.ccsds.ndm.cdm.AdditionalParametersKey;
import org.orekit.files.ccsds.ndm.cdm.Cdm;
import org.orekit.files.ccsds.ndm.cdm.CdmData;
import org.orekit.files.ccsds.ndm.cdm.CdmHeader;
import org.orekit.files.ccsds.ndm.cdm.CdmHeaderProcessingState;
import org.orekit.files.ccsds.ndm.cdm.CdmMetadata;
import org.orekit.files.ccsds.ndm.cdm.CdmMetadataKey;
import org.orekit.files.ccsds.ndm.cdm.CdmRelativeMetadata;
import org.orekit.files.ccsds.ndm.cdm.CdmRelativeMetadataKey;
import org.orekit.files.ccsds.ndm.cdm.CdmSegment;
import org.orekit.files.ccsds.ndm.cdm.ODParameters;
import org.orekit.files.ccsds.ndm.cdm.ODParametersKey;
import org.orekit.files.ccsds.ndm.cdm.RTNCovariance;
import org.orekit.files.ccsds.ndm.cdm.RTNCovarianceKey;
import org.orekit.files.ccsds.ndm.cdm.StateVector;
import org.orekit.files.ccsds.ndm.cdm.StateVectorKey;
import org.orekit.files.ccsds.ndm.cdm.XmlSubStructureKey;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.KvnStructureProcessingState;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.XmlStructureProcessingState;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser;
import org.orekit.files.ccsds.utils.parsing.ProcessingState;
import org.orekit.utils.IERSConventions;

public class CdmParser
extends AbstractConstituentParser<Cdm, CdmParser> {
    private static String COMMENT = "COMMENT";
    private static String RELATIVEMETADATA = "relativeMetadataData";
    private static String METADATA = "metadata";
    private CdmHeader header;
    private List<CdmSegment> segments;
    private CdmMetadata metadata;
    private CdmRelativeMetadata relativeMetadata;
    private ContextBinding context;
    private CommentsContainer commentsBlock;
    private ODParameters odParameters;
    private AdditionalParameters addParameters;
    private StateVector stateVector;
    private RTNCovariance covMatrix;
    private ProcessingState structureProcessor;
    private boolean doRelativeMetadata = true;
    private boolean isDatafinished = false;

    public CdmParser(IERSConventions conventions, boolean simpleEOP, DataContext dataContext, ParsedUnitsBehavior parsedUnitsBehavior) {
        super("cdm", "CCSDS_CDM_VERS", conventions, simpleEOP, dataContext, parsedUnitsBehavior);
    }

    @Override
    public CdmHeader getHeader() {
        return this.header;
    }

    @Override
    public void reset(FileFormat fileFormat) {
        this.header = new CdmHeader(1.0);
        this.segments = new ArrayList<CdmSegment>();
        this.metadata = null;
        this.relativeMetadata = null;
        this.context = null;
        this.odParameters = null;
        this.addParameters = null;
        this.stateVector = null;
        this.covMatrix = null;
        this.commentsBlock = null;
        if (fileFormat == FileFormat.XML) {
            this.structureProcessor = new XmlStructureProcessingState("cdm", this);
            this.reset(fileFormat, this.structureProcessor);
        } else {
            this.structureProcessor = new KvnStructureProcessingState(this);
            this.reset(fileFormat, new CdmHeaderProcessingState(this));
        }
    }

    @Override
    public boolean prepareHeader() {
        this.anticipateNext(new CdmHeaderProcessingState(this));
        return true;
    }

    @Override
    public boolean inHeader() {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this.structureProcessor : this::processMetadataToken);
        return true;
    }

    @Override
    public boolean finalizeHeader() {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this.structureProcessor);
        this.header.validate(this.header.getFormatVersion());
        return true;
    }

    @Override
    public boolean prepareMetadata() {
        if (this.metadata != null) {
            return false;
        }
        if (this.doRelativeMetadata) {
            this.relativeMetadata = new CdmRelativeMetadata();
            this.relativeMetadata.setTimeSystem(TimeSystem.UTC);
        }
        this.metadata = new CdmMetadata();
        this.metadata.setRelativeMetadata(this.relativeMetadata);
        this.context = new ContextBinding(this::getConventions, this::isSimpleEOP, this::getDataContext, this::getParsedUnitsBehavior, () -> null, this.relativeMetadata::getTimeSystem, () -> 0.0, () -> 1.0);
        this.anticipateNext(this::processMetadataToken);
        return true;
    }

    @Override
    public boolean inMetadata() {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processGeneralCommentToken);
        return true;
    }

    @Override
    public boolean finalizeMetadata() {
        this.metadata.validate(this.header.getFormatVersion());
        this.relativeMetadata.validate();
        this.anticipateNext(this.structureProcessor);
        return true;
    }

    @Override
    public boolean prepareData() {
        this.stateVector = new StateVector();
        this.covMatrix = new RTNCovariance();
        this.commentsBlock = new CommentsContainer();
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processGeneralCommentToken);
        return true;
    }

    @Override
    public boolean inData() {
        return true;
    }

    @Override
    public boolean finalizeData() {
        if (this.metadata != null) {
            CdmData data = new CdmData(this.commentsBlock, this.odParameters, this.addParameters, this.stateVector, this.covMatrix);
            data.validate(this.header.getFormatVersion());
            this.segments.add(new CdmSegment(this.metadata, data));
        }
        this.metadata = null;
        this.context = null;
        this.odParameters = null;
        this.addParameters = null;
        this.stateVector = null;
        this.covMatrix = null;
        this.commentsBlock = null;
        return true;
    }

    @Override
    public Cdm build() {
        this.finalizeData();
        Cdm file = new Cdm(this.header, this.segments, this.getConventions(), this.getDataContext());
        return file;
    }

    boolean addGeneralComment(String comment) {
        return this.commentsBlock.addComment(comment);
    }

    boolean manageRelativeMetadataSection(boolean starting) {
        this.anticipateNext(starting ? this::processMetadataToken : this.structureProcessor);
        return true;
    }

    boolean manageRelativeStateVectorSection(boolean starting) {
        this.anticipateNext(this::processMetadataToken);
        return true;
    }

    boolean manageODParametersSection(boolean starting) {
        this.commentsBlock.refuseFurtherComments();
        this.anticipateNext(starting ? this::processODParamToken : this.structureProcessor);
        return true;
    }

    boolean manageAdditionalParametersSection(boolean starting) {
        this.commentsBlock.refuseFurtherComments();
        this.anticipateNext(starting ? this::processAdditionalParametersToken : this.structureProcessor);
        return true;
    }

    boolean manageStateVectorSection(boolean starting) {
        this.commentsBlock.refuseFurtherComments();
        this.anticipateNext(starting ? this::processStateVectorToken : this.structureProcessor);
        return true;
    }

    boolean manageCovMatrixSection(boolean starting) {
        this.commentsBlock.refuseFurtherComments();
        this.anticipateNext(starting ? this::processCovMatrixToken : this.structureProcessor);
        return true;
    }

    private boolean processMetadataToken(ParseToken token) {
        if (this.isDatafinished && this.getFileFormat() != FileFormat.XML) {
            this.finalizeData();
            this.isDatafinished = false;
        }
        if (this.metadata == null) {
            this.prepareMetadata();
        }
        this.inMetadata();
        if (COMMENT.equals(token.getName()) && this.doRelativeMetadata && token.getType() == TokenType.ENTRY) {
            this.relativeMetadata.addComment(token.getContentAsNormalizedString());
            return true;
        }
        this.doRelativeMetadata = false;
        try {
            return token.getName() != null && CdmRelativeMetadataKey.valueOf(token.getName()).process(token, this.context, this.relativeMetadata);
        }
        catch (IllegalArgumentException iaeM) {
            try {
                return MetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
            }
            catch (IllegalArgumentException iaeD) {
                try {
                    return CdmMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
                }
                catch (IllegalArgumentException iaeC) {
                    return false;
                }
            }
        }
    }

    private boolean processXmlSubStructureToken(ParseToken token) {
        if (METADATA.equals(token.getName()) && TokenType.START.equals((Object)token.getType()) || RELATIVEMETADATA.equals(token.getName()) && TokenType.STOP.equals((Object)token.getType())) {
            this.anticipateNext(this::processMetadataToken);
            return true;
        }
        if (RELATIVEMETADATA.equals(token.getName()) && TokenType.START.equals((Object)token.getType()) || METADATA.equals(token.getName()) && TokenType.STOP.equals((Object)token.getType())) {
            ParseToken replaceToken = new ParseToken(token.getType(), METADATA, null, token.getUnits(), token.getLineNumber(), token.getFileName());
            return this.structureProcessor.processToken(replaceToken);
        }
        if (this.commentsBlock == null && COMMENT.equals(token.getName())) {
            if (this.doRelativeMetadata) {
                if (token.getType() == TokenType.ENTRY) {
                    this.relativeMetadata.addComment(token.getContentAsNormalizedString());
                    this.doRelativeMetadata = false;
                    return true;
                }
                return true;
            }
            if (!this.doRelativeMetadata) {
                if (token.getType() == TokenType.ENTRY) {
                    this.metadata.addComment(token.getContentAsNormalizedString());
                    return true;
                }
                return true;
            }
        }
        try {
            return token.getName() != null && !this.doRelativeMetadata && XmlSubStructureKey.valueOf(token.getName()).process(token, this);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processGeneralCommentToken(ParseToken token) {
        if (this.commentsBlock == null) {
            this.finalizeMetadata();
            this.prepareData();
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processODParamToken);
        if (COMMENT.equals(token.getName()) && this.commentsBlock.acceptComments()) {
            if (token.getType() == TokenType.ENTRY) {
                this.commentsBlock.addComment(token.getContentAsNormalizedString());
            }
            this.commentsBlock.refuseFurtherComments();
            return true;
        }
        return false;
    }

    private boolean processODParamToken(ParseToken token) {
        if (this.odParameters == null) {
            this.odParameters = new ODParameters();
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processAdditionalParametersToken);
        try {
            return token.getName() != null && ODParametersKey.valueOf(token.getName()).process(token, this.context, this.odParameters);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processAdditionalParametersToken(ParseToken token) {
        if (this.addParameters == null) {
            this.addParameters = new AdditionalParameters();
        }
        if (this.moveCommentsIfEmpty(this.odParameters, this.addParameters)) {
            this.odParameters = null;
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processStateVectorToken);
        try {
            return token.getName() != null && AdditionalParametersKey.valueOf(token.getName()).process(token, this.context, this.addParameters);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processStateVectorToken(ParseToken token) {
        if (this.moveCommentsIfEmpty(this.addParameters, this.stateVector)) {
            this.addParameters = null;
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processCovMatrixToken);
        try {
            return token.getName() != null && StateVectorKey.valueOf(token.getName()).process(token, this.context, this.stateVector);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processCovMatrixToken(ParseToken token) {
        this.isDatafinished = true;
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processMetadataToken);
        try {
            return token.getName() != null && RTNCovarianceKey.valueOf(token.getName()).process(token, this.context, this.covMatrix);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean moveCommentsIfEmpty(CommentsContainer origin, CommentsContainer destination) {
        if (origin != null && origin.acceptComments()) {
            for (String comment : origin.getComments()) {
                destination.addComment(comment);
            }
            return true;
        }
        return false;
    }
}

