/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriver;

public abstract class BaseRangeIonosphericDelayModifier {
    private final IonosphericModel ionoModel;
    private final double frequency;

    protected BaseRangeIonosphericDelayModifier(IonosphericModel model, double freq) {
        this.ionoModel = model;
        this.frequency = freq;
    }

    protected IonosphericModel getIonoModel() {
        return this.ionoModel;
    }

    protected double rangeErrorIonosphericModel(GroundStation station, SpacecraftState state) {
        TopocentricFrame baseFrame = station.getBaseFrame();
        double delay = this.ionoModel.pathDelay(state, baseFrame, this.frequency, this.ionoModel.getParameters());
        return delay;
    }

    protected <T extends CalculusFieldElement<T>> T rangeErrorIonosphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        TopocentricFrame baseFrame = station.getBaseFrame();
        CalculusFieldElement delay = this.ionoModel.pathDelay(state, baseFrame, this.frequency, (CalculusFieldElement[])parameters);
        return (T)delay;
    }

    public List<ParameterDriver> getParametersDrivers() {
        return this.ionoModel.getParametersDrivers();
    }
}

