/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.TDOA;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class TDOABuilder
extends AbstractMeasurementBuilder<TDOA> {
    private final GroundStation primeStation;
    private final GroundStation secondStation;

    public TDOABuilder(CorrelatedRandomVectorGenerator noiseSource, GroundStation primeStation, GroundStation secondStation, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(noiseSource, sigma, baseWeight, satellite);
        this.primeStation = primeStation;
        this.secondStation = secondStation;
    }

    @Override
    public TDOA build(SpacecraftState[] states) {
        ObservableSatellite satellite = this.getSatellites()[0];
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState[] relevant = new SpacecraftState[]{states[satellite.getPropagatorIndex()]};
        TDOA dummy = new TDOA(this.primeStation, this.secondStation, relevant[0].getDate(), Double.NaN, sigma, baseWeight, satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double tdoa = dummy.estimate(0, 0, relevant).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            tdoa += noise[0];
        }
        TDOA measurement = new TDOA(this.primeStation, this.secondStation, relevant[0].getDate(), tdoa, sigma, baseWeight, satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

