/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.filtering;

import java.util.ArrayList;
import org.hipparchus.util.FastMath;

abstract class HatchFilter {
    private int k;
    private boolean resetNextBoolean;
    private double previousSmoothedCode;
    private double previousSmoothingValue;
    private ArrayList<Double> codeHistory = new ArrayList();
    private ArrayList<Double> smoothedCodeHistory = new ArrayList();
    private double threshold;
    private final int N;

    HatchFilter(double threshold, int N) {
        this.threshold = threshold;
        this.resetNextBoolean = false;
        this.k = 1;
        this.N = N;
    }

    public ArrayList<Double> getCodeHistory() {
        return this.codeHistory;
    }

    public ArrayList<Double> getSmoothedCodeHistory() {
        return this.smoothedCodeHistory;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void updatePreviousSmoothedCode(double smoothedCode) {
        this.previousSmoothedCode = smoothedCode;
    }

    public void updatePreviousSmoothingValue(double smoothingValue) {
        this.previousSmoothingValue = smoothingValue;
    }

    public void addToCodeHistory(double codeValue) {
        this.codeHistory.add(codeValue);
    }

    public void addToSmoothedCodeHistory(double smoothedCodeValue) {
        this.smoothedCodeHistory.add(smoothedCodeValue);
    }

    public void resetFilterNext(double codeValue) {
        this.resetK();
        this.resetNextBoolean();
        this.updatePreviousSmoothingValue(Double.NaN);
        this.updatePreviousSmoothedCode(codeValue);
    }

    protected void resetNextBoolean() {
        this.resetNextBoolean = true;
    }

    protected void resetK() {
        this.k = 1;
    }

    protected double smoothedCode(double codeValue, double smoothingValue) {
        return (codeValue + (double)(this.k - 1) * (this.previousSmoothedCode + (smoothingValue - this.previousSmoothingValue))) / (double)this.k;
    }

    protected double checkValidData(double codeValue, double smoothedValue, boolean cycleSlip) {
        double validValue = smoothedValue;
        if (this.resetNextBoolean || cycleSlip || FastMath.abs((double)(smoothedValue - codeValue)) > this.threshold) {
            this.resetK();
            validValue = codeValue;
        } else {
            this.k = this.k > this.N ? this.N : this.k + 1;
        }
        return validValue;
    }
}

