/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvider;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;

public class ZipJarCrawler
implements DataProvider {
    private final File file;
    private final String resource;
    private final ClassLoader classLoader;
    private final URL url;
    private final String name;

    public ZipJarCrawler(File file) {
        this.file = file;
        this.resource = null;
        this.classLoader = null;
        this.url = null;
        this.name = file.getAbsolutePath();
    }

    public ZipJarCrawler(String resource) {
        this(ZipJarCrawler.class.getClassLoader(), resource);
    }

    public ZipJarCrawler(ClassLoader classLoader, String resource) {
        try {
            this.file = null;
            this.resource = resource;
            this.classLoader = classLoader;
            this.url = null;
            this.name = classLoader.getResource(resource).toURI().toString();
        }
        catch (URISyntaxException use) {
            throw new OrekitException(use, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, use.getMessage());
        }
    }

    public ZipJarCrawler(URL url) {
        try {
            this.file = null;
            this.resource = null;
            this.classLoader = null;
            this.url = url;
            this.name = url.toURI().toString();
        }
        catch (URISyntaxException use) {
            throw new OrekitException(use, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, use.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean feed(Pattern supported, DataLoader visitor, DataProvidersManager manager) {
        try (InputStream in = this.openStream();){
            boolean bl;
            try (Archive archive = new Archive(in);){
                bl = this.feed(this.name, supported, visitor, manager, archive);
            }
            return bl;
        }
        catch (IOException | ParseException e) {
            throw new OrekitException(e, (Localizable)new DummyLocalizable(e.getMessage()), new Object[0]);
        }
    }

    private InputStream openStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.resource != null) {
            return this.classLoader.getResourceAsStream(this.resource);
        }
        return this.url.openConnection().getInputStream();
    }

    private boolean feed(String prefix, Pattern supported, DataLoader visitor, DataProvidersManager manager, Archive archive) throws IOException, ParseException {
        OrekitException delayedException = null;
        boolean loaded = false;
        for (Archive.EntryStream entry : archive) {
            block12: {
                try {
                    if (!visitor.stillAcceptsData() || entry.isDirectory()) break block12;
                    String fullName = prefix + "!/" + entry.getName();
                    if (ZIP_ARCHIVE_PATTERN.matcher(entry.getName()).matches()) {
                        loaded = this.feed(fullName, supported, visitor, manager, new Archive(entry)) || loaded;
                        break block12;
                    }
                    String entryName = entry.getName();
                    int lastSlash = entryName.lastIndexOf(47);
                    if (lastSlash >= 0) {
                        entryName = entryName.substring(lastSlash + 1);
                    }
                    DataSource data = new DataSource(entryName, () -> entry);
                    data = manager.getFiltersManager().applyRelevantFilters(data);
                    if (!supported.matcher(data.getName()).matches()) break block12;
                    try (InputStream input = data.getOpener().openStreamOnce();){
                        visitor.loadData(input, fullName);
                        loaded = true;
                    }
                }
                catch (OrekitException oe) {
                    delayedException = oe;
                }
            }
            entry.close();
        }
        if (!loaded && delayedException != null) {
            throw delayedException;
        }
        return loaded;
    }

    private static final class Archive
    implements Closeable,
    Iterable<EntryStream> {
        private final ZipInputStream zip;
        private EntryStream next;

        Archive(InputStream rawStream) throws IOException {
            this.zip = new ZipInputStream(rawStream);
            this.goToNext();
        }

        private void goToNext() throws IOException {
            ZipEntry ze = this.zip.getNextEntry();
            this.next = ze == null ? null : new EntryStream(ze.getName(), ze.isDirectory());
        }

        @Override
        public Iterator<EntryStream> iterator() {
            return new Iterator<EntryStream>(){

                @Override
                public boolean hasNext() {
                    return next != null;
                }

                @Override
                public EntryStream next() throws NoSuchElementException {
                    if (next == null) {
                        throw new NoSuchElementException();
                    }
                    return next;
                }
            };
        }

        @Override
        public void close() throws IOException {
            this.zip.close();
        }

        public class EntryStream
        extends InputStream {
            private final String name;
            private boolean isDirectory;
            private boolean closed;

            EntryStream(String name, boolean isDirectory) {
                this.name = name;
                this.isDirectory = isDirectory;
                this.closed = false;
            }

            public String getName() {
                return this.name;
            }

            public boolean isDirectory() {
                return this.isDirectory;
            }

            @Override
            public int read() throws IOException {
                return Archive.this.zip.read();
            }

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    Archive.this.zip.closeEntry();
                    Archive.this.goToNext();
                    this.closed = true;
                }
            }

            @Override
            public int available() throws IOException {
                return Archive.this.zip.available();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return Archive.this.zip.read(b, off, len);
            }

            @Override
            public long skip(long n) throws IOException {
                return Archive.this.zip.skip(n);
            }

            @Override
            public boolean markSupported() {
                return Archive.this.zip.markSupported();
            }

            @Override
            public void mark(int readlimit) {
                Archive.this.zip.mark(readlimit);
            }

            @Override
            public void reset() throws IOException {
                Archive.this.zip.reset();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return Archive.this.zip.read(b);
            }
        }
    }
}

