/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.Serializable;
import org.hipparchus.CalculusFieldElement;

public class PolynomialNutation
implements Serializable {
    private static final long serialVersionUID = 20131007L;
    private double[] coefficients;

    public PolynomialNutation(double ... coefficients) {
        this.coefficients = (double[])coefficients.clone();
    }

    public double value(double tc) {
        double p = 0.0;
        for (int i = this.coefficients.length - 1; i >= 0; --i) {
            p = p * tc + this.coefficients[i];
        }
        return p;
    }

    public double derivative(double tc) {
        double p = 0.0;
        for (int i = this.coefficients.length - 1; i > 0; --i) {
            p = p * tc + (double)i * this.coefficients[i];
        }
        return p / 3.15576E9;
    }

    public <T extends CalculusFieldElement<T>> T value(T tc) {
        CalculusFieldElement p = (CalculusFieldElement)tc.getField().getZero();
        for (int i = this.coefficients.length - 1; i >= 0; --i) {
            p = (CalculusFieldElement)((CalculusFieldElement)p.multiply(tc)).add(this.coefficients[i]);
        }
        return (T)p;
    }

    public <T extends CalculusFieldElement<T>> T derivative(T tc) {
        CalculusFieldElement p = (CalculusFieldElement)tc.getField().getZero();
        for (int i = this.coefficients.length - 1; i > 0; --i) {
            p = (CalculusFieldElement)((CalculusFieldElement)p.multiply(tc)).add((double)i * this.coefficients[i]);
        }
        return (T)((CalculusFieldElement)p.divide(3.15576E9));
    }
}

