/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.text.NumberFormat;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.CompositeFormat;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathUtils;

public class FieldGeodeticPoint<T extends CalculusFieldElement<T>> {
    private final T latitude;
    private final T longitude;
    private final T altitude;
    private FieldVector3D<T> zenith;
    private FieldVector3D<T> nadir;
    private FieldVector3D<T> north;
    private FieldVector3D<T> south;
    private FieldVector3D<T> east;
    private FieldVector3D<T> west;

    public FieldGeodeticPoint(T latitude, T longitude, T altitude) {
        CalculusFieldElement zero = (CalculusFieldElement)latitude.getField().getZero();
        CalculusFieldElement pi = (CalculusFieldElement)zero.getPi();
        CalculusFieldElement lat = MathUtils.normalizeAngle(latitude, (CalculusFieldElement)((CalculusFieldElement)pi.multiply(0.5)));
        CalculusFieldElement lon = MathUtils.normalizeAngle(longitude, (CalculusFieldElement)zero);
        if (lat.getReal() > ((CalculusFieldElement)pi.multiply(0.5)).getReal()) {
            lat = (CalculusFieldElement)pi.subtract((FieldElement)lat);
            lon = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)longitude.add((FieldElement)pi)), (CalculusFieldElement)zero);
        }
        this.latitude = lat;
        this.longitude = lon;
        this.altitude = altitude;
    }

    public T getLatitude() {
        return this.latitude;
    }

    public T getLongitude() {
        return this.longitude;
    }

    public T getAltitude() {
        return this.altitude;
    }

    public FieldVector3D<T> getZenith() {
        if (this.zenith == null) {
            FieldSinCos scLat = FastMath.sinCos(this.latitude);
            FieldSinCos scLon = FastMath.sinCos(this.longitude);
            this.zenith = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)scLon.cos()).multiply((FieldElement)((CalculusFieldElement)scLat.cos())), (CalculusFieldElement)((CalculusFieldElement)scLon.sin()).multiply((FieldElement)((CalculusFieldElement)scLat.cos())), (CalculusFieldElement)scLat.sin());
        }
        return this.zenith;
    }

    public FieldVector3D<T> getNadir() {
        if (this.nadir == null) {
            this.nadir = this.getZenith().negate();
        }
        return this.nadir;
    }

    public FieldVector3D<T> getNorth() {
        if (this.north == null) {
            FieldSinCos scLat = FastMath.sinCos(this.latitude);
            FieldSinCos scLon = FastMath.sinCos(this.longitude);
            this.north = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)scLon.cos()).multiply((FieldElement)((CalculusFieldElement)scLat.sin()))).negate(), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)scLon.sin()).multiply((FieldElement)((CalculusFieldElement)scLat.sin()))).negate(), (CalculusFieldElement)scLat.cos());
        }
        return this.north;
    }

    public FieldVector3D<T> getSouth() {
        if (this.south == null) {
            this.south = this.getNorth().negate();
        }
        return this.south;
    }

    public FieldVector3D<T> getEast() {
        if (this.east == null) {
            FieldSinCos scLon = FastMath.sinCos(this.longitude);
            this.east = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)scLon.sin()).negate(), (CalculusFieldElement)scLon.cos(), (CalculusFieldElement)this.longitude.getField().getZero());
        }
        return this.east;
    }

    public FieldVector3D<T> getWest() {
        if (this.west == null) {
            this.west = this.getEast().negate();
        }
        return this.west;
    }

    public boolean equals(Object object) {
        if (object instanceof FieldGeodeticPoint) {
            FieldGeodeticPoint other = (FieldGeodeticPoint)object;
            return this.getLatitude().equals(other.getLatitude()) && this.getLongitude().equals(other.getLongitude()) && this.getAltitude().equals(other.getAltitude());
        }
        return false;
    }

    public int hashCode() {
        return this.getLatitude().hashCode() ^ this.getLongitude().hashCode() ^ this.getAltitude().hashCode();
    }

    public String toString() {
        NumberFormat format = CompositeFormat.getDefaultNumberFormat();
        return "{lat: " + format.format(FastMath.toDegrees((double)this.getLatitude().getReal())) + " deg, lon: " + format.format(FastMath.toDegrees((double)this.getLongitude().getReal())) + " deg, alt: " + format.format(this.getAltitude().getReal()) + "}";
    }
}

