/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.SinCos;
import org.orekit.frames.Frame;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Ellipse
implements Serializable {
    private static final long serialVersionUID = 20140925L;
    private static final double ANGULAR_THRESHOLD = 1.0E-12;
    private final Vector3D center;
    private final Vector3D u;
    private final Vector3D v;
    private final double a;
    private final double b;
    private final Frame frame;
    private final double a2;
    private final double b2;
    private final double e2;
    private final double g;
    private final double g2;
    private final double evoluteFactorX;
    private final double evoluteFactorY;

    public Ellipse(Vector3D center, Vector3D u, Vector3D v, double a, double b, Frame frame) {
        this.center = center;
        this.u = u;
        this.v = v;
        this.a = a;
        this.b = b;
        this.frame = frame;
        this.a2 = a * a;
        this.g = b / a;
        this.g2 = this.g * this.g;
        this.e2 = 1.0 - this.g2;
        this.b2 = b * b;
        this.evoluteFactorX = (this.a2 - this.b2) / (this.a2 * this.a2);
        this.evoluteFactorY = (this.b2 - this.a2) / (this.b2 * this.b2);
    }

    public Vector3D getCenter() {
        return this.center;
    }

    public Vector3D getU() {
        return this.u;
    }

    public Vector3D getV() {
        return this.v;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Vector3D pointAt(double theta) {
        SinCos scTheta = FastMath.sinCos((double)theta);
        return this.toSpace(new Vector2D(this.a * scTheta.cos(), this.b * scTheta.sin()));
    }

    public Vector3D toSpace(Vector2D p) {
        return new Vector3D(1.0, this.center, p.getX(), this.u, p.getY(), this.v);
    }

    public Vector2D toPlane(Vector3D p) {
        Vector3D delta = p.subtract((Vector)this.center);
        return new Vector2D(Vector3D.dotProduct((Vector3D)delta, (Vector3D)this.u), Vector3D.dotProduct((Vector3D)delta, (Vector3D)this.v));
    }

    public Vector2D projectToEllipse(Vector2D p) {
        double y;
        double x = FastMath.abs((double)p.getX());
        if (x <= 1.0E-12 * FastMath.abs((double)(y = p.getY()))) {
            double osculatingRadius = this.a2 / this.b;
            double evoluteCuspZ = FastMath.copySign((double)(this.a * this.e2 / this.g), (double)(-y));
            double deltaZ = y - evoluteCuspZ;
            double ratio = osculatingRadius / FastMath.hypot((double)deltaZ, (double)x);
            return new Vector2D(FastMath.copySign((double)(ratio * x), (double)p.getX()), evoluteCuspZ + ratio * deltaZ);
        }
        if (FastMath.abs((double)y) <= 1.0E-12 * x) {
            double osculatingRadius = this.b2 / this.a;
            double evoluteCuspR = this.a * this.e2;
            double deltaR = x - evoluteCuspR;
            if (deltaR >= 0.0) {
                double ratio = osculatingRadius / FastMath.hypot((double)y, (double)deltaR);
                return new Vector2D(FastMath.copySign((double)(evoluteCuspR + ratio * deltaR), (double)p.getX()), ratio * y);
            }
            double rEllipse = x / this.e2;
            return new Vector2D(FastMath.copySign((double)rEllipse, (double)p.getX()), FastMath.copySign((double)(this.g * FastMath.sqrt((double)(this.a2 - rEllipse * rEllipse))), (double)y));
        }
        double omegaX = this.a * this.e2;
        double omegaY = 0.0;
        double projectedX = x;
        double projectedY = y;
        double deltaX = Double.POSITIVE_INFINITY;
        double deltaY = Double.POSITIVE_INFINITY;
        int count = 0;
        double threshold = 1.0E-24 * this.a2;
        while (deltaX * deltaX + deltaY * deltaY > threshold && count++ < 100) {
            double dx = x - omegaX;
            double dy = y - omegaY;
            double alpha = this.b2 * dx * dx + this.a2 * dy * dy;
            double betaPrime = this.b2 * omegaX * dx + this.a2 * omegaY * dy;
            double gamma = this.b2 * omegaX * omegaX + this.a2 * omegaY * omegaY - this.a2 * this.b2;
            double deltaPrime = MathArrays.linearCombination((double)betaPrime, (double)betaPrime, (double)(-alpha), (double)gamma);
            double ratio = betaPrime <= 0.0 ? (FastMath.sqrt((double)deltaPrime) - betaPrime) / alpha : -gamma / (FastMath.sqrt((double)deltaPrime) + betaPrime);
            double previousX = projectedX;
            double previousY = projectedY;
            projectedX = omegaX + ratio * dx;
            projectedY = omegaY + ratio * dy;
            omegaX = this.evoluteFactorX * projectedX * projectedX * projectedX;
            omegaY = this.evoluteFactorY * projectedY * projectedY * projectedY;
            deltaX = projectedX - previousX;
            deltaY = projectedY - previousY;
        }
        return new Vector2D(FastMath.copySign((double)projectedX, (double)p.getX()), projectedY);
    }

    public TimeStampedPVCoordinates projectToEllipse(TimeStampedPVCoordinates pv) {
        Vector2D p2D = this.toPlane(pv.getPosition());
        Vector2D e2D = this.projectToEllipse(p2D);
        double fx = -this.a2 * e2D.getY();
        double fy = this.b2 * e2D.getX();
        double f2 = fx * fx + fy * fy;
        double f = FastMath.sqrt((double)f2);
        Vector2D tangent = new Vector2D(fx / f, fy / f);
        Vector2D normal = new Vector2D(-tangent.getY(), tangent.getX());
        double x2 = e2D.getX() * e2D.getX();
        double y2 = e2D.getY() * e2D.getY();
        double eX = this.evoluteFactorX * x2;
        double eY = this.evoluteFactorY * y2;
        double omegaX = eX * e2D.getX();
        double omegaY = eY * e2D.getY();
        double rho = FastMath.hypot((double)(e2D.getX() - omegaX), (double)(e2D.getY() - omegaY));
        double d = FastMath.hypot((double)(p2D.getX() - omegaX), (double)(p2D.getY() - omegaY));
        double projectionRatio = rho / d;
        Vector2D pDot2D = new Vector2D(Vector3D.dotProduct((Vector3D)pv.getVelocity(), (Vector3D)this.u), Vector3D.dotProduct((Vector3D)pv.getVelocity(), (Vector3D)this.v));
        double pDotTangent = pDot2D.dotProduct((Vector)tangent);
        double pDotNormal = pDot2D.dotProduct((Vector)normal);
        double eDotTangent = projectionRatio * pDotTangent;
        Vector2D eDot2D = new Vector2D(eDotTangent, tangent);
        Vector2D tangentDot = new Vector2D(this.a2 * this.b2 * (e2D.getX() * eDot2D.getY() - e2D.getY() * eDot2D.getX()) / f2, normal);
        double omegaXDot = 3.0 * eX * eDotTangent * tangent.getX();
        double omegaYDot = 3.0 * eY * eDotTangent * tangent.getY();
        double voz = omegaXDot * tangent.getY() - omegaYDot * tangent.getX();
        double vsz = -pDotNormal;
        double projectionRatioDot = ((rho - d) * voz - rho * vsz) / (d * d);
        Vector2D pDotDot2D = new Vector2D(Vector3D.dotProduct((Vector3D)pv.getAcceleration(), (Vector3D)this.u), Vector3D.dotProduct((Vector3D)pv.getAcceleration(), (Vector3D)this.v));
        double pDotDotTangent = pDotDot2D.dotProduct((Vector)tangent);
        double pDotTangentDot = pDot2D.dotProduct((Vector)tangentDot);
        double eDotDotTangent = projectionRatio * (pDotDotTangent + pDotTangentDot) + projectionRatioDot * pDotTangent;
        Vector2D eDotDot2D = new Vector2D(eDotDotTangent, tangent, eDotTangent, tangentDot);
        Vector3D e3D = this.toSpace(e2D);
        Vector3D eDot3D = new Vector3D(eDot2D.getX(), this.u, eDot2D.getY(), this.v);
        Vector3D eDotDot3D = new Vector3D(eDotDot2D.getX(), this.u, eDotDot2D.getY(), this.v);
        return new TimeStampedPVCoordinates(pv.getDate(), e3D, eDot3D, eDotDot3D);
    }

    public Vector2D getCenterOfCurvature(Vector2D point) {
        Vector2D projected = this.projectToEllipse(point);
        return new Vector2D(this.evoluteFactorX * projected.getX() * projected.getX() * projected.getX(), this.evoluteFactorY * projected.getY() * projected.getY() * projected.getY());
    }
}

