/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.AttitudeProviderModifier;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.attitudes.GroundPointing;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class YawSteering
extends GroundPointing
implements AttitudeProviderModifier {
    private static final PVCoordinates PLUS_Z = new PVCoordinates(Vector3D.PLUS_K, Vector3D.ZERO, Vector3D.ZERO);
    private final GroundPointing groundPointingLaw;
    private final PVCoordinatesProvider sun;
    private final PVCoordinates phasingNormal;

    public YawSteering(Frame inertialFrame, GroundPointing groundPointingLaw, PVCoordinatesProvider sun, Vector3D phasingAxis) {
        super(inertialFrame, groundPointingLaw.getBodyFrame());
        this.groundPointingLaw = groundPointingLaw;
        this.sun = sun;
        this.phasingNormal = new PVCoordinates(Vector3D.crossProduct((Vector3D)Vector3D.PLUS_K, (Vector3D)phasingAxis).normalize(), Vector3D.ZERO, Vector3D.ZERO);
    }

    @Override
    public AttitudeProvider getUnderlyingAttitudeProvider() {
        return this.groundPointingLaw;
    }

    @Override
    public TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        return this.groundPointingLaw.getTargetPV(pvProv, date, frame);
    }

    @Override
    public <T extends CalculusFieldElement<T>> TimeStampedFieldPVCoordinates<T> getTargetPV(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        return this.groundPointingLaw.getTargetPV(pvProv, date, frame);
    }

    public Attitude getBaseState(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        return this.groundPointingLaw.getAttitude(pvProv, date, frame);
    }

    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getBaseState(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        return this.groundPointingLaw.getAttitude(pvProv, date, frame);
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Attitude base = this.getBaseState(pvProv, date, frame);
        PVCoordinates sunDirection = new PVCoordinates(pvProv.getPVCoordinates(date, frame), (PVCoordinates)this.sun.getPVCoordinates(date, frame));
        PVCoordinates sunNormal = PVCoordinates.crossProduct(PLUS_Z, base.getOrientation().applyTo(sunDirection));
        TimeStampedAngularCoordinates compensation = new TimeStampedAngularCoordinates(date, PLUS_Z, sunNormal.normalize(), PLUS_Z, this.phasingNormal, 1.0E-9);
        return new Attitude(frame, compensation.addOffset(base.getOrientation()));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        Field<T> field = date.getField();
        FieldVector3D zero = FieldVector3D.getZero(field);
        FieldPVCoordinates<Field<T>> plusZ = new FieldPVCoordinates<Field<T>>(FieldVector3D.getPlusK(field), zero, zero);
        FieldAttitude<T> base = this.getBaseState(pvProv, date, frame);
        FieldPVCoordinates<Field<T>> sunDirection = new FieldPVCoordinates<Field<T>>(pvProv.getPVCoordinates(date, frame), new FieldPVCoordinates<Field<T>>(field, (PVCoordinates)this.sun.getPVCoordinates(date.toAbsoluteDate(), frame)));
        FieldPVCoordinates<Field<T>> sunNormal = plusZ.crossProduct(base.getOrientation().applyTo(sunDirection));
        TimeStampedFieldAngularCoordinates<Field<T>> compensation = new TimeStampedFieldAngularCoordinates<Field<T>>(date, plusZ, sunNormal.normalize(), plusZ, new FieldPVCoordinates<Field<T>>(field, this.phasingNormal), 1.0E-9);
        return new FieldAttitude(frame, compensation.addOffset(base.getOrientation()));
    }
}

