/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.ArrayList;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.GroundPointing;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class NadirPointing
extends GroundPointing {
    private final BodyShape shape;

    public NadirPointing(Frame inertialFrame, BodyShape shape) {
        super(inertialFrame, shape.getBodyFrame());
        this.shape = shape;
    }

    @Override
    public TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Transform refToBody = frame.getTransformTo(this.shape.getBodyFrame(), date);
        double h = 0.01;
        ArrayList<TimeStampedPVCoordinates> sample = new ArrayList<TimeStampedPVCoordinates>();
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date.shiftedBy(-0.02), frame), refToBody.staticShiftedBy(-0.02)));
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date.shiftedBy(-0.01), frame), refToBody.staticShiftedBy(-0.01)));
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date, frame), refToBody));
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date.shiftedBy(0.01), frame), refToBody.staticShiftedBy(0.01)));
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date.shiftedBy(0.02), frame), refToBody.staticShiftedBy(0.02)));
        return TimeStampedPVCoordinates.interpolate(date, CartesianDerivativesFilter.USE_P, sample);
    }

    @Override
    public <T extends CalculusFieldElement<T>> TimeStampedFieldPVCoordinates<T> getTargetPV(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        FieldTransform<T> refToBody = frame.getTransformTo(this.shape.getBodyFrame(), date);
        double h = 0.01;
        ArrayList sample = new ArrayList();
        sample.add(this.nadirRef(pvProv.getPVCoordinates((FieldAbsoluteDate<T>)date.shiftedBy(-0.02), frame), (FieldTransform<T>)refToBody.shiftedBy(-0.02)));
        sample.add(this.nadirRef(pvProv.getPVCoordinates((FieldAbsoluteDate<T>)date.shiftedBy(-0.01), frame), (FieldTransform<T>)refToBody.shiftedBy(-0.01)));
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date, frame), refToBody));
        sample.add(this.nadirRef(pvProv.getPVCoordinates((FieldAbsoluteDate<T>)date.shiftedBy(0.01), frame), (FieldTransform<T>)refToBody.shiftedBy(0.01)));
        sample.add(this.nadirRef(pvProv.getPVCoordinates((FieldAbsoluteDate<T>)date.shiftedBy(0.02), frame), (FieldTransform<T>)refToBody.shiftedBy(0.02)));
        return TimeStampedFieldPVCoordinates.interpolate(date, CartesianDerivativesFilter.USE_P, sample);
    }

    private TimeStampedPVCoordinates nadirRef(TimeStampedPVCoordinates scRef, StaticTransform refToBody) {
        Vector3D satInBodyFrame = refToBody.transformPosition(scRef.getPosition());
        GeodeticPoint gpSat = this.shape.transform(satInBodyFrame, this.getBodyFrame(), scRef.getDate());
        GeodeticPoint gpNadir = new GeodeticPoint(gpSat.getLatitude(), gpSat.getLongitude(), 0.0);
        Vector3D pNadirBody = this.shape.transform(gpNadir);
        Vector3D pNadirRef = refToBody.getInverse().transformPosition(pNadirBody);
        return new TimeStampedPVCoordinates(scRef.getDate(), pNadirRef, Vector3D.ZERO, Vector3D.ZERO);
    }

    private <T extends CalculusFieldElement<T>> TimeStampedFieldPVCoordinates<T> nadirRef(TimeStampedFieldPVCoordinates<T> scRef, FieldTransform<T> refToBody) {
        FieldVector3D<T> satInBodyFrame = refToBody.transformPosition(scRef.getPosition());
        FieldGeodeticPoint<T> gpSat = this.shape.transform(satInBodyFrame, this.getBodyFrame(), scRef.getDate());
        FieldGeodeticPoint<CalculusFieldElement> gpNadir = new FieldGeodeticPoint<CalculusFieldElement>((CalculusFieldElement)gpSat.getLatitude(), (CalculusFieldElement)gpSat.getLongitude(), (CalculusFieldElement)gpSat.getAltitude().getField().getZero());
        FieldVector3D<CalculusFieldElement> pNadirBody = this.shape.transform(gpNadir);
        FieldVector3D<CalculusFieldElement> pNadirRef = refToBody.getInverse().transformPosition(pNadirBody);
        FieldVector3D zero = FieldVector3D.getZero((Field)gpSat.getAltitude().getField());
        return new TimeStampedFieldPVCoordinates<CalculusFieldElement>(scRef.getDate(), pNadirRef, zero, zero);
    }
}

