/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealVector;

public enum DependentVectorsHandler {
    GENERATE_EXCEPTION{

        @Override
        public int manageDependent(int index, List<RealVector> basis) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.ZERO_NORM, new Object[0]);
        }

        @Override
        public <T extends CalculusFieldElement<T>> int manageDependent(Field<T> field, int index, List<FieldVector<T>> basis) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.ZERO_NORM, new Object[0]);
        }
    }
    ,
    ADD_ZERO_VECTOR{

        @Override
        public int manageDependent(int index, List<RealVector> basis) {
            basis.set(index, MatrixUtils.createRealVector(basis.get(index).getDimension()));
            return index + 1;
        }

        @Override
        public <T extends CalculusFieldElement<T>> int manageDependent(Field<T> field, int index, List<FieldVector<T>> basis) {
            basis.set(index, MatrixUtils.createFieldVector(field, basis.get(index).getDimension()));
            return index + 1;
        }
    }
    ,
    REDUCE_BASE_TO_SPAN{

        @Override
        public int manageDependent(int index, List<RealVector> basis) {
            basis.remove(index);
            return index;
        }

        @Override
        public <T extends CalculusFieldElement<T>> int manageDependent(Field<T> field, int index, List<FieldVector<T>> basis) {
            basis.remove(index);
            return index;
        }
    };


    public abstract int manageDependent(int var1, List<RealVector> var2);

    public abstract <T extends CalculusFieldElement<T>> int manageDependent(Field<T> var1, int var2, List<FieldVector<T>> var3);
}

