/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.CalculusFieldUnivariateVectorFunction;
import org.hipparchus.analysis.UnivariateVectorFunction;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.SinCos;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.forces.ForceModel;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.semianalytical.dsst.forces.AbstractGaussianContributionContext;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.FieldAbstractGaussianContributionContext;
import org.orekit.propagation.semianalytical.dsst.forces.FieldShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.CjSjCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldCjSjCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldShortPeriodicsInterpolatedCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.ShortPeriodicsInterpolatedCoefficient;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeInterpolable;
import org.orekit.utils.FieldTimeSpanMap;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

public abstract class AbstractGaussianContribution
implements DSSTForceModel {
    private static final int I = 1;
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private static final int[] GAUSS_ORDER = new int[]{12, 16, 20, 24, 32, 40, 48};
    private static final int MAX_ORDER_RANK = GAUSS_ORDER.length - 1;
    private static final int INTERPOLATION_POINTS = 3;
    private static final int JMAX = 12;
    private final ForceModel contribution;
    private final double threshold;
    private GaussQuadrature integrator;
    private boolean isDirty;
    private AttitudeProvider attitudeProvider;
    private final String coefficientsKeyPrefix;
    private GaussianShortPeriodicCoefficients gaussianSPCoefs;
    private Map<Field<?>, FieldGaussianShortPeriodicCoefficients<?>> gaussianFieldSPCoefs;
    private final ParameterDriver gmParameterDriver;

    protected AbstractGaussianContribution(String coefficientsKeyPrefix, double threshold, ForceModel contribution, double mu) {
        this.gmParameterDriver = new ParameterDriver("central attraction coefficient", mu, MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
        this.coefficientsKeyPrefix = coefficientsKeyPrefix;
        this.contribution = contribution;
        this.threshold = threshold;
        this.integrator = new GaussQuadrature(GAUSS_ORDER[MAX_ORDER_RANK]);
        this.isDirty = true;
        this.gaussianFieldSPCoefs = new HashMap();
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        this.contribution.init(initialState, target);
    }

    @Override
    public <T extends CalculusFieldElement<T>> void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
        this.contribution.init(initialState, target);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        ArrayList<ParameterDriver> drivers = new ArrayList<ParameterDriver>();
        for (ParameterDriver driver : this.getParametersDriversWithoutMu()) {
            drivers.add(driver);
        }
        drivers.add(this.gmParameterDriver);
        return drivers;
    }

    protected abstract List<ParameterDriver> getParametersDriversWithoutMu();

    @Override
    public List<ShortPeriodTerms> initializeShortPeriodTerms(AuxiliaryElements auxiliaryElements, PropagationType type, double[] parameters) {
        ArrayList<ShortPeriodTerms> list = new ArrayList<ShortPeriodTerms>();
        this.gaussianSPCoefs = new GaussianShortPeriodicCoefficients(this.coefficientsKeyPrefix, 12, 3, new TimeSpanMap<Slot>(new Slot(12, 3)));
        list.add(this.gaussianSPCoefs);
        return list;
    }

    @Override
    public <T extends CalculusFieldElement<T>> List<FieldShortPeriodTerms<T>> initializeShortPeriodTerms(FieldAuxiliaryElements<T> auxiliaryElements, PropagationType type, T[] parameters) {
        Field<T> field = auxiliaryElements.getDate().getField();
        FieldGaussianShortPeriodicCoefficients fgspc = new FieldGaussianShortPeriodicCoefficients(this.coefficientsKeyPrefix, 12, 3, new FieldTimeSpanMap(new FieldSlot(12, 3), field));
        this.gaussianFieldSPCoefs.put(field, fgspc);
        return Collections.singletonList(fgspc);
    }

    private AbstractGaussianContributionContext initializeStep(AuxiliaryElements auxiliaryElements, double[] parameters) {
        return new AbstractGaussianContributionContext(auxiliaryElements, parameters);
    }

    private <T extends CalculusFieldElement<T>> FieldAbstractGaussianContributionContext<T> initializeStep(FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters) {
        return new FieldAbstractGaussianContributionContext(auxiliaryElements, parameters);
    }

    @Override
    public double[] getMeanElementRate(SpacecraftState state, AuxiliaryElements auxiliaryElements, double[] parameters) {
        AbstractGaussianContributionContext context = this.initializeStep(auxiliaryElements, parameters);
        double[] meanElementRate = new double[6];
        double[] ll = this.getLLimits(state, auxiliaryElements);
        if (ll[0] < ll[1]) {
            meanElementRate = this.getMeanElementRate(state, this.integrator, ll[0], ll[1], context, parameters);
            if (this.isDirty) {
                boolean next = true;
                for (int i = 0; i < MAX_ORDER_RANK && next; ++i) {
                    double[] meanRates = this.getMeanElementRate(state, new GaussQuadrature(GAUSS_ORDER[i]), ll[0], ll[1], context, parameters);
                    if (!(this.getRatesDiff(meanElementRate, meanRates, context) < this.threshold)) continue;
                    this.integrator = new GaussQuadrature(GAUSS_ORDER[i]);
                    next = false;
                }
                this.isDirty = false;
            }
        }
        return meanElementRate;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T[] getMeanElementRate(FieldSpacecraftState<T> state, FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters) {
        FieldAbstractGaussianContributionContext context = this.initializeStep(auxiliaryElements, (CalculusFieldElement[])parameters);
        Field<T> field = state.getDate().getField();
        CalculusFieldElement[] meanElementRate = (CalculusFieldElement[])MathArrays.buildArray(field, (int)6);
        CalculusFieldElement[] ll = this.getLLimits(state, auxiliaryElements);
        if (ll[0].getReal() < ll[1].getReal()) {
            meanElementRate = this.getMeanElementRate(state, this.integrator, ll[0], ll[1], context, (CalculusFieldElement[])parameters);
            if (this.isDirty) {
                boolean next = true;
                for (int i = 0; i < MAX_ORDER_RANK && next; ++i) {
                    CalculusFieldElement[] meanRates = this.getMeanElementRate(state, new GaussQuadrature(GAUSS_ORDER[i]), ll[0], ll[1], context, (CalculusFieldElement[])parameters);
                    if (!(this.getRatesDiff(meanElementRate, meanRates, context).getReal() < this.threshold)) continue;
                    this.integrator = new GaussQuadrature(GAUSS_ORDER[i]);
                    next = false;
                }
                this.isDirty = false;
            }
        }
        return meanElementRate;
    }

    protected abstract double[] getLLimits(SpacecraftState var1, AuxiliaryElements var2);

    protected abstract <T extends CalculusFieldElement<T>> T[] getLLimits(FieldSpacecraftState<T> var1, FieldAuxiliaryElements<T> var2);

    protected double[] getMeanElementRate(SpacecraftState state, GaussQuadrature gauss, double low, double high, AbstractGaussianContributionContext context, double[] parameters) {
        AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
        double[] meanElementRate = gauss.integrate(new IntegrableFunction(state, true, 0, parameters), low, high);
        double coef = 1.0 / (Math.PI * 2 * auxiliaryElements.getB());
        int i = 0;
        while (i < 6) {
            int n = i++;
            meanElementRate[n] = meanElementRate[n] * coef;
        }
        return meanElementRate;
    }

    protected <T extends CalculusFieldElement<T>> T[] getMeanElementRate(FieldSpacecraftState<T> state, GaussQuadrature gauss, T low, T high, FieldAbstractGaussianContributionContext<T> context, T[] parameters) {
        Field field = context.getA().getField();
        FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
        CalculusFieldElement[] meanElementRate = gauss.integrate(new FieldIntegrableFunction(this, state, true, 0, parameters, field), low, high, field);
        CalculusFieldElement coef = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getB().multiply(low.getPi())).multiply(2.0)).reciprocal();
        for (int i = 0; i < 6; ++i) {
            meanElementRate[i] = (CalculusFieldElement)meanElementRate[i].multiply((FieldElement)coef);
        }
        return meanElementRate;
    }

    private double getRatesDiff(double[] meanRef, double[] meanCur, AbstractGaussianContributionContext context) {
        AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
        double maxDiff = FastMath.abs((double)(meanRef[0] - meanCur[0])) / auxiliaryElements.getSma();
        for (int i = 1; i < meanRef.length; ++i) {
            maxDiff = FastMath.max((double)maxDiff, (double)FastMath.abs((double)(meanRef[i] - meanCur[i])));
        }
        return maxDiff;
    }

    private <T extends CalculusFieldElement<T>> T getRatesDiff(T[] meanRef, T[] meanCur, FieldAbstractGaussianContributionContext<T> context) {
        FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
        CalculusFieldElement maxDiff = (CalculusFieldElement)FastMath.abs((CalculusFieldElement)((CalculusFieldElement)meanRef[0].subtract(meanCur[0]))).divide(auxiliaryElements.getSma());
        for (int i = 1; i < meanRef.length; ++i) {
            maxDiff = FastMath.max((CalculusFieldElement)maxDiff, (CalculusFieldElement)FastMath.abs((CalculusFieldElement)((CalculusFieldElement)meanRef[i].subtract(meanCur[i]))));
        }
        return (T)maxDiff;
    }

    @Override
    public void registerAttitudeProvider(AttitudeProvider provider) {
        this.attitudeProvider = provider;
    }

    @Override
    public void updateShortPeriodTerms(double[] parameters, SpacecraftState ... meanStates) {
        Slot slot = this.gaussianSPCoefs.createSlot(meanStates);
        for (SpacecraftState meanState : meanStates) {
            AuxiliaryElements auxiliaryElements = new AuxiliaryElements(meanState.getOrbit(), 1);
            AbstractGaussianContributionContext context = this.initializeStep(auxiliaryElements, parameters);
            double[][] currentRhoSigmaj = this.computeRhoSigmaCoefficients(meanState.getDate(), auxiliaryElements);
            FourierCjSjCoefficients fourierCjSj = new FourierCjSjCoefficients(meanState, 12, auxiliaryElements, parameters);
            UijVijCoefficients uijvij = new UijVijCoefficients(currentRhoSigmaj, fourierCjSj, 12);
            this.gaussianSPCoefs.computeCoefficients(meanState, slot, fourierCjSj, uijvij, context.getMeanMotion(), auxiliaryElements.getSma());
        }
    }

    @Override
    public <T extends CalculusFieldElement<T>> void updateShortPeriodTerms(T[] parameters, FieldSpacecraftState<T> ... meanStates) {
        Field<T> field = meanStates[0].getDate().getField();
        FieldGaussianShortPeriodicCoefficients<?> fgspc = this.gaussianFieldSPCoefs.get(field);
        FieldSlot<?> slot = fgspc.createSlot(meanStates);
        for (FieldSpacecraftState<T> meanState : meanStates) {
            FieldAuxiliaryElements<T> auxiliaryElements = new FieldAuxiliaryElements<T>(meanState.getOrbit(), 1);
            FieldAbstractGaussianContributionContext context = this.initializeStep(auxiliaryElements, (CalculusFieldElement[])parameters);
            CalculusFieldElement[][] currentRhoSigmaj = this.computeRhoSigmaCoefficients(meanState.getDate(), context, field);
            FieldFourierCjSjCoefficients fourierCjSj = new FieldFourierCjSjCoefficients(this, meanState, 12, auxiliaryElements, parameters, field);
            FieldUijVijCoefficients uijvij = new FieldUijVijCoefficients(currentRhoSigmaj, fourierCjSj, 12, field);
            ((FieldGaussianShortPeriodicCoefficients)fgspc).computeCoefficients(meanState, slot, fourierCjSj, uijvij, context.getMeanMotion(), auxiliaryElements.getSma(), field);
        }
    }

    private double[][] computeRhoSigmaCoefficients(AbsoluteDate date, AuxiliaryElements auxiliaryElements) {
        double[][] currentRhoSigmaj = new double[2][37];
        CjSjCoefficient cjsjKH = new CjSjCoefficient(auxiliaryElements.getK(), auxiliaryElements.getH());
        double b = 1.0 / (1.0 + auxiliaryElements.getB());
        double mbtj = 1.0;
        for (int j = 1; j <= 36; ++j) {
            double coef = (1.0 + (double)j * auxiliaryElements.getB()) * (mbtj *= -b);
            currentRhoSigmaj[0][j] = coef * cjsjKH.getCj(j);
            currentRhoSigmaj[1][j] = coef * cjsjKH.getSj(j);
        }
        return currentRhoSigmaj;
    }

    private <T extends CalculusFieldElement<T>> T[][] computeRhoSigmaCoefficients(FieldAbsoluteDate<T> date, FieldAbstractGaussianContributionContext<T> context, Field<T> field) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
        CalculusFieldElement[][] currentRhoSigmaj = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)2, (int)37);
        FieldCjSjCoefficient cjsjKH = new FieldCjSjCoefficient(auxiliaryElements.getK(), auxiliaryElements.getH(), field);
        CalculusFieldElement b = (CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getB().add(1.0)).reciprocal();
        CalculusFieldElement mbtj = (CalculusFieldElement)zero.add(1.0);
        for (int j = 1; j <= 36; ++j) {
            mbtj = (CalculusFieldElement)mbtj.multiply(b.negate());
            CalculusFieldElement coef = (CalculusFieldElement)mbtj.multiply(((CalculusFieldElement)auxiliaryElements.getB().multiply(j)).add(1.0));
            currentRhoSigmaj[0][j] = (CalculusFieldElement)coef.multiply(cjsjKH.getCj(j));
            currentRhoSigmaj[1][j] = (CalculusFieldElement)coef.multiply(cjsjKH.getSj(j));
        }
        return currentRhoSigmaj;
    }

    protected static class FieldSlot<T extends CalculusFieldElement<T>> {
        private final FieldShortPeriodicsInterpolatedCoefficient<T>[] dij = (FieldShortPeriodicsInterpolatedCoefficient[])Array.newInstance(FieldShortPeriodicsInterpolatedCoefficient.class, 3);
        private final FieldShortPeriodicsInterpolatedCoefficient<T>[] cij;
        private final FieldShortPeriodicsInterpolatedCoefficient<T>[] sij;

        FieldSlot(int jMax, int interpolationPoints) {
            this.cij = (FieldShortPeriodicsInterpolatedCoefficient[])Array.newInstance(FieldShortPeriodicsInterpolatedCoefficient.class, jMax + 1);
            this.sij = (FieldShortPeriodicsInterpolatedCoefficient[])Array.newInstance(FieldShortPeriodicsInterpolatedCoefficient.class, jMax + 1);
            for (int j = 0; j <= jMax; ++j) {
                this.cij[j] = new FieldShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                if (j > 0) {
                    this.sij[j] = new FieldShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                }
                if (j != 1 && j != 2) continue;
                this.dij[j] = new FieldShortPeriodicsInterpolatedCoefficient(interpolationPoints);
            }
        }
    }

    protected static class Slot {
        private final ShortPeriodicsInterpolatedCoefficient[] dij = new ShortPeriodicsInterpolatedCoefficient[3];
        private final ShortPeriodicsInterpolatedCoefficient[] cij;
        private final ShortPeriodicsInterpolatedCoefficient[] sij;

        Slot(int jMax, int interpolationPoints) {
            this.cij = new ShortPeriodicsInterpolatedCoefficient[jMax + 1];
            this.sij = new ShortPeriodicsInterpolatedCoefficient[jMax + 1];
            for (int j = 0; j <= jMax; ++j) {
                this.cij[j] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                if (j > 0) {
                    this.sij[j] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                }
                if (j != 1 && j != 2) continue;
                this.dij[j] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
            }
        }
    }

    protected static class FieldUijVijCoefficients<T extends CalculusFieldElement<T>> {
        private final T[][] u1ij;
        private final T[][] v1ij;
        private final T[] u2ij;
        private final T[] v2ij;
        private final T[][] currentRhoSigmaj;
        private final FieldFourierCjSjCoefficients<T> fourierCjSj;
        private final int jMax;

        FieldUijVijCoefficients(T[][] currentRhoSigmaj, FieldFourierCjSjCoefficients<T> fourierCjSj, int jMax, Field<T> field) {
            this.currentRhoSigmaj = currentRhoSigmaj;
            this.fourierCjSj = fourierCjSj;
            this.jMax = jMax;
            this.u1ij = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)6, (int)(2 * jMax + 1));
            this.v1ij = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)6, (int)(2 * jMax + 1));
            this.u2ij = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(jMax + 1));
            this.v2ij = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(jMax + 1));
            this.computeU1V1Coefficients(field);
            this.computeU2V2Coefficients(field);
        }

        private void computeU1V1Coefficients(Field<T> field) {
            double ooj;
            int j;
            CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
            this.u1ij[0][0] = zero;
            for (j = 1; j <= this.jMax; ++j) {
                ooj = 1.0 / (double)j;
                for (int i = 0; i < 6; ++i) {
                    int kIndex;
                    this.u1ij[i][j] = this.fourierCjSj.getSij(i, j);
                    this.v1ij[i][j] = this.fourierCjSj.getCij(i, j);
                    if (j > 1) {
                        for (kIndex = 1; kIndex <= j - 1; ++kIndex) {
                            this.u1ij[i][j] = (CalculusFieldElement)this.u1ij[i][j].add(((CalculusFieldElement)this.fourierCjSj.getCij(i, j - kIndex).multiply(this.currentRhoSigmaj[1][kIndex])).add(this.fourierCjSj.getSij(i, j - kIndex).multiply(this.currentRhoSigmaj[0][kIndex])));
                            this.v1ij[i][j] = (CalculusFieldElement)this.v1ij[i][j].add(((CalculusFieldElement)this.fourierCjSj.getCij(i, j - kIndex).multiply(this.currentRhoSigmaj[0][kIndex])).subtract(this.fourierCjSj.getSij(i, j - kIndex).multiply(this.currentRhoSigmaj[1][kIndex])));
                        }
                    }
                    if (j != this.jMax) {
                        for (kIndex = 1; kIndex <= this.jMax - j; ++kIndex) {
                            this.u1ij[i][j] = (CalculusFieldElement)this.u1ij[i][j].add(((CalculusFieldElement)((CalculusFieldElement)this.fourierCjSj.getCij(i, j + kIndex).negate()).multiply(this.currentRhoSigmaj[1][kIndex])).add(this.fourierCjSj.getSij(i, j + kIndex).multiply(this.currentRhoSigmaj[0][kIndex])));
                            this.v1ij[i][j] = (CalculusFieldElement)this.v1ij[i][j].add(((CalculusFieldElement)this.fourierCjSj.getCij(i, j + kIndex).multiply(this.currentRhoSigmaj[0][kIndex])).add(this.fourierCjSj.getSij(i, j + kIndex).multiply(this.currentRhoSigmaj[1][kIndex])));
                        }
                    }
                    for (kIndex = 1; kIndex <= this.jMax; ++kIndex) {
                        this.u1ij[i][j] = (CalculusFieldElement)this.u1ij[i][j].add(((CalculusFieldElement)((CalculusFieldElement)this.fourierCjSj.getCij(i, kIndex).negate()).multiply(this.currentRhoSigmaj[1][j + kIndex])).subtract(this.fourierCjSj.getSij(i, kIndex).multiply(this.currentRhoSigmaj[0][j + kIndex])));
                        this.v1ij[i][j] = (CalculusFieldElement)this.v1ij[i][j].add(((CalculusFieldElement)this.fourierCjSj.getCij(i, kIndex).multiply(this.currentRhoSigmaj[0][j + kIndex])).add(this.fourierCjSj.getSij(i, kIndex).multiply(this.currentRhoSigmaj[1][j + kIndex])));
                    }
                    this.u1ij[i][j] = (CalculusFieldElement)this.u1ij[i][j].multiply(-ooj);
                    this.v1ij[i][j] = (CalculusFieldElement)this.v1ij[i][j].multiply(ooj);
                    if (i != 0) continue;
                    this.u1ij[0][0] = (CalculusFieldElement)this.u1ij[0][0].add(((CalculusFieldElement)((CalculusFieldElement)this.u1ij[0][j].negate()).multiply(this.currentRhoSigmaj[0][j])).subtract(this.v1ij[0][j].multiply(this.currentRhoSigmaj[1][j])));
                }
            }
            for (j = this.jMax + 1; j <= 2 * this.jMax; ++j) {
                int kIndex;
                ooj = 1.0 / (double)j;
                this.u1ij[0][j] = zero;
                this.v1ij[0][j] = zero;
                for (kIndex = j - this.jMax; kIndex <= j - 1; ++kIndex) {
                    this.u1ij[0][j] = (CalculusFieldElement)this.u1ij[0][j].add(((CalculusFieldElement)this.fourierCjSj.getCij(0, j - kIndex).multiply(this.currentRhoSigmaj[1][kIndex])).add(this.fourierCjSj.getSij(0, j - kIndex).multiply(this.currentRhoSigmaj[0][kIndex])));
                    this.v1ij[0][j] = (CalculusFieldElement)this.v1ij[0][j].add(((CalculusFieldElement)this.fourierCjSj.getCij(0, j - kIndex).multiply(this.currentRhoSigmaj[0][kIndex])).subtract(this.fourierCjSj.getSij(0, j - kIndex).multiply(this.currentRhoSigmaj[1][kIndex])));
                }
                for (kIndex = 1; kIndex <= this.jMax; ++kIndex) {
                    this.u1ij[0][j] = (CalculusFieldElement)this.u1ij[0][j].add(((CalculusFieldElement)((CalculusFieldElement)this.fourierCjSj.getCij(0, kIndex).negate()).multiply(this.currentRhoSigmaj[1][j + kIndex])).subtract(this.fourierCjSj.getSij(0, kIndex).multiply(this.currentRhoSigmaj[0][j + kIndex])));
                    this.v1ij[0][j] = (CalculusFieldElement)this.v1ij[0][j].add(((CalculusFieldElement)this.fourierCjSj.getCij(0, kIndex).multiply(this.currentRhoSigmaj[0][j + kIndex])).add(this.fourierCjSj.getSij(0, kIndex).multiply(this.currentRhoSigmaj[1][j + kIndex])));
                }
                this.u1ij[0][j] = (CalculusFieldElement)this.u1ij[0][j].multiply(-ooj);
                this.v1ij[0][j] = (CalculusFieldElement)this.v1ij[0][j].multiply(ooj);
            }
        }

        private void computeU2V2Coefficients(Field<T> field) {
            for (int j = 1; j <= this.jMax; ++j) {
                int l;
                double ooj = 1.0 / (double)j;
                this.u2ij[j] = this.v1ij[0][j];
                this.v2ij[j] = this.u1ij[0][j];
                if (j > 1) {
                    for (l = 1; l <= j - 1; ++l) {
                        this.u2ij[j] = (CalculusFieldElement)this.u2ij[j].add(((CalculusFieldElement)this.u1ij[0][j - l].multiply(this.currentRhoSigmaj[1][l])).add(this.v1ij[0][j - l].multiply(this.currentRhoSigmaj[0][l])));
                        this.v2ij[j] = (CalculusFieldElement)this.v2ij[j].add(((CalculusFieldElement)this.u1ij[0][j - l].multiply(this.currentRhoSigmaj[0][l])).subtract(this.v1ij[0][j - l].multiply(this.currentRhoSigmaj[1][l])));
                    }
                }
                for (l = 1; l <= this.jMax; ++l) {
                    this.u2ij[j] = (CalculusFieldElement)this.u2ij[j].add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.u1ij[0][j + l].negate()).multiply(this.currentRhoSigmaj[1][l])).add(this.u1ij[0][l].multiply(this.currentRhoSigmaj[1][j + l]))).add(this.v1ij[0][j + l].multiply(this.currentRhoSigmaj[0][l]))).subtract(this.v1ij[0][l].multiply(this.currentRhoSigmaj[0][j + l])));
                    this.u2ij[j] = (CalculusFieldElement)this.u2ij[j].add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.u1ij[0][j + l].multiply(this.currentRhoSigmaj[0][l])).add(this.u1ij[0][l].multiply(this.currentRhoSigmaj[0][j + l]))).add(this.v1ij[0][j + l].multiply(this.currentRhoSigmaj[1][l]))).add(this.v1ij[0][l].multiply(this.currentRhoSigmaj[1][j + l])));
                }
                this.u2ij[j] = (CalculusFieldElement)this.u2ij[j].multiply(-ooj);
                this.v2ij[j] = (CalculusFieldElement)this.v2ij[j].multiply(ooj);
            }
        }

        public T getU1(int j, int i) {
            return this.u1ij[i][j];
        }

        public T getV1(int j, int i) {
            return this.v1ij[i][j];
        }

        public T getU2(int j) {
            return this.u2ij[j];
        }

        public T getV2(int j) {
            return this.v2ij[j];
        }
    }

    protected static class UijVijCoefficients {
        private final double[][] u1ij;
        private final double[][] v1ij;
        private final double[] u2ij;
        private final double[] v2ij;
        private final double[][] currentRhoSigmaj;
        private final FourierCjSjCoefficients fourierCjSj;
        private final int jMax;

        UijVijCoefficients(double[][] currentRhoSigmaj, FourierCjSjCoefficients fourierCjSj, int jMax) {
            this.currentRhoSigmaj = currentRhoSigmaj;
            this.fourierCjSj = fourierCjSj;
            this.jMax = jMax;
            this.u1ij = new double[6][2 * jMax + 1];
            this.v1ij = new double[6][2 * jMax + 1];
            this.u2ij = new double[jMax + 1];
            this.v2ij = new double[jMax + 1];
            this.computeU1V1Coefficients();
            this.computeU2V2Coefficients();
        }

        private void computeU1V1Coefficients() {
            double ooj;
            int j;
            this.u1ij[0][0] = 0.0;
            for (j = 1; j <= this.jMax; ++j) {
                ooj = 1.0 / (double)j;
                for (int i = 0; i < 6; ++i) {
                    int kIndex;
                    this.u1ij[i][j] = this.fourierCjSj.getSij(i, j);
                    this.v1ij[i][j] = this.fourierCjSj.getCij(i, j);
                    if (j > 1) {
                        for (kIndex = 1; kIndex <= j - 1; ++kIndex) {
                            double[] dArray = this.u1ij[i];
                            int n = j;
                            dArray[n] = dArray[n] + (this.fourierCjSj.getCij(i, j - kIndex) * this.currentRhoSigmaj[1][kIndex] + this.fourierCjSj.getSij(i, j - kIndex) * this.currentRhoSigmaj[0][kIndex]);
                            double[] dArray2 = this.v1ij[i];
                            int n2 = j;
                            dArray2[n2] = dArray2[n2] + (this.fourierCjSj.getCij(i, j - kIndex) * this.currentRhoSigmaj[0][kIndex] - this.fourierCjSj.getSij(i, j - kIndex) * this.currentRhoSigmaj[1][kIndex]);
                        }
                    }
                    if (j != this.jMax) {
                        for (kIndex = 1; kIndex <= this.jMax - j; ++kIndex) {
                            double[] dArray = this.u1ij[i];
                            int n = j;
                            dArray[n] = dArray[n] + (-this.fourierCjSj.getCij(i, j + kIndex) * this.currentRhoSigmaj[1][kIndex] + this.fourierCjSj.getSij(i, j + kIndex) * this.currentRhoSigmaj[0][kIndex]);
                            double[] dArray3 = this.v1ij[i];
                            int n3 = j;
                            dArray3[n3] = dArray3[n3] + (this.fourierCjSj.getCij(i, j + kIndex) * this.currentRhoSigmaj[0][kIndex] + this.fourierCjSj.getSij(i, j + kIndex) * this.currentRhoSigmaj[1][kIndex]);
                        }
                    }
                    for (kIndex = 1; kIndex <= this.jMax; ++kIndex) {
                        double[] dArray = this.u1ij[i];
                        int n = j;
                        dArray[n] = dArray[n] + (-this.fourierCjSj.getCij(i, kIndex) * this.currentRhoSigmaj[1][j + kIndex] - this.fourierCjSj.getSij(i, kIndex) * this.currentRhoSigmaj[0][j + kIndex]);
                        double[] dArray4 = this.v1ij[i];
                        int n4 = j;
                        dArray4[n4] = dArray4[n4] + (this.fourierCjSj.getCij(i, kIndex) * this.currentRhoSigmaj[0][j + kIndex] + this.fourierCjSj.getSij(i, kIndex) * this.currentRhoSigmaj[1][j + kIndex]);
                    }
                    double[] dArray = this.u1ij[i];
                    int n = j;
                    dArray[n] = dArray[n] * -ooj;
                    double[] dArray5 = this.v1ij[i];
                    int n5 = j;
                    dArray5[n5] = dArray5[n5] * ooj;
                    if (i != 0) continue;
                    double[] dArray6 = this.u1ij[0];
                    dArray6[0] = dArray6[0] + (-this.u1ij[0][j] * this.currentRhoSigmaj[0][j] - this.v1ij[0][j] * this.currentRhoSigmaj[1][j]);
                }
            }
            j = this.jMax + 1;
            while (j <= 2 * this.jMax) {
                int kIndex;
                ooj = 1.0 / (double)j;
                this.u1ij[0][j] = 0.0;
                this.v1ij[0][j] = 0.0;
                for (kIndex = j - this.jMax; kIndex <= j - 1; ++kIndex) {
                    double[] dArray = this.u1ij[0];
                    int n = j;
                    dArray[n] = dArray[n] + (this.fourierCjSj.getCij(0, j - kIndex) * this.currentRhoSigmaj[1][kIndex] + this.fourierCjSj.getSij(0, j - kIndex) * this.currentRhoSigmaj[0][kIndex]);
                    double[] dArray7 = this.v1ij[0];
                    int n6 = j;
                    dArray7[n6] = dArray7[n6] + (this.fourierCjSj.getCij(0, j - kIndex) * this.currentRhoSigmaj[0][kIndex] - this.fourierCjSj.getSij(0, j - kIndex) * this.currentRhoSigmaj[1][kIndex]);
                }
                for (kIndex = 1; kIndex <= this.jMax; ++kIndex) {
                    double[] dArray = this.u1ij[0];
                    int n = j;
                    dArray[n] = dArray[n] + (-this.fourierCjSj.getCij(0, kIndex) * this.currentRhoSigmaj[1][j + kIndex] - this.fourierCjSj.getSij(0, kIndex) * this.currentRhoSigmaj[0][j + kIndex]);
                    double[] dArray8 = this.v1ij[0];
                    int n7 = j;
                    dArray8[n7] = dArray8[n7] + (this.fourierCjSj.getCij(0, kIndex) * this.currentRhoSigmaj[0][j + kIndex] + this.fourierCjSj.getSij(0, kIndex) * this.currentRhoSigmaj[1][j + kIndex]);
                }
                double[] dArray = this.u1ij[0];
                int n = j;
                dArray[n] = dArray[n] * -ooj;
                double[] dArray9 = this.v1ij[0];
                int n8 = j++;
                dArray9[n8] = dArray9[n8] * ooj;
            }
        }

        private void computeU2V2Coefficients() {
            int j = 1;
            while (j <= this.jMax) {
                int l;
                double ooj = 1.0 / (double)j;
                this.u2ij[j] = this.v1ij[0][j];
                this.v2ij[j] = this.u1ij[0][j];
                if (j > 1) {
                    for (l = 1; l <= j - 1; ++l) {
                        int n = j;
                        this.u2ij[n] = this.u2ij[n] + (this.u1ij[0][j - l] * this.currentRhoSigmaj[1][l] + this.v1ij[0][j - l] * this.currentRhoSigmaj[0][l]);
                        int n2 = j;
                        this.v2ij[n2] = this.v2ij[n2] + (this.u1ij[0][j - l] * this.currentRhoSigmaj[0][l] - this.v1ij[0][j - l] * this.currentRhoSigmaj[1][l]);
                    }
                }
                for (l = 1; l <= this.jMax; ++l) {
                    int n = j;
                    this.u2ij[n] = this.u2ij[n] + (-this.u1ij[0][j + l] * this.currentRhoSigmaj[1][l] + this.u1ij[0][l] * this.currentRhoSigmaj[1][j + l] + this.v1ij[0][j + l] * this.currentRhoSigmaj[0][l] - this.v1ij[0][l] * this.currentRhoSigmaj[0][j + l]);
                    int n3 = j;
                    this.u2ij[n3] = this.u2ij[n3] + (this.u1ij[0][j + l] * this.currentRhoSigmaj[0][l] + this.u1ij[0][l] * this.currentRhoSigmaj[0][j + l] + this.v1ij[0][j + l] * this.currentRhoSigmaj[1][l] + this.v1ij[0][l] * this.currentRhoSigmaj[1][j + l]);
                }
                int n = j;
                this.u2ij[n] = this.u2ij[n] * -ooj;
                int n4 = j++;
                this.v2ij[n4] = this.v2ij[n4] * ooj;
            }
        }

        public double getU1(int j, int i) {
            return this.u1ij[i][j];
        }

        public double getV1(int j, int i) {
            return this.v1ij[i][j];
        }

        public double getU2(int j) {
            return this.u2ij[j];
        }

        public double getV2(int j) {
            return this.v2ij[j];
        }
    }

    protected static class FieldGaussianShortPeriodicCoefficients<T extends CalculusFieldElement<T>>
    implements FieldShortPeriodTerms<T> {
        private final int jMax;
        private final int interpolationPoints;
        private final String coefficientsKeyPrefix;
        private final transient FieldTimeSpanMap<FieldSlot<T>, T> slots;

        FieldGaussianShortPeriodicCoefficients(String coefficientsKeyPrefix, int jMax, int interpolationPoints, FieldTimeSpanMap<FieldSlot<T>, T> slots) {
            this.jMax = jMax;
            this.interpolationPoints = interpolationPoints;
            this.coefficientsKeyPrefix = coefficientsKeyPrefix;
            this.slots = slots;
        }

        public FieldSlot<T> createSlot(FieldSpacecraftState<T> ... meanStates) {
            FieldAbsoluteDate<T> last;
            FieldSlot slot = new FieldSlot(this.jMax, this.interpolationPoints);
            FieldAbsoluteDate<T> first = meanStates[0].getDate();
            if (first.compareTo(last = meanStates[meanStates.length - 1].getDate()) <= 0) {
                this.slots.addValidAfter(slot, first);
            } else {
                this.slots.addValidBefore(slot, first);
            }
            return slot;
        }

        private void computeCoefficients(FieldSpacecraftState<T> state, FieldSlot<T> slot, FieldFourierCjSjCoefficients<T> fourierCjSj, FieldUijVijCoefficients<T> uijvij, T n, T a, Field<T> field) {
            CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
            FieldAbsoluteDate<T> date = state.getDate();
            CalculusFieldElement k20 = this.computeK20(this.jMax, ((FieldUijVijCoefficients)uijvij).currentRhoSigmaj, field);
            CalculusFieldElement oon = (CalculusFieldElement)n.reciprocal();
            CalculusFieldElement to2an = (CalculusFieldElement)((CalculusFieldElement)oon.multiply(1.5)).divide(a);
            CalculusFieldElement to4an = (CalculusFieldElement)to2an.divide(2.0);
            int size = this.jMax + 1;
            CalculusFieldElement[] di1 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)6);
            CalculusFieldElement[] di2 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)6);
            CalculusFieldElement[][] currentCij = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)size, (int)6);
            CalculusFieldElement[][] currentSij = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)size, (int)6);
            for (int i = 0; i < 6; ++i) {
                di1[i] = (CalculusFieldElement)((CalculusFieldElement)oon.negate()).multiply(fourierCjSj.getCij(i, 0));
                if (i == 5) {
                    di1[i] = (CalculusFieldElement)di1[i].add(to2an.multiply(uijvij.getU1(0, 0)));
                }
                di2[i] = zero;
                if (i == 5) {
                    di2[i] = (CalculusFieldElement)di2[i].add(((CalculusFieldElement)to4an.negate()).multiply(fourierCjSj.getCij(0, 0)));
                }
                currentCij[0][i] = (CalculusFieldElement)((CalculusFieldElement)di2[i].negate()).multiply((FieldElement)k20);
                for (int j = 1; j <= this.jMax; ++j) {
                    currentCij[j][i] = (CalculusFieldElement)oon.multiply(uijvij.getU1(j, i));
                    if (i == 5) {
                        currentCij[j][i] = (CalculusFieldElement)currentCij[j][i].add(((CalculusFieldElement)to2an.negate()).multiply(uijvij.getU2(j)));
                    }
                    currentSij[j][i] = (CalculusFieldElement)oon.multiply(uijvij.getV1(j, i));
                    if (i == 5) {
                        currentSij[j][i] = (CalculusFieldElement)currentSij[j][i].add(((CalculusFieldElement)to2an.negate()).multiply(uijvij.getV2(j)));
                    }
                    currentCij[0][i] = (CalculusFieldElement)currentCij[0][i].add(((CalculusFieldElement)((CalculusFieldElement)currentCij[j][i].multiply((FieldElement)((FieldUijVijCoefficients)uijvij).currentRhoSigmaj[0][j])).add(currentSij[j][i].multiply((FieldElement)((FieldUijVijCoefficients)uijvij).currentRhoSigmaj[1][j]))).negate());
                }
            }
            ((FieldSlot)slot).cij[0].addGridPoint(date, currentCij[0]);
            ((FieldSlot)slot).dij[1].addGridPoint(date, di1);
            ((FieldSlot)slot).dij[2].addGridPoint(date, di2);
            for (int j = 1; j <= this.jMax; ++j) {
                ((FieldSlot)slot).cij[j].addGridPoint(date, currentCij[j]);
                ((FieldSlot)slot).sij[j].addGridPoint(date, currentSij[j]);
            }
        }

        private T computeK20(int kMax, T[][] currentRhoSigmaj, Field<T> field) {
            CalculusFieldElement zero;
            CalculusFieldElement k20 = zero = (CalculusFieldElement)field.getZero();
            for (int kIndex = 1; kIndex <= kMax; ++kIndex) {
                CalculusFieldElement currentTerm = (CalculusFieldElement)((CalculusFieldElement)currentRhoSigmaj[1][kIndex].multiply(currentRhoSigmaj[1][kIndex])).add(currentRhoSigmaj[0][kIndex].multiply(currentRhoSigmaj[0][kIndex]));
                currentTerm = (CalculusFieldElement)currentTerm.multiply(2.0 / (double)(kIndex * kIndex));
                k20 = (CalculusFieldElement)k20.add((FieldElement)currentTerm);
            }
            return (T)k20;
        }

        @Override
        public T[] value(FieldOrbit<T> meanOrbit) {
            FieldSlot<T> slot = this.slots.get(meanOrbit.getDate());
            T L = meanOrbit.getLv();
            CalculusFieldElement center = (CalculusFieldElement)L.subtract(meanOrbit.getLM());
            CalculusFieldElement center2 = (CalculusFieldElement)center.multiply((FieldElement)center);
            CalculusFieldElement[] shortPeriodicVariation = ((FieldSlot)slot).cij[0].value(meanOrbit.getDate());
            CalculusFieldElement[] d1 = ((FieldSlot)slot).dij[1].value(meanOrbit.getDate());
            CalculusFieldElement[] d2 = ((FieldSlot)slot).dij[2].value(meanOrbit.getDate());
            for (int i = 0; i < 6; ++i) {
                shortPeriodicVariation[i] = (CalculusFieldElement)shortPeriodicVariation[i].add(((CalculusFieldElement)center.multiply((FieldElement)d1[i])).add(center2.multiply((FieldElement)d2[i])));
            }
            for (int j = 1; j <= 12; ++j) {
                CalculusFieldElement[] c = ((FieldSlot)slot).cij[j].value(meanOrbit.getDate());
                CalculusFieldElement[] s = ((FieldSlot)slot).sij[j].value(meanOrbit.getDate());
                FieldSinCos sc = FastMath.sinCos((CalculusFieldElement)((CalculusFieldElement)L.multiply(j)));
                CalculusFieldElement cos = (CalculusFieldElement)sc.cos();
                CalculusFieldElement sin = (CalculusFieldElement)sc.sin();
                for (int i = 0; i < 6; ++i) {
                    shortPeriodicVariation[i] = (CalculusFieldElement)shortPeriodicVariation[i].add(c[i].multiply((FieldElement)cos));
                    shortPeriodicVariation[i] = (CalculusFieldElement)shortPeriodicVariation[i].add(s[i].multiply((FieldElement)sin));
                }
            }
            return shortPeriodicVariation;
        }

        @Override
        public String getCoefficientsKeyPrefix() {
            return this.coefficientsKeyPrefix;
        }

        @Override
        public Map<String, T[]> getCoefficients(FieldAbsoluteDate<T> date, Set<String> selected) {
            FieldSlot<T> slot = this.slots.get(date);
            HashMap<String, T[]> coefficients = new HashMap<String, T[]>(27);
            this.storeIfSelected(coefficients, selected, ((FieldSlot)slot).cij[0].value(date), "d", new int[]{0});
            this.storeIfSelected(coefficients, selected, ((FieldSlot)slot).dij[1].value(date), "d", new int[]{1});
            this.storeIfSelected(coefficients, selected, ((FieldSlot)slot).dij[2].value(date), "d", new int[]{2});
            for (int j = 1; j <= 12; ++j) {
                this.storeIfSelected(coefficients, selected, ((FieldSlot)slot).cij[j].value(date), "c", new int[]{j});
                this.storeIfSelected(coefficients, selected, ((FieldSlot)slot).sij[j].value(date), "s", new int[]{j});
            }
            return coefficients;
        }

        private void storeIfSelected(Map<String, T[]> map, Set<String> selected, T[] value, String id, int ... indices) {
            StringBuilder keyBuilder = new StringBuilder(this.getCoefficientsKeyPrefix());
            keyBuilder.append(id);
            for (int index : indices) {
                keyBuilder.append('[').append(index).append(']');
            }
            String key = keyBuilder.toString();
            if (selected.isEmpty() || selected.contains(key)) {
                map.put(key, value);
            }
        }
    }

    protected static class GaussianShortPeriodicCoefficients
    implements ShortPeriodTerms {
        private final int jMax;
        private final int interpolationPoints;
        private final String coefficientsKeyPrefix;
        private final transient TimeSpanMap<Slot> slots;

        GaussianShortPeriodicCoefficients(String coefficientsKeyPrefix, int jMax, int interpolationPoints, TimeSpanMap<Slot> slots) {
            this.jMax = jMax;
            this.interpolationPoints = interpolationPoints;
            this.coefficientsKeyPrefix = coefficientsKeyPrefix;
            this.slots = slots;
        }

        public Slot createSlot(SpacecraftState ... meanStates) {
            AbsoluteDate last;
            Slot slot = new Slot(this.jMax, this.interpolationPoints);
            AbsoluteDate first = meanStates[0].getDate();
            int compare = first.compareTo(last = meanStates[meanStates.length - 1].getDate());
            if (compare < 0) {
                this.slots.addValidAfter(slot, first, false);
            } else if (compare > 0) {
                this.slots.addValidBefore(slot, first, false);
            } else {
                this.slots.addValidAfter(slot, AbsoluteDate.PAST_INFINITY, false);
            }
            return slot;
        }

        private void computeCoefficients(SpacecraftState state, Slot slot, FourierCjSjCoefficients fourierCjSj, UijVijCoefficients uijvij, double n, double a) {
            AbsoluteDate date = state.getDate();
            double k20 = this.computeK20(this.jMax, uijvij.currentRhoSigmaj);
            double oon = 1.0 / n;
            double to2an = 1.5 * oon / a;
            double to4an = to2an / 2.0;
            int size = this.jMax + 1;
            double[] di1 = new double[6];
            double[] di2 = new double[6];
            double[][] currentCij = new double[size][6];
            double[][] currentSij = new double[size][6];
            for (int i = 0; i < 6; ++i) {
                di1[i] = -oon * fourierCjSj.getCij(i, 0);
                if (i == 5) {
                    int n2 = i;
                    di1[n2] = di1[n2] + to2an * uijvij.getU1(0, 0);
                }
                di2[i] = 0.0;
                if (i == 5) {
                    int n3 = i;
                    di2[n3] = di2[n3] + -to4an * fourierCjSj.getCij(0, 0);
                }
                currentCij[0][i] = -di2[i] * k20;
                for (int j = 1; j <= this.jMax; ++j) {
                    currentCij[j][i] = oon * uijvij.getU1(j, i);
                    if (i == 5) {
                        double[] dArray = currentCij[j];
                        int n4 = i;
                        dArray[n4] = dArray[n4] + -to2an * uijvij.getU2(j);
                    }
                    currentSij[j][i] = oon * uijvij.getV1(j, i);
                    if (i == 5) {
                        double[] dArray = currentSij[j];
                        int n5 = i;
                        dArray[n5] = dArray[n5] + -to2an * uijvij.getV2(j);
                    }
                    double[] dArray = currentCij[0];
                    int n6 = i;
                    dArray[n6] = dArray[n6] + -(currentCij[j][i] * uijvij.currentRhoSigmaj[0][j] + currentSij[j][i] * uijvij.currentRhoSigmaj[1][j]);
                }
            }
            slot.cij[0].addGridPoint(date, currentCij[0]);
            slot.dij[1].addGridPoint(date, di1);
            slot.dij[2].addGridPoint(date, di2);
            for (int j = 1; j <= this.jMax; ++j) {
                slot.cij[j].addGridPoint(date, currentCij[j]);
                slot.sij[j].addGridPoint(date, currentSij[j]);
            }
        }

        private double computeK20(int kMax, double[][] currentRhoSigmaj) {
            double k20 = 0.0;
            for (int kIndex = 1; kIndex <= kMax; ++kIndex) {
                double currentTerm = currentRhoSigmaj[1][kIndex] * currentRhoSigmaj[1][kIndex] + currentRhoSigmaj[0][kIndex] * currentRhoSigmaj[0][kIndex];
                k20 += (currentTerm *= 2.0 / (double)(kIndex * kIndex));
            }
            return k20;
        }

        @Override
        public double[] value(Orbit meanOrbit) {
            Slot slot = this.slots.get(meanOrbit.getDate());
            double L = meanOrbit.getLv();
            double center = L - meanOrbit.getLM();
            double center2 = center * center;
            double[] shortPeriodicVariation = slot.cij[0].value(meanOrbit.getDate());
            double[] d1 = slot.dij[1].value(meanOrbit.getDate());
            double[] d2 = slot.dij[2].value(meanOrbit.getDate());
            for (int i = 0; i < 6; ++i) {
                int n = i;
                shortPeriodicVariation[n] = shortPeriodicVariation[n] + (center * d1[i] + center2 * d2[i]);
            }
            for (int j = 1; j <= 12; ++j) {
                double[] c = slot.cij[j].value(meanOrbit.getDate());
                double[] s = slot.sij[j].value(meanOrbit.getDate());
                SinCos sc = FastMath.sinCos((double)((double)j * L));
                double cos = sc.cos();
                double sin = sc.sin();
                for (int i = 0; i < 6; ++i) {
                    int n = i;
                    shortPeriodicVariation[n] = shortPeriodicVariation[n] + c[i] * cos;
                    int n2 = i;
                    shortPeriodicVariation[n2] = shortPeriodicVariation[n2] + s[i] * sin;
                }
            }
            return shortPeriodicVariation;
        }

        @Override
        public String getCoefficientsKeyPrefix() {
            return this.coefficientsKeyPrefix;
        }

        @Override
        public Map<String, double[]> getCoefficients(AbsoluteDate date, Set<String> selected) {
            Slot slot = this.slots.get(date);
            HashMap<String, double[]> coefficients = new HashMap<String, double[]>(27);
            this.storeIfSelected(coefficients, selected, slot.cij[0].value(date), "d", 0);
            this.storeIfSelected(coefficients, selected, slot.dij[1].value(date), "d", 1);
            this.storeIfSelected(coefficients, selected, slot.dij[2].value(date), "d", 2);
            for (int j = 1; j <= 12; ++j) {
                this.storeIfSelected(coefficients, selected, slot.cij[j].value(date), "c", j);
                this.storeIfSelected(coefficients, selected, slot.sij[j].value(date), "s", j);
            }
            return coefficients;
        }

        private void storeIfSelected(Map<String, double[]> map, Set<String> selected, double[] value, String id, int ... indices) {
            StringBuilder keyBuilder = new StringBuilder(this.getCoefficientsKeyPrefix());
            keyBuilder.append(id);
            for (int index : indices) {
                keyBuilder.append('[').append(index).append(']');
            }
            String key = keyBuilder.toString();
            if (selected.isEmpty() || selected.contains(key)) {
                map.put(key, value);
            }
        }
    }

    protected static class FieldFourierCjSjCoefficients<T extends CalculusFieldElement<T>> {
        private final int jMax;
        private final T[][] cCoef;
        private final T[][] sCoef;
        final /* synthetic */ AbstractGaussianContribution this$0;

        FieldFourierCjSjCoefficients(FieldSpacecraftState<T> state, int jMax, FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters, Field<T> field) {
            this.this$0 = this$0;
            this.jMax = jMax;
            int rows = jMax + 1;
            this.cCoef = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)rows, (int)6);
            this.sCoef = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)rows, (int)6);
            this.computeCoefficients(state, auxiliaryElements, (CalculusFieldElement[])parameters, (Field)field);
        }

        private void computeCoefficients(FieldSpacecraftState<T> state, FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters, Field<T> field) {
            CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
            CalculusFieldElement[] ll = this.this$0.getLLimits(state, auxiliaryElements);
            if (ll[0].getReal() < ll[1].getReal()) {
                CalculusFieldElement ooPI = (CalculusFieldElement)((CalculusFieldElement)zero.getPi()).reciprocal();
                for (int j = 0; j <= this.jMax; ++j) {
                    CalculusFieldElement[] curentCoefficients = this.this$0.integrator.integrate(new FieldIntegrableFunction(this.this$0, state, false, j, parameters, field), ll[0], ll[1], field);
                    for (int i = 0; i < 6; ++i) {
                        this.cCoef[j][i] = (CalculusFieldElement)curentCoefficients[i].multiply((FieldElement)ooPI);
                        this.sCoef[j][i] = (CalculusFieldElement)curentCoefficients[i + 6].multiply((FieldElement)ooPI);
                    }
                }
            }
        }

        public T getCij(int i, int j) {
            return this.cCoef[j][i];
        }

        public T getSij(int i, int j) {
            return this.sCoef[j][i];
        }
    }

    protected class FourierCjSjCoefficients {
        private final int jMax;
        private final double[][] cCoef;
        private final double[][] sCoef;

        FourierCjSjCoefficients(SpacecraftState state, int jMax, AuxiliaryElements auxiliaryElements, double[] parameters) {
            this.jMax = jMax;
            int rows = jMax + 1;
            this.cCoef = new double[rows][6];
            this.sCoef = new double[rows][6];
            this.computeCoefficients(state, auxiliaryElements, parameters);
        }

        private void computeCoefficients(SpacecraftState state, AuxiliaryElements auxiliaryElements, double[] parameters) {
            double[] ll = AbstractGaussianContribution.this.getLLimits(state, auxiliaryElements);
            if (ll[0] < ll[1]) {
                double ooPI = 0.3183098861837907;
                for (int j = 0; j <= this.jMax; ++j) {
                    double[] curentCoefficients = AbstractGaussianContribution.this.integrator.integrate(new IntegrableFunction(state, false, j, parameters), ll[0], ll[1]);
                    for (int i = 0; i < 6; ++i) {
                        this.cCoef[j][i] = 0.3183098861837907 * curentCoefficients[i];
                        this.sCoef[j][i] = 0.3183098861837907 * curentCoefficients[i + 6];
                    }
                }
            }
        }

        public double getCij(int i, int j) {
            return this.cCoef[j][i];
        }

        public double getSij(int i, int j) {
            return this.sCoef[j][i];
        }
    }

    protected static class GaussQuadrature {
        private static final double[] P_12 = new double[]{-0.9815606342467191, -0.9041172563704749, -0.7699026741943047, -0.5873179542866174, -0.36783149899818024, -0.1252334085114689, 0.1252334085114689, 0.36783149899818024, 0.5873179542866174, 0.7699026741943047, 0.9041172563704749, 0.9815606342467191};
        private static final double[] W_12 = new double[]{0.0471753363865122, 0.1069393259953183, 0.16007832854334633, 0.20316742672306584, 0.23349253653835478, 0.24914704581340286, 0.24914704581340286, 0.23349253653835478, 0.20316742672306584, 0.16007832854334633, 0.1069393259953183, 0.0471753363865122};
        private static final double[] P_16 = new double[]{-0.9894009349916499, -0.9445750230732326, -0.8656312023878316, -0.7554044083550031, -0.6178762444026438, -0.45801677765722737, -0.2816035507792589, -0.09501250983763745, 0.09501250983763745, 0.2816035507792589, 0.45801677765722737, 0.6178762444026438, 0.7554044083550031, 0.8656312023878316, 0.9445750230732326, 0.9894009349916499};
        private static final double[] W_16 = new double[]{0.027152459411754058, 0.06225352393864777, 0.09515851168249283, 0.12462897125553388, 0.14959598881657685, 0.16915651939500256, 0.1826034150449236, 0.18945061045506847, 0.18945061045506847, 0.1826034150449236, 0.16915651939500256, 0.14959598881657685, 0.12462897125553388, 0.09515851168249283, 0.06225352393864777, 0.027152459411754058};
        private static final double[] P_20 = new double[]{-0.9931285991850949, -0.9639719272779139, -0.912234428251326, -0.8391169718222189, -0.7463319064601508, -0.6360536807265151, -0.510867001950827, -0.37370608871541955, -0.22778585114164507, -0.07652652113349734, 0.07652652113349734, 0.22778585114164507, 0.37370608871541955, 0.510867001950827, 0.6360536807265151, 0.7463319064601508, 0.8391169718222189, 0.912234428251326, 0.9639719272779139, 0.9931285991850949};
        private static final double[] W_20 = new double[]{0.017614007139152264, 0.04060142980038684, 0.06267204833410904, 0.08327674157670477, 0.10193011981724048, 0.11819453196151844, 0.13168863844917678, 0.14209610931838212, 0.1491729864726038, 0.152753387130726, 0.152753387130726, 0.1491729864726038, 0.14209610931838212, 0.13168863844917678, 0.11819453196151844, 0.10193011981724048, 0.08327674157670477, 0.06267204833410904, 0.04060142980038684, 0.017614007139152264};
        private static final double[] P_24 = new double[]{-0.9951872199970213, -0.9747285559713095, -0.9382745520027327, -0.886415527004401, -0.820001985973903, -0.7401241915785544, -0.6480936519369755, -0.5454214713888395, -0.4337935076260452, -0.3150426796961634, -0.19111886747361634, -0.06405689286260563, 0.06405689286260563, 0.19111886747361634, 0.3150426796961634, 0.4337935076260452, 0.5454214713888395, 0.6480936519369755, 0.7401241915785544, 0.820001985973903, 0.886415527004401, 0.9382745520027327, 0.9747285559713095, 0.9951872199970213};
        private static final double[] W_24 = new double[]{0.012341229799987335, 0.028531388628933806, 0.04427743881741981, 0.059298584915436915, 0.07334648141108027, 0.0861901615319532, 0.09761865210411391, 0.10744427011596558, 0.11550566805372553, 0.12167047292780335, 0.12583745634682825, 0.12793819534675221, 0.12793819534675221, 0.12583745634682825, 0.12167047292780335, 0.11550566805372553, 0.10744427011596558, 0.09761865210411391, 0.0861901615319532, 0.07334648141108027, 0.059298584915436915, 0.04427743881741981, 0.028531388628933806, 0.012341229799987335};
        private static final double[] P_32 = new double[]{-0.9972638618494816, -0.9856115115452684, -0.9647622555875064, -0.9349060759377397, -0.8963211557660522, -0.8493676137325699, -0.7944837959679425, -0.7321821187402897, -0.6630442669302152, -0.5877157572407623, -0.5068999089322295, -0.4213512761306354, -0.33186860228212767, -0.2392873622521371, -0.14447196158279646, -0.04830766568773831, 0.04830766568773831, 0.14447196158279646, 0.2392873622521371, 0.33186860228212767, 0.4213512761306354, 0.5068999089322295, 0.5877157572407623, 0.6630442669302152, 0.7321821187402897, 0.7944837959679425, 0.8493676137325699, 0.8963211557660522, 0.9349060759377397, 0.9647622555875064, 0.9856115115452684, 0.9972638618494816};
        private static final double[] W_32 = new double[]{0.007018610009470136, 0.016274394730905712, 0.025392065309262142, 0.03427386291302141, 0.042835898022226586, 0.050998059262376216, 0.05868409347853559, 0.06582222277636193, 0.07234579410884862, 0.07819389578707042, 0.08331192422694673, 0.0876520930044038, 0.0911738786957639, 0.09384439908080441, 0.09563872007927487, 0.09654008851472784, 0.09654008851472784, 0.09563872007927487, 0.09384439908080441, 0.0911738786957639, 0.0876520930044038, 0.08331192422694673, 0.07819389578707042, 0.07234579410884862, 0.06582222277636193, 0.05868409347853559, 0.050998059262376216, 0.042835898022226586, 0.03427386291302141, 0.025392065309262142, 0.016274394730905712, 0.007018610009470136};
        private static final double[] P_40 = new double[]{-0.9982377097105593, -0.9907262386994571, -0.9772599499837742, -0.9579168192137917, -0.9328128082786766, -0.9020988069688742, -0.8659595032122596, -0.8246122308333117, -0.7783056514265194, -0.7273182551899271, -0.6719566846141796, -0.6125538896679803, -0.5494671250951282, -0.4830758016861787, -0.413779204371605, -0.3419940908257585, -0.2681521850072537, -0.1926975807013711, -0.11608407067525522, -0.038772417506050816, 0.038772417506050816, 0.11608407067525522, 0.1926975807013711, 0.2681521850072537, 0.3419940908257585, 0.413779204371605, 0.4830758016861787, 0.5494671250951282, 0.6125538896679803, 0.6719566846141796, 0.7273182551899271, 0.7783056514265194, 0.8246122308333117, 0.8659595032122596, 0.9020988069688742, 0.9328128082786766, 0.9579168192137917, 0.9772599499837742, 0.9907262386994571, 0.9982377097105593};
        private static final double[] W_40 = new double[]{0.004521277098533098, 0.010498284531152704, 0.016421058381907973, 0.02224584919416689, 0.02793700698002338, 0.033460195282547865, 0.03878216797447199, 0.04387090818567333, 0.04869580763507221, 0.05322784698393679, 0.05743976909939157, 0.06130624249292891, 0.06480401345660108, 0.06791204581523394, 0.07061164739128681, 0.07288658239580408, 0.07472316905796833, 0.07611036190062619, 0.07703981816424793, 0.07750594797842482, 0.07750594797842482, 0.07703981816424793, 0.07611036190062619, 0.07472316905796833, 0.07288658239580408, 0.07061164739128681, 0.06791204581523394, 0.06480401345660108, 0.06130624249292891, 0.05743976909939157, 0.05322784698393679, 0.04869580763507221, 0.04387090818567333, 0.03878216797447199, 0.033460195282547865, 0.02793700698002338, 0.02224584919416689, 0.016421058381907973, 0.010498284531152704, 0.004521277098533098};
        private static final double[] P_48 = new double[]{-0.9987710072524261, -0.9935301722663508, -0.984124583722827, -0.9705915925462472, -0.9529877031604308, -0.9313866907065544, -0.9058791367155696, -0.876572020274248, -0.8435882616243935, -0.8070662040294425, -0.7671590325157402, -0.7240341309238147, -0.677872379632664, -0.6288673967765137, -0.5772247260839727, -0.523160974722233, -0.4669029047509584, -0.4086864819907168, -0.3487558862921607, -0.28736248735545555, -0.22476379039468908, -0.16122235606889174, -0.0970046992094627, -0.03238017096286937, 0.03238017096286937, 0.0970046992094627, 0.16122235606889174, 0.22476379039468908, 0.28736248735545555, 0.3487558862921607, 0.4086864819907168, 0.4669029047509584, 0.523160974722233, 0.5772247260839727, 0.6288673967765137, 0.677872379632664, 0.7240341309238147, 0.7671590325157402, 0.8070662040294425, 0.8435882616243935, 0.876572020274248, 0.9058791367155696, 0.9313866907065544, 0.9529877031604308, 0.9705915925462472, 0.984124583722827, 0.9935301722663508, 0.9987710072524261};
        private static final double[] W_48 = new double[]{0.0031533460523059625, 0.007327553901276208, 0.011477234579234469, 0.015579315722943866, 0.019616160457355567, 0.023570760839324356, 0.02742650970835688, 0.03116722783279807, 0.03477722256477045, 0.038241351065830806, 0.04154508294346483, 0.04467456085669424, 0.04761665849249054, 0.05035903555385448, 0.05289018948519365, 0.055199503699984165, 0.05727729210040315, 0.05911483969839566, 0.06070443916589384, 0.06203942315989268, 0.06311419228625403, 0.06392423858464817, 0.0644661644359501, 0.06473769681268386, 0.06473769681268386, 0.0644661644359501, 0.06392423858464817, 0.06311419228625403, 0.06203942315989268, 0.06070443916589384, 0.05911483969839566, 0.05727729210040315, 0.055199503699984165, 0.05289018948519365, 0.05035903555385448, 0.04761665849249054, 0.04467456085669424, 0.04154508294346483, 0.038241351065830806, 0.03477722256477045, 0.03116722783279807, 0.02742650970835688, 0.023570760839324356, 0.019616160457355567, 0.015579315722943866, 0.011477234579234469, 0.007327553901276208, 0.0031533460523059625};
        private final double[] nodePoints;
        private final double[] nodeWeights;
        private final int numberOfPoints;

        GaussQuadrature(int numberOfPoints) {
            this.numberOfPoints = numberOfPoints;
            switch (numberOfPoints) {
                case 12: {
                    this.nodePoints = (double[])P_12.clone();
                    this.nodeWeights = (double[])W_12.clone();
                    break;
                }
                case 16: {
                    this.nodePoints = (double[])P_16.clone();
                    this.nodeWeights = (double[])W_16.clone();
                    break;
                }
                case 20: {
                    this.nodePoints = (double[])P_20.clone();
                    this.nodeWeights = (double[])W_20.clone();
                    break;
                }
                case 24: {
                    this.nodePoints = (double[])P_24.clone();
                    this.nodeWeights = (double[])W_24.clone();
                    break;
                }
                case 32: {
                    this.nodePoints = (double[])P_32.clone();
                    this.nodeWeights = (double[])W_32.clone();
                    break;
                }
                case 40: {
                    this.nodePoints = (double[])P_40.clone();
                    this.nodeWeights = (double[])W_40.clone();
                    break;
                }
                default: {
                    this.nodePoints = (double[])P_48.clone();
                    this.nodeWeights = (double[])W_48.clone();
                }
            }
        }

        public double[] integrate(UnivariateVectorFunction f, double lowerBound, double upperBound) {
            double[] adaptedPoints = (double[])this.nodePoints.clone();
            double[] adaptedWeights = (double[])this.nodeWeights.clone();
            this.transform(adaptedPoints, adaptedWeights, lowerBound, upperBound);
            return this.basicIntegrate(f, adaptedPoints, adaptedWeights);
        }

        public <T extends CalculusFieldElement<T>> T[] integrate(CalculusFieldUnivariateVectorFunction<T> f, T lowerBound, T upperBound, Field<T> field) {
            CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
            CalculusFieldElement[] adaptedPoints = (CalculusFieldElement[])MathArrays.buildArray(field, (int)this.numberOfPoints);
            CalculusFieldElement[] adaptedWeights = (CalculusFieldElement[])MathArrays.buildArray(field, (int)this.numberOfPoints);
            for (int i = 0; i < this.numberOfPoints; ++i) {
                adaptedPoints[i] = (CalculusFieldElement)zero.add(this.nodePoints[i]);
                adaptedWeights[i] = (CalculusFieldElement)zero.add(this.nodeWeights[i]);
            }
            this.transform(adaptedPoints, adaptedWeights, lowerBound, upperBound);
            return this.basicIntegrate(f, adaptedPoints, adaptedWeights, field);
        }

        private void transform(double[] points, double[] weights, double a, double b) {
            double scale = (b - a) / 2.0;
            double shift = a + scale;
            int i = 0;
            while (i < points.length) {
                points[i] = points[i] * scale + shift;
                int n = i++;
                weights[n] = weights[n] * scale;
            }
        }

        private <T extends CalculusFieldElement<T>> void transform(T[] points, T[] weights, T a, T b) {
            CalculusFieldElement scale = (CalculusFieldElement)((CalculusFieldElement)b.subtract(a)).divide(2.0);
            CalculusFieldElement shift = (CalculusFieldElement)a.add((FieldElement)scale);
            for (int i = 0; i < points.length; ++i) {
                points[i] = (CalculusFieldElement)((CalculusFieldElement)scale.multiply(points[i])).add((FieldElement)shift);
                weights[i] = (CalculusFieldElement)scale.multiply(weights[i]);
            }
        }

        private double[] basicIntegrate(UnivariateVectorFunction f, double[] points, double[] weights) {
            double x = points[0];
            double w = weights[0];
            double[] v = f.value(x);
            double[] y = new double[v.length];
            for (int j = 0; j < v.length; ++j) {
                y[j] = w * v[j];
            }
            double[] t = (double[])y.clone();
            double[] c = new double[v.length];
            double[] s = (double[])t.clone();
            for (int i = 1; i < points.length; ++i) {
                x = points[i];
                w = weights[i];
                v = f.value(x);
                for (int j = 0; j < v.length; ++j) {
                    y[j] = w * v[j] - c[j];
                    t[j] = s[j] + y[j];
                    c[j] = t[j] - s[j] - y[j];
                    s[j] = t[j];
                }
            }
            return s;
        }

        private <T extends CalculusFieldElement<T>> T[] basicIntegrate(CalculusFieldUnivariateVectorFunction<T> f, T[] points, T[] weights, Field<T> field) {
            T x = points[0];
            T w = weights[0];
            CalculusFieldElement[] v = f.value(x);
            CalculusFieldElement[] y = (CalculusFieldElement[])MathArrays.buildArray(field, (int)v.length);
            for (int j = 0; j < v.length; ++j) {
                y[j] = (CalculusFieldElement)v[j].multiply(w);
            }
            CalculusFieldElement[] t = (CalculusFieldElement[])y.clone();
            CalculusFieldElement[] c = (CalculusFieldElement[])MathArrays.buildArray(field, (int)v.length);
            CalculusFieldElement[] s = (CalculusFieldElement[])t.clone();
            for (int i = 1; i < points.length; ++i) {
                x = points[i];
                w = weights[i];
                v = f.value(x);
                for (int j = 0; j < v.length; ++j) {
                    y[j] = (CalculusFieldElement)((CalculusFieldElement)v[j].multiply(w)).subtract((FieldElement)c[j]);
                    t[j] = (CalculusFieldElement)y[j].add((FieldElement)s[j]);
                    c[j] = (CalculusFieldElement)((CalculusFieldElement)t[j].subtract((FieldElement)s[j])).subtract((FieldElement)y[j]);
                    s[j] = t[j];
                }
            }
            return s;
        }
    }

    protected class IntegrableFunction
    implements UnivariateVectorFunction {
        private final SpacecraftState state;
        private final boolean meanMode;
        private final int j;
        private final AbstractGaussianContributionContext context;
        private final AuxiliaryElements auxiliaryElements;
        private final double[] parameters;

        IntegrableFunction(SpacecraftState state, boolean meanMode, int j, double[] parameters) {
            this.meanMode = meanMode;
            this.j = j;
            this.parameters = (double[])parameters.clone();
            this.auxiliaryElements = new AuxiliaryElements(state.getOrbit(), 1);
            this.context = new AbstractGaussianContributionContext(this.auxiliaryElements, this.parameters);
            double[] stateVector = new double[6];
            OrbitType.EQUINOCTIAL.mapOrbitToArray(state.getOrbit(), PositionAngle.TRUE, stateVector, null);
            Orbit fixedOrbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(stateVector, null, PositionAngle.TRUE, state.getDate(), this.context.getMu(), state.getFrame());
            this.state = new SpacecraftState(fixedOrbit, state.getAttitude(), state.getMass());
        }

        public double[] value(double x) {
            double shiftedLm = this.trueToMean(x);
            double dLm = shiftedLm - this.auxiliaryElements.getLM();
            double dt = dLm / this.context.getMeanMotion();
            SinCos scL = FastMath.sinCos((double)x);
            double cosL = scL.cos();
            double sinL = scL.sin();
            double roa = this.auxiliaryElements.getB() * this.auxiliaryElements.getB() / (1.0 + this.auxiliaryElements.getH() * sinL + this.auxiliaryElements.getK() * cosL);
            double roa2 = roa * roa;
            double r = this.auxiliaryElements.getSma() * roa;
            double X = r * cosL;
            double Y = r * sinL;
            double naob = this.context.getMeanMotion() * this.auxiliaryElements.getSma() / this.auxiliaryElements.getB();
            double Xdot = -naob * (this.auxiliaryElements.getH() + sinL);
            double Ydot = naob * (this.auxiliaryElements.getK() + cosL);
            Vector3D vel = new Vector3D(Xdot, this.auxiliaryElements.getVectorF(), Ydot, this.auxiliaryElements.getVectorG());
            Vector3D acc = Vector3D.ZERO;
            Orbit shiftedOrbit = this.state.getOrbit().shiftedBy(dt);
            EquinoctialOrbit recomposedOrbit = new EquinoctialOrbit(shiftedOrbit.getA(), shiftedOrbit.getEquinoctialEx(), shiftedOrbit.getEquinoctialEy(), shiftedOrbit.getHx(), shiftedOrbit.getHy(), shiftedOrbit.getLv(), PositionAngle.TRUE, shiftedOrbit.getFrame(), this.state.getDate(), this.context.getMu());
            Attitude recomposedAttitude = AbstractGaussianContribution.this.attitudeProvider.getAttitude(recomposedOrbit, recomposedOrbit.getDate(), recomposedOrbit.getFrame());
            SpacecraftState shiftedState = new SpacecraftState((Orbit)recomposedOrbit, recomposedAttitude, this.state.getMass());
            acc = AbstractGaussianContribution.this.contribution.acceleration(shiftedState, this.parameters);
            double[] deriv = new double[]{this.getAoV(vel).dotProduct((Vector)acc), this.getKoV(X, Y, Xdot, Ydot).dotProduct((Vector)acc), this.getHoV(X, Y, Xdot, Ydot).dotProduct((Vector)acc), this.getQoV(X).dotProduct((Vector)acc), this.getPoV(Y).dotProduct((Vector)acc), this.getLoV(X, Y, Xdot, Ydot).dotProduct((Vector)acc)};
            double[] val = null;
            if (this.meanMode) {
                val = new double[6];
                for (int i = 0; i < 6; ++i) {
                    val[i] = roa2 * deriv[i];
                }
            } else {
                val = new double[12];
                SinCos scjL = FastMath.sinCos((double)((double)this.j * x));
                double cosjL = this.j == 1 ? cosL : scjL.cos();
                double sinjL = this.j == 1 ? sinL : scjL.sin();
                for (int i = 0; i < 6; ++i) {
                    val[i] = cosjL * deriv[i];
                    val[i + 6] = sinjL * deriv[i];
                }
            }
            return val;
        }

        private double trueToEccentric(double lv) {
            SinCos scLv = FastMath.sinCos((double)lv);
            double num = this.auxiliaryElements.getH() * scLv.cos() - this.auxiliaryElements.getK() * scLv.sin();
            double den = this.auxiliaryElements.getB() + 1.0 + this.auxiliaryElements.getK() * scLv.cos() + this.auxiliaryElements.getH() * scLv.sin();
            return lv + 2.0 * FastMath.atan((double)(num / den));
        }

        private double eccentricToMean(double le) {
            SinCos scLe = FastMath.sinCos((double)le);
            return le - this.auxiliaryElements.getK() * scLe.sin() + this.auxiliaryElements.getH() * scLe.cos();
        }

        private double trueToMean(double lv) {
            return this.eccentricToMean(this.trueToEccentric(lv));
        }

        private Vector3D getAoV(Vector3D vel) {
            return new Vector3D(this.context.getTon2a(), vel);
        }

        private Vector3D getHoV(double X, double Y, double Xdot, double Ydot) {
            double kf = (2.0 * Xdot * Y - X * Ydot) * this.context.getOoMU();
            double kg = X * Xdot * this.context.getOoMU();
            double kw = this.auxiliaryElements.getK() * (1.0 * this.auxiliaryElements.getQ() * Y - this.auxiliaryElements.getP() * X) * this.context.getOOAB();
            return new Vector3D(kf, this.auxiliaryElements.getVectorF(), -kg, this.auxiliaryElements.getVectorG(), kw, this.auxiliaryElements.getVectorW());
        }

        private Vector3D getKoV(double X, double Y, double Xdot, double Ydot) {
            double kf = Y * Ydot * this.context.getOoMU();
            double kg = (2.0 * X * Ydot - Xdot * Y) * this.context.getOoMU();
            double kw = this.auxiliaryElements.getH() * (1.0 * this.auxiliaryElements.getQ() * Y - this.auxiliaryElements.getP() * X) * this.context.getOOAB();
            return new Vector3D(-kf, this.auxiliaryElements.getVectorF(), kg, this.auxiliaryElements.getVectorG(), -kw, this.auxiliaryElements.getVectorW());
        }

        private Vector3D getPoV(double Y) {
            return new Vector3D(this.context.getCo2AB() * Y, this.auxiliaryElements.getVectorW());
        }

        private Vector3D getQoV(double X) {
            return new Vector3D(1.0 * this.context.getCo2AB() * X, this.auxiliaryElements.getVectorW());
        }

        private Vector3D getLoV(double X, double Y, double Xdot, double Ydot) {
            Vector3D pos = new Vector3D(X, this.auxiliaryElements.getVectorF(), Y, this.auxiliaryElements.getVectorG());
            Vector3D v2 = new Vector3D(this.auxiliaryElements.getK(), this.getHoV(X, Y, Xdot, Ydot), -this.auxiliaryElements.getH(), this.getKoV(X, Y, Xdot, Ydot));
            return new Vector3D(-2.0 * this.context.getOOA(), pos, this.context.getOoBpo(), v2, (1.0 * this.auxiliaryElements.getQ() * Y - this.auxiliaryElements.getP() * X) * this.context.getOOA(), this.auxiliaryElements.getVectorW());
        }
    }

    protected static class FieldIntegrableFunction<T extends CalculusFieldElement<T>>
    implements CalculusFieldUnivariateVectorFunction<T> {
        private final FieldSpacecraftState<T> state;
        private final boolean meanMode;
        private final int j;
        private final FieldAbstractGaussianContributionContext<T> context;
        private final FieldAuxiliaryElements<T> auxiliaryElements;
        private final T[] parameters;
        final /* synthetic */ AbstractGaussianContribution this$0;

        public FieldIntegrableFunction(FieldSpacecraftState<T> state, boolean meanMode, int j, T[] parameters, Field<T> field) {
            this.this$0 = this$0;
            this.meanMode = meanMode;
            this.j = j;
            this.parameters = (CalculusFieldElement[])parameters.clone();
            this.auxiliaryElements = new FieldAuxiliaryElements<T>(state.getOrbit(), 1);
            this.context = new FieldAbstractGaussianContributionContext(this.auxiliaryElements, this.parameters);
            CalculusFieldElement[] stateVector = (CalculusFieldElement[])MathArrays.buildArray(field, (int)6);
            OrbitType.EQUINOCTIAL.mapOrbitToArray(state.getOrbit(), PositionAngle.TRUE, stateVector, null);
            FieldOrbit fixedOrbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(stateVector, null, PositionAngle.TRUE, state.getDate(), (CalculusFieldElement)this.context.getMu(), state.getFrame());
            this.state = new FieldSpacecraftState<T>(fixedOrbit, state.getAttitude(), state.getMass());
        }

        public T[] value(T x) {
            Field<T> field = this.auxiliaryElements.getDate().getField();
            int dimension = 6;
            T shiftedLm = this.trueToMean(x);
            CalculusFieldElement dLm = (CalculusFieldElement)shiftedLm.subtract(this.auxiliaryElements.getLM());
            CalculusFieldElement dt = (CalculusFieldElement)dLm.divide(this.context.getMeanMotion());
            FieldSinCos scL = FastMath.sinCos(x);
            CalculusFieldElement cosL = (CalculusFieldElement)scL.cos();
            CalculusFieldElement sinL = (CalculusFieldElement)scL.sin();
            CalculusFieldElement roa = (CalculusFieldElement)((CalculusFieldElement)this.auxiliaryElements.getB().multiply(this.auxiliaryElements.getB())).divide(((CalculusFieldElement)((CalculusFieldElement)this.auxiliaryElements.getH().multiply((FieldElement)sinL)).add(this.auxiliaryElements.getK().multiply((FieldElement)cosL))).add(1.0));
            CalculusFieldElement roa2 = (CalculusFieldElement)roa.multiply((FieldElement)roa);
            CalculusFieldElement r = (CalculusFieldElement)this.auxiliaryElements.getSma().multiply((FieldElement)roa);
            CalculusFieldElement X = (CalculusFieldElement)r.multiply((FieldElement)cosL);
            CalculusFieldElement Y = (CalculusFieldElement)r.multiply((FieldElement)sinL);
            CalculusFieldElement naob = (CalculusFieldElement)((CalculusFieldElement)this.context.getMeanMotion().multiply(this.auxiliaryElements.getSma())).divide(this.auxiliaryElements.getB());
            CalculusFieldElement Xdot = (CalculusFieldElement)((CalculusFieldElement)naob.multiply(this.auxiliaryElements.getH().add((FieldElement)sinL))).negate();
            CalculusFieldElement Ydot = (CalculusFieldElement)naob.multiply(this.auxiliaryElements.getK().add((FieldElement)cosL));
            FieldVector3D vel = new FieldVector3D(Xdot, this.auxiliaryElements.getVectorF(), Ydot, this.auxiliaryElements.getVectorG());
            FieldVector3D acc = FieldVector3D.getZero(field);
            FieldTimeInterpolable shiftedOrbit = this.state.getOrbit().shiftedBy(dt);
            FieldEquinoctialOrbit recomposedOrbit = new FieldEquinoctialOrbit(((FieldOrbit)shiftedOrbit).getA(), ((FieldOrbit)shiftedOrbit).getEquinoctialEx(), ((FieldOrbit)shiftedOrbit).getEquinoctialEy(), ((FieldOrbit)shiftedOrbit).getHx(), ((FieldOrbit)shiftedOrbit).getHy(), ((FieldOrbit)shiftedOrbit).getLv(), PositionAngle.TRUE, ((FieldOrbit)shiftedOrbit).getFrame(), this.state.getDate(), this.context.getMu());
            FieldAttitude recomposedAttitude = this.this$0.attitudeProvider.getAttitude(recomposedOrbit, recomposedOrbit.getDate(), recomposedOrbit.getFrame());
            FieldSpacecraftState shiftedState = new FieldSpacecraftState(recomposedOrbit, recomposedAttitude, this.state.getMass());
            acc = this.this$0.contribution.acceleration(shiftedState, (CalculusFieldElement[])this.parameters);
            CalculusFieldElement[] deriv = (CalculusFieldElement[])MathArrays.buildArray(field, (int)6);
            deriv[0] = this.getAoV(vel).dotProduct(acc);
            deriv[1] = this.getKoV(X, Y, Xdot, Ydot).dotProduct(acc);
            deriv[2] = this.getHoV(X, Y, Xdot, Ydot).dotProduct(acc);
            deriv[3] = this.getQoV(X).dotProduct(acc);
            deriv[4] = this.getPoV(Y).dotProduct(acc);
            deriv[5] = this.getLoV(X, Y, Xdot, Ydot).dotProduct(acc);
            CalculusFieldElement[] val = null;
            if (this.meanMode) {
                val = (CalculusFieldElement[])MathArrays.buildArray(field, (int)6);
                for (int i = 0; i < 6; ++i) {
                    val[i] = (CalculusFieldElement)deriv[i].multiply((FieldElement)roa2);
                }
            } else {
                val = (CalculusFieldElement[])MathArrays.buildArray(field, (int)12);
                FieldSinCos scjL = FastMath.sinCos((CalculusFieldElement)((CalculusFieldElement)x.multiply(this.j)));
                CalculusFieldElement cosjL = this.j == 1 ? cosL : (CalculusFieldElement)scjL.cos();
                CalculusFieldElement sinjL = this.j == 1 ? sinL : (CalculusFieldElement)scjL.sin();
                for (int i = 0; i < 6; ++i) {
                    val[i] = (CalculusFieldElement)deriv[i].multiply((FieldElement)cosjL);
                    val[i + 6] = (CalculusFieldElement)deriv[i].multiply((FieldElement)sinjL);
                }
            }
            return val;
        }

        private T trueToMean(T x) {
            return this.eccentricToMean(this.trueToEccentric(x));
        }

        private T trueToEccentric(T lv) {
            FieldSinCos sclV = FastMath.sinCos(lv);
            CalculusFieldElement cosLv = (CalculusFieldElement)sclV.cos();
            CalculusFieldElement sinLv = (CalculusFieldElement)sclV.sin();
            CalculusFieldElement num = (CalculusFieldElement)((CalculusFieldElement)this.auxiliaryElements.getH().multiply((FieldElement)cosLv)).subtract(this.auxiliaryElements.getK().multiply((FieldElement)sinLv));
            CalculusFieldElement den = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.auxiliaryElements.getB().add(this.auxiliaryElements.getK().multiply((FieldElement)cosLv))).add(this.auxiliaryElements.getH().multiply((FieldElement)sinLv))).add(1.0);
            return (T)((CalculusFieldElement)((CalculusFieldElement)FastMath.atan((CalculusFieldElement)((CalculusFieldElement)num.divide((FieldElement)den))).multiply(2.0)).add(lv));
        }

        private T eccentricToMean(T le) {
            FieldSinCos scle = FastMath.sinCos(le);
            return (T)((CalculusFieldElement)((CalculusFieldElement)le.subtract(this.auxiliaryElements.getK().multiply((FieldElement)scle.sin()))).add(this.auxiliaryElements.getH().multiply((FieldElement)scle.cos())));
        }

        private FieldVector3D<T> getAoV(FieldVector3D<T> vel) {
            return new FieldVector3D(this.context.getTon2a(), vel);
        }

        private FieldVector3D<T> getHoV(T X, T Y, T Xdot, T Ydot) {
            CalculusFieldElement kf = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)Xdot.multiply(Y)).multiply(2.0)).subtract(X.multiply(Ydot))).multiply(this.context.getOoMU());
            CalculusFieldElement kg = (CalculusFieldElement)((CalculusFieldElement)X.multiply(Xdot)).multiply(this.context.getOoMU());
            CalculusFieldElement kw = (CalculusFieldElement)((CalculusFieldElement)this.auxiliaryElements.getK().multiply(((CalculusFieldElement)((CalculusFieldElement)this.auxiliaryElements.getQ().multiply(Y)).multiply(1)).subtract(this.auxiliaryElements.getP().multiply(X)))).multiply(this.context.getOOAB());
            return new FieldVector3D(kf, this.auxiliaryElements.getVectorF(), (CalculusFieldElement)kg.negate(), this.auxiliaryElements.getVectorG(), kw, this.auxiliaryElements.getVectorW());
        }

        private FieldVector3D<T> getKoV(T X, T Y, T Xdot, T Ydot) {
            CalculusFieldElement kf = (CalculusFieldElement)((CalculusFieldElement)Y.multiply(Ydot)).multiply(this.context.getOoMU());
            CalculusFieldElement kg = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)X.multiply(Ydot)).multiply(2.0)).subtract(Xdot.multiply(Y))).multiply(this.context.getOoMU());
            CalculusFieldElement kw = (CalculusFieldElement)((CalculusFieldElement)this.auxiliaryElements.getH().multiply(((CalculusFieldElement)((CalculusFieldElement)this.auxiliaryElements.getQ().multiply(Y)).multiply(1)).subtract(this.auxiliaryElements.getP().multiply(X)))).multiply(this.context.getOOAB());
            return new FieldVector3D((CalculusFieldElement)kf.negate(), this.auxiliaryElements.getVectorF(), kg, this.auxiliaryElements.getVectorG(), (CalculusFieldElement)kw.negate(), this.auxiliaryElements.getVectorW());
        }

        private FieldVector3D<T> getPoV(T Y) {
            return new FieldVector3D((CalculusFieldElement)this.context.getCo2AB().multiply(Y), this.auxiliaryElements.getVectorW());
        }

        private FieldVector3D<T> getQoV(T X) {
            return new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)this.context.getCo2AB().multiply(X)).multiply(1), this.auxiliaryElements.getVectorW());
        }

        private FieldVector3D<T> getLoV(T X, T Y, T Xdot, T Ydot) {
            FieldVector3D pos = new FieldVector3D(X, this.auxiliaryElements.getVectorF(), Y, this.auxiliaryElements.getVectorG());
            FieldVector3D v2 = new FieldVector3D(this.auxiliaryElements.getK(), this.getHoV(X, Y, Xdot, Ydot), (CalculusFieldElement)this.auxiliaryElements.getH().negate(), this.getKoV(X, Y, Xdot, Ydot));
            return new FieldVector3D((CalculusFieldElement)this.context.getOOA().multiply(-2.0), pos, this.context.getOoBpo(), v2, (CalculusFieldElement)this.context.getOOA().multiply(((CalculusFieldElement)((CalculusFieldElement)this.auxiliaryElements.getQ().multiply(Y)).multiply(1)).subtract(this.auxiliaryElements.getP().multiply(X))), this.auxiliaryElements.getVectorW());
        }
    }
}

