/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.List;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.leastsquares.AbstractBatchLSModel;
import org.orekit.estimation.leastsquares.BatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.AbstractKalmanModel;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanModel;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.analytical.KeplerianPropagator;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.utils.ParameterDriversList;

public class KeplerianPropagatorBuilder
extends AbstractPropagatorBuilder
implements OrbitDeterminationPropagatorBuilder {
    public KeplerianPropagatorBuilder(Orbit templateOrbit, PositionAngle positionAngle, double positionScale) {
        this(templateOrbit, positionAngle, positionScale, InertialProvider.of(templateOrbit.getFrame()));
    }

    public KeplerianPropagatorBuilder(Orbit templateOrbit, PositionAngle positionAngle, double positionScale, AttitudeProvider attitudeProvider) {
        super(templateOrbit, positionAngle, positionScale, true, attitudeProvider);
    }

    @Override
    public Propagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        return new KeplerianPropagator(this.createInitialOrbit(), this.getAttitudeProvider());
    }

    @Override
    public AbstractBatchLSModel buildLSModel(OrbitDeterminationPropagatorBuilder[] builders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer) {
        return new BatchLSModel(builders, measurements, estimatedMeasurementsParameters, observer);
    }

    @Override
    public AbstractKalmanModel buildKalmanModel(List<OrbitDeterminationPropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> covarianceMatricesProviders, ParameterDriversList estimatedMeasurementsParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        return new KalmanModel(propagatorBuilders, covarianceMatricesProviders, estimatedMeasurementsParameters, measurementProcessNoiseMatrix);
    }
}

