/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalGradientConverter;
import org.orekit.propagation.analytical.tle.FieldTLE;
import org.orekit.propagation.analytical.tle.FieldTLEPropagator;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.time.TimeScale;
import org.orekit.utils.ParameterDriver;

class TLEGradientConverter
extends AbstractAnalyticalGradientConverter {
    public static final int FREE_STATE_PARAMETERS = 6;
    private final TLE tle;
    private final TimeScale utc;
    private final Frame teme;
    private final AttitudeProvider provider;

    TLEGradientConverter(TLEPropagator propagator) {
        super(propagator, 3.9860079999999994E14, 6);
        this.tle = propagator.getTLE();
        this.teme = propagator.getFrame();
        this.utc = this.tle.getUtc();
        this.provider = propagator.getAttitudeProvider();
    }

    public FieldTLEPropagator<Gradient> getPropagator(FieldSpacecraftState<Gradient> state, Gradient[] parameters) {
        Gradient zero = state.getA().getField().getZero();
        int satelliteNumber = this.tle.getSatelliteNumber();
        char classification = this.tle.getClassification();
        int launchYear = this.tle.getLaunchYear();
        int launchNumber = this.tle.getLaunchNumber();
        String launchPiece = this.tle.getLaunchPiece();
        int ephemerisType = this.tle.getEphemerisType();
        int elementNumber = this.tle.getElementNumber();
        int revolutionNumberAtEpoch = this.tle.getRevolutionNumberAtEpoch();
        double bStar = this.tle.getBStar();
        FieldTLE<Gradient> templateTLE = new FieldTLE<Gradient>(satelliteNumber, classification, launchYear, launchNumber, launchPiece, ephemerisType, elementNumber, state.getDate(), zero, zero, zero, zero, zero, zero, zero, zero, revolutionNumberAtEpoch, bStar, this.utc);
        FieldTLE<Gradient> gTLE = FieldTLE.stateToTLE(state, templateTLE, this.utc, this.teme);
        return FieldTLEPropagator.selectExtrapolator(gTLE, (AttitudeProvider)this.provider, (CalculusFieldElement)state.getMass(), (Frame)this.teme, (CalculusFieldElement[])parameters);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.tle.getParametersDrivers();
    }
}

