/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.FieldKeplerianOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.analytical.FieldAbstractAnalyticalPropagator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTimeSpanMap;
import org.orekit.utils.ParameterDriver;

public class FieldBrouwerLyddanePropagator<T extends CalculusFieldElement<T>>
extends FieldAbstractAnalyticalPropagator<T> {
    private static final double SCALE = FastMath.scalb((double)1.0, (int)-20);
    private static final double BETA = FastMath.scalb((float)100.0f, (int)-11);
    private FieldBLModel<T> initialModel;
    private transient FieldTimeSpanMap<FieldBLModel<T>, T> models;
    private double referenceRadius;
    private T mu;
    private double[] ck0;
    private final ParameterDriver M2Driver;

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), (CalculusFieldElement)((CalculusFieldElement)initialOrbit.getA().getField().getZero()).add(1000.0), provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()), M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitude, T mass, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics, double M2) {
        this((FieldOrbit<CalculusFieldElement>)initialOrbit, attitude, (CalculusFieldElement)mass, provider.getAe(), (CalculusFieldElement)((CalculusFieldElement)initialOrbit.getA().getField().getZero()).add(provider.getMu()), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, double referenceRadius, T mu, double c20, double c30, double c40, double c50, double M2) {
        this((FieldOrbit<CalculusFieldElement>)initialOrbit, InertialProvider.of(initialOrbit.getFrame()), (CalculusFieldElement)((CalculusFieldElement)initialOrbit.getDate().getField().getZero()).add(1000.0), referenceRadius, (CalculusFieldElement)mu, c20, c30, c40, c50, M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, T mass, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), mass, provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()), M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, T mass, double referenceRadius, T mu, double c20, double c30, double c40, double c50, double M2) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), mass, referenceRadius, mu, c20, c30, c40, c50, M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, attitudeProv, (CalculusFieldElement)((CalculusFieldElement)initialOrbit.getA().getField().getZero()).add(1000.0), provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()), M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, double referenceRadius, T mu, double c20, double c30, double c40, double c50, double M2) {
        this((FieldOrbit<CalculusFieldElement>)initialOrbit, attitudeProv, (CalculusFieldElement)((CalculusFieldElement)initialOrbit.getDate().getField().getZero()).add(1000.0), referenceRadius, (CalculusFieldElement)mu, c20, c30, c40, c50, M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, attitudeProv, mass, provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()), M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, double referenceRadius, T mu, double c20, double c30, double c40, double c50, double M2) {
        this(initialOrbit, attitudeProv, mass, referenceRadius, mu, c20, c30, c40, c50, PropagationType.OSCULATING, M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, UnnormalizedSphericalHarmonicsProvider provider, PropagationType initialType, double M2) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), (CalculusFieldElement)((CalculusFieldElement)initialOrbit.getA().getField().getZero()).add(1000.0), provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()), initialType, M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, UnnormalizedSphericalHarmonicsProvider provider, PropagationType initialType, double M2) {
        this(initialOrbit, attitudeProv, mass, provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()), initialType, M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitude, T mass, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics, PropagationType initialType, double M2) {
        this((FieldOrbit<CalculusFieldElement>)initialOrbit, attitude, (CalculusFieldElement)mass, provider.getAe(), (CalculusFieldElement)((CalculusFieldElement)initialOrbit.getA().getField().getZero()).add(provider.getMu()), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), initialType, M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, double referenceRadius, T mu, double c20, double c30, double c40, double c50, PropagationType initialType, double M2) {
        super(mass.getField(), attitudeProv);
        this.referenceRadius = referenceRadius;
        this.mu = mu;
        this.ck0 = new double[]{0.0, 0.0, c20, c30, c40, c50};
        this.M2Driver = new ParameterDriver("M2", M2, SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.resetInitialState(new FieldSpacecraftState<T>(initialOrbit, attitudeProv.getAttitude(initialOrbit, initialOrbit.getDate(), initialOrbit.getFrame()), mass), initialType);
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        this.resetInitialState(state, PropagationType.OSCULATING);
    }

    public void resetInitialState(FieldSpacecraftState<T> state, PropagationType stateType) {
        super.resetInitialState(state);
        FieldKeplerianOrbit keplerian = (FieldKeplerianOrbit)OrbitType.KEPLERIAN.convertType(state.getOrbit());
        this.initialModel = stateType == PropagationType.MEAN ? new FieldBLModel<T>(keplerian, state.getMass(), this.referenceRadius, this.mu, this.ck0) : this.computeMeanParameters(keplerian, state.getMass());
        this.models = new FieldTimeSpanMap(this.initialModel, state.getA().getField());
    }

    @Override
    protected void resetIntermediateState(FieldSpacecraftState<T> state, boolean forward) {
        FieldBLModel<T> newModel = this.computeMeanParameters((FieldKeplerianOrbit)OrbitType.KEPLERIAN.convertType(state.getOrbit()), state.getMass());
        if (forward) {
            this.models.addValidAfter(newModel, state.getDate());
        } else {
            this.models.addValidBefore(newModel, state.getDate());
        }
        this.stateChanged(state);
    }

    private FieldBLModel<T> computeMeanParameters(FieldKeplerianOrbit<T> osculating, T mass) {
        if (osculating.getA().getReal() < this.referenceRadius) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, osculating.getA());
        }
        Field field = mass.getField();
        CalculusFieldElement one = (CalculusFieldElement)field.getOne();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        FieldBLModel<Object> current = new FieldBLModel<T>(osculating, mass, this.referenceRadius, this.mu, this.ck0);
        CalculusFieldElement epsilon = (CalculusFieldElement)one.multiply(1.0E-13);
        CalculusFieldElement thresholdA = (CalculusFieldElement)epsilon.multiply(((CalculusFieldElement)((FieldBLModel)current).mean.getA().abs()).add(1.0));
        CalculusFieldElement thresholdE = (CalculusFieldElement)epsilon.multiply(((FieldBLModel)current).mean.getE().add(1.0));
        CalculusFieldElement thresholdAngles = (CalculusFieldElement)epsilon.multiply(one.getPi());
        int i = 0;
        while (i++ < 200) {
            FieldUnivariateDerivative2[] parameters = current.propagateParameters(((FieldBLModel)current).mean.getDate(), this.getParameters(mass.getField()));
            CalculusFieldElement deltaA = (CalculusFieldElement)osculating.getA().subtract((FieldElement)parameters[0].getValue());
            CalculusFieldElement deltaE = (CalculusFieldElement)osculating.getE().subtract((FieldElement)parameters[1].getValue());
            CalculusFieldElement deltaI = (CalculusFieldElement)osculating.getI().subtract((FieldElement)parameters[2].getValue());
            CalculusFieldElement deltaOmega = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)osculating.getPerigeeArgument().subtract((FieldElement)parameters[3].getValue())), (CalculusFieldElement)zero);
            CalculusFieldElement deltaRAAN = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)osculating.getRightAscensionOfAscendingNode().subtract((FieldElement)parameters[4].getValue())), (CalculusFieldElement)zero);
            CalculusFieldElement deltaAnom = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)osculating.getMeanAnomaly().subtract((FieldElement)parameters[5].getValue())), (CalculusFieldElement)zero);
            current = new FieldBLModel<CalculusFieldElement>(new FieldKeplerianOrbit<CalculusFieldElement>((CalculusFieldElement)((FieldBLModel)current).mean.getA().add((FieldElement)deltaA), (CalculusFieldElement)((FieldBLModel)current).mean.getE().add((FieldElement)deltaE), (CalculusFieldElement)((FieldBLModel)current).mean.getI().add((FieldElement)deltaI), (CalculusFieldElement)((FieldBLModel)current).mean.getPerigeeArgument().add((FieldElement)deltaOmega), (CalculusFieldElement)((FieldBLModel)current).mean.getRightAscensionOfAscendingNode().add((FieldElement)deltaRAAN), (CalculusFieldElement)((FieldBLModel)current).mean.getMeanAnomaly().add((FieldElement)deltaAnom), PositionAngle.MEAN, ((FieldBLModel)current).mean.getFrame(), ((FieldBLModel)current).mean.getDate(), (CalculusFieldElement)this.mu), (CalculusFieldElement)mass, this.referenceRadius, (CalculusFieldElement)this.mu, this.ck0);
            if (!(FastMath.abs((double)deltaA.getReal()) < thresholdA.getReal()) || !(FastMath.abs((double)deltaE.getReal()) < thresholdE.getReal()) || !(FastMath.abs((double)deltaI.getReal()) < thresholdAngles.getReal()) || !(FastMath.abs((double)deltaOmega.getReal()) < thresholdAngles.getReal()) || !(FastMath.abs((double)deltaRAAN.getReal()) < thresholdAngles.getReal()) || !(FastMath.abs((double)deltaAnom.getReal()) < thresholdAngles.getReal())) continue;
            return current;
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_BROUWER_LYDDANE_MEAN_PARAMETERS, i);
    }

    @Override
    public FieldKeplerianOrbit<T> propagateOrbit(FieldAbsoluteDate<T> date, T[] parameters) {
        FieldBLModel<T> current = this.models.get(date);
        FieldUnivariateDerivative2[] propOrb_parameters = current.propagateParameters(date, (CalculusFieldElement[])parameters);
        return new FieldKeplerianOrbit<CalculusFieldElement>(propOrb_parameters[0].getValue(), propOrb_parameters[1].getValue(), propOrb_parameters[2].getValue(), propOrb_parameters[3].getValue(), propOrb_parameters[4].getValue(), propOrb_parameters[5].getValue(), PositionAngle.MEAN, ((FieldBLModel)current).mean.getFrame(), (FieldAbsoluteDate<CalculusFieldElement>)date, (CalculusFieldElement)this.mu);
    }

    public double getM2() {
        return this.M2Driver.getValue();
    }

    @Override
    protected T getMass(FieldAbsoluteDate<T> date) {
        return (T)((FieldBLModel)this.models.get(date)).mass;
    }

    @Override
    protected List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.M2Driver);
    }

    private static class FieldBLModel<T extends CalculusFieldElement<T>> {
        private final FieldKeplerianOrbit<T> mean;
        private final T mass;
        private final T xnotDot;
        private final T n;
        private final T lt;
        private final T gt;
        private final T ht;
        private final T dei3sg;
        private final T de2sg;
        private final T deisg;
        private final T de;
        private final T dlgs2g;
        private final T dlgc3g;
        private final T dlgcg;
        private final T dh2sgcg;
        private final T dhsgcg;
        private final T dhcg;
        private final T aC;
        private final T aCbis;
        private final T ac2g2f;
        private final T eC;
        private final T ecf;
        private final T e2cf;
        private final T e3cf;
        private final T ec2f2g;
        private final T ecfc2f2g;
        private final T e2cfc2f2g;
        private final T e3cfc2f2g;
        private final T ec2gf;
        private final T ec2g3f;
        private final T ide;
        private final T isfs2f2g;
        private final T icfc2f2g;
        private final T ic2f2g;
        private final T glf;
        private final T gll;
        private final T glsf;
        private final T glosf;
        private final T gls2f2g;
        private final T gls2gf;
        private final T glos2gf;
        private final T gls2g3f;
        private final T glos2g3f;
        private final T hf;
        private final T hl;
        private final T hsf;
        private final T hcfs2g2f;
        private final T hs2g2f;
        private final T hsfc2g2f;
        private final T edls2g;
        private final T edlcg;
        private final T edlc3g;
        private final T edlsf;
        private final T edls2gf;
        private final T edls2g3f;
        private final T aRate;
        private final T eRate;

        FieldBLModel(FieldKeplerianOrbit<T> mean, T mass, double referenceRadius, T mu, double[] ck0) {
            this.mean = mean;
            this.mass = mass;
            CalculusFieldElement one = (CalculusFieldElement)mass.getField().getOne();
            T app = mean.getA();
            this.xnotDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mu.divide(app)).sqrt()).divide(app);
            CalculusFieldElement q = (CalculusFieldElement)((CalculusFieldElement)app.divide(referenceRadius)).reciprocal();
            CalculusFieldElement ql = (CalculusFieldElement)q.multiply((FieldElement)q);
            CalculusFieldElement y2 = (CalculusFieldElement)ql.multiply(-0.5 * ck0[2]);
            this.n = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mean.getE().multiply(mean.getE())).negate()).add(1.0)).sqrt();
            CalculusFieldElement n2 = (CalculusFieldElement)this.n.multiply(this.n);
            CalculusFieldElement n3 = (CalculusFieldElement)n2.multiply(this.n);
            CalculusFieldElement n4 = (CalculusFieldElement)n2.multiply((FieldElement)n2);
            CalculusFieldElement n6 = (CalculusFieldElement)n4.multiply((FieldElement)n2);
            CalculusFieldElement n8 = (CalculusFieldElement)n4.multiply((FieldElement)n4);
            CalculusFieldElement n10 = (CalculusFieldElement)n8.multiply((FieldElement)n2);
            CalculusFieldElement yp2 = (CalculusFieldElement)y2.divide((FieldElement)n4);
            ql = (CalculusFieldElement)ql.multiply((FieldElement)q);
            CalculusFieldElement yp3 = (CalculusFieldElement)((CalculusFieldElement)ql.multiply(ck0[3])).divide((FieldElement)n6);
            ql = (CalculusFieldElement)ql.multiply((FieldElement)q);
            CalculusFieldElement yp4 = (CalculusFieldElement)((CalculusFieldElement)ql.multiply(0.375 * ck0[4])).divide((FieldElement)n8);
            ql = (CalculusFieldElement)ql.multiply((FieldElement)q);
            CalculusFieldElement yp5 = (CalculusFieldElement)((CalculusFieldElement)ql.multiply(ck0[5])).divide((FieldElement)n10);
            FieldSinCos sc = FastMath.sinCos(mean.getI());
            CalculusFieldElement sinI1 = (CalculusFieldElement)sc.sin();
            CalculusFieldElement sinI2 = (CalculusFieldElement)sinI1.multiply((FieldElement)sinI1);
            CalculusFieldElement cosI1 = (CalculusFieldElement)sc.cos();
            CalculusFieldElement cosI2 = (CalculusFieldElement)cosI1.multiply((FieldElement)cosI1);
            CalculusFieldElement cosI3 = (CalculusFieldElement)cosI2.multiply((FieldElement)cosI1);
            CalculusFieldElement cosI4 = (CalculusFieldElement)cosI2.multiply((FieldElement)cosI2);
            CalculusFieldElement cosI6 = (CalculusFieldElement)cosI4.multiply((FieldElement)cosI2);
            CalculusFieldElement C5c2 = (CalculusFieldElement)this.T2(cosI1).reciprocal();
            CalculusFieldElement C3c2 = (CalculusFieldElement)((CalculusFieldElement)cosI2.multiply(3.0)).subtract(1.0);
            T epp = mean.getE();
            CalculusFieldElement epp2 = (CalculusFieldElement)epp.multiply(epp);
            CalculusFieldElement epp3 = (CalculusFieldElement)epp2.multiply(epp);
            CalculusFieldElement epp4 = (CalculusFieldElement)epp2.multiply((FieldElement)epp2);
            if (epp.getReal() >= 1.0) {
                throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_ECCENTRICITY_FOR_PROPAGATION_MODEL, mean.getE().getReal());
            }
            this.lt = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)one.add(((CalculusFieldElement)((CalculusFieldElement)yp2.multiply(this.n)).multiply((FieldElement)C3c2)).multiply(1.5))).add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp2.multiply(0.09375)).multiply((FieldElement)yp2)).multiply(this.n)).multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)n2.multiply(25.0)).add(this.n.multiply(16.0))).add(-15.0)).add(cosI2.multiply(((CalculusFieldElement)((CalculusFieldElement)n2.multiply(-90.0)).add(this.n.multiply(-96.0))).add(30.0)))).add(cosI4.multiply(((CalculusFieldElement)((CalculusFieldElement)n2.multiply(25.0)).add(this.n.multiply(144.0))).add(105.0)))))).add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp4.multiply(0.9375)).multiply(this.n)).multiply((FieldElement)epp2)).multiply(((CalculusFieldElement)((CalculusFieldElement)cosI4.multiply(35.0)).add(cosI2.multiply(-30.0))).add(3.0)));
            this.gt = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp2.multiply(-1.5)).multiply((FieldElement)C5c2)).add(((CalculusFieldElement)((CalculusFieldElement)yp2.multiply(0.09375)).multiply((FieldElement)yp2)).multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)n2.multiply(25.0)).add(this.n.multiply(24.0))).add(-35.0)).add(cosI2.multiply(((CalculusFieldElement)((CalculusFieldElement)n2.multiply(-126.0)).add(this.n.multiply(-192.0))).add(90.0)))).add(cosI4.multiply(((CalculusFieldElement)((CalculusFieldElement)n2.multiply(45.0)).add(this.n.multiply(360.0))).add(385.0)))))).add(((CalculusFieldElement)yp4.multiply(0.3125)).multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)n2.multiply(-9.0)).add(21.0)).add(cosI2.multiply(((CalculusFieldElement)n2.multiply(126.0)).add(-270.0)))).add(cosI4.multiply(((CalculusFieldElement)n2.multiply(-189.0)).add(385.0)))));
            this.ht = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp2.multiply(-3.0)).multiply((FieldElement)cosI1)).add(((CalculusFieldElement)((CalculusFieldElement)yp2.multiply(0.375)).multiply((FieldElement)yp2)).multiply(((CalculusFieldElement)cosI1.multiply(((CalculusFieldElement)((CalculusFieldElement)n2.multiply(9.0)).add(this.n.multiply(12.0))).add(-5.0))).add(cosI3.multiply(((CalculusFieldElement)((CalculusFieldElement)n2.multiply(-5.0)).add(this.n.multiply(-36.0))).add(-35.0)))))).add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp4.multiply(1.25)).multiply((FieldElement)cosI1)).multiply(((CalculusFieldElement)n2.multiply(-3.0)).add(5.0))).multiply(((CalculusFieldElement)cosI2.multiply(-7.0)).add(3.0)));
            CalculusFieldElement cA = (CalculusFieldElement)((CalculusFieldElement)one.subtract(cosI2.multiply(11.0))).subtract(((CalculusFieldElement)cosI4.multiply(40.0)).divide((FieldElement)C5c2));
            CalculusFieldElement cB = (CalculusFieldElement)((CalculusFieldElement)one.subtract(cosI2.multiply(3.0))).subtract(((CalculusFieldElement)cosI4.multiply(8.0)).divide((FieldElement)C5c2));
            CalculusFieldElement cC = (CalculusFieldElement)((CalculusFieldElement)one.subtract(cosI2.multiply(9.0))).subtract(((CalculusFieldElement)cosI4.multiply(24.0)).divide((FieldElement)C5c2));
            CalculusFieldElement cD = (CalculusFieldElement)((CalculusFieldElement)one.subtract(cosI2.multiply(5.0))).subtract(((CalculusFieldElement)cosI4.multiply(16.0)).divide((FieldElement)C5c2));
            CalculusFieldElement qyp2_4 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp2.multiply(3.0)).multiply((FieldElement)yp2)).multiply((FieldElement)cA)).subtract(((CalculusFieldElement)yp4.multiply(10.0)).multiply((FieldElement)cB));
            CalculusFieldElement qyp52 = (CalculusFieldElement)((CalculusFieldElement)cosI1.multiply((FieldElement)epp3)).multiply(((CalculusFieldElement)((CalculusFieldElement)cD.multiply(0.5)).divide((FieldElement)sinI1)).add(sinI1.multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosI4.divide((FieldElement)C5c2)).divide((FieldElement)C5c2)).multiply(80.0)).add(((CalculusFieldElement)((CalculusFieldElement)cosI2.divide((FieldElement)C5c2)).multiply(32.0)).add(5.0)))));
            CalculusFieldElement qyp22 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp2.add(2.0)).subtract(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp2.multiply(3.0)).add(2.0)).multiply(11.0)).multiply((FieldElement)cosI2))).subtract(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp2.multiply(5.0)).add(2.0)).multiply(40.0)).multiply(cosI4.divide((FieldElement)C5c2)))).subtract(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp2.multiply(400.0)).multiply((FieldElement)cosI6)).divide((FieldElement)C5c2)).divide((FieldElement)C5c2));
            CalculusFieldElement qyp42 = (CalculusFieldElement)((CalculusFieldElement)one.divide(5.0)).multiply(qyp22.add(((CalculusFieldElement)one.multiply(4.0)).multiply(((CalculusFieldElement)epp2.add(2.0)).subtract(cosI2.multiply(((CalculusFieldElement)epp2.multiply(3.0)).add(2.0))))));
            CalculusFieldElement qyp52bis = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosI1.multiply((FieldElement)sinI1)).multiply(epp)).multiply(((CalculusFieldElement)epp2.multiply(3.0)).add(4.0))).multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosI4.divide((FieldElement)C5c2)).divide((FieldElement)C5c2)).multiply(40.0)).add(((CalculusFieldElement)cosI2.divide((FieldElement)C5c2)).multiply(16.0))).add(3.0));
            this.dei3sg = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp5.divide((FieldElement)yp2)).multiply(0.3645833333333333)).multiply((FieldElement)epp2)).multiply((FieldElement)n2)).multiply((FieldElement)cD)).multiply((FieldElement)sinI1);
            this.de2sg = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)qyp2_4.divide((FieldElement)yp2)).multiply(epp)).multiply((FieldElement)n2)).multiply(-0.08333333333333333);
            this.deisg = (CalculusFieldElement)sinI1.multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp5.multiply(-0.2734375)).divide((FieldElement)yp2)).multiply((FieldElement)epp2)).multiply((FieldElement)n2)).multiply((FieldElement)cD)).add(((CalculusFieldElement)((CalculusFieldElement)n2.multiply(0.25)).divide((FieldElement)yp2)).multiply(yp3.add(((CalculusFieldElement)((CalculusFieldElement)yp5.multiply(0.3125)).multiply(((CalculusFieldElement)epp2.multiply(3.0)).add(4.0))).multiply((FieldElement)cC)))));
            this.de = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp2.multiply((FieldElement)n2)).multiply((FieldElement)qyp2_4)).divide(24.0)).divide((FieldElement)yp2);
            CalculusFieldElement qyp52quotient = (CalculusFieldElement)((CalculusFieldElement)epp.multiply(((CalculusFieldElement)epp4.multiply(81.0)).add(-32.0))).divide(((CalculusFieldElement)((CalculusFieldElement)this.n.multiply(((CalculusFieldElement)epp2.multiply(9.0)).add(4.0))).add(epp2.multiply(3.0))).add(4.0));
            this.dlgs2g = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp2.multiply(48.0)).reciprocal()).multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp2.multiply(-3.0)).multiply((FieldElement)yp2)).multiply((FieldElement)qyp22)).add(((CalculusFieldElement)yp4.multiply(10.0)).multiply((FieldElement)qyp42)))).add(((CalculusFieldElement)((CalculusFieldElement)n3.divide((FieldElement)yp2)).multiply((FieldElement)qyp2_4)).divide(24.0));
            this.dlgc3g = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp5.multiply(0.09114583333333333)).divide((FieldElement)yp2)).multiply((FieldElement)n3)).multiply(epp)).multiply((FieldElement)cD)).multiply((FieldElement)sinI1)).add(((CalculusFieldElement)((CalculusFieldElement)yp5.multiply(0.030381944444444444)).divide((FieldElement)yp2)).multiply(((CalculusFieldElement)((CalculusFieldElement)qyp52.multiply(2.0)).multiply((FieldElement)cosI1)).subtract(((CalculusFieldElement)((CalculusFieldElement)epp.multiply((FieldElement)cD)).multiply((FieldElement)sinI1)).multiply(((CalculusFieldElement)epp2.multiply(2.0)).add(3.0)))));
            this.dlgcg = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp3.negate()).multiply((FieldElement)cosI2)).multiply(epp)).divide(((CalculusFieldElement)yp2.multiply((FieldElement)sinI1)).multiply(4.0))).add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp5.divide((FieldElement)yp2)).multiply(0.078125)).multiply((FieldElement)cC)).multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosI2.divide((FieldElement)sinI1)).multiply(epp.negate())).multiply(((CalculusFieldElement)epp2.multiply(3.0)).add(4.0))).add(((CalculusFieldElement)sinI1.multiply((FieldElement)epp2)).multiply(((CalculusFieldElement)epp2.multiply(9.0)).add(26.0))))).subtract(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp5.divide((FieldElement)yp2)).multiply(0.46875)).multiply((FieldElement)qyp52bis)).multiply((FieldElement)cosI1))).add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp3.divide((FieldElement)yp2)).multiply(0.25)).multiply((FieldElement)sinI1)).multiply(epp)).divide(n3.add(1.0))).multiply(((CalculusFieldElement)epp2.multiply(epp2.subtract(3.0))).add(3.0)))).add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp5.divide((FieldElement)yp2)).multiply(0.078125)).multiply((FieldElement)n2)).multiply((FieldElement)cC)).multiply((FieldElement)qyp52quotient)).multiply((FieldElement)sinI1)));
            CalculusFieldElement qyp24 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp2.multiply((FieldElement)yp2)).multiply(3.0)).multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosI4.divide((FieldElement)sinI2)).multiply(200.0)).add(((CalculusFieldElement)cosI2.divide((FieldElement)sinI1)).multiply(80.0))).add(11.0))).subtract(((CalculusFieldElement)yp4.multiply(10.0)).multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosI4.divide((FieldElement)sinI2)).multiply(40.0)).add(((CalculusFieldElement)cosI2.divide((FieldElement)sinI1)).multiply(16.0))).add(3.0)));
            this.dh2sgcg = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp5.divide((FieldElement)yp2)).multiply((FieldElement)qyp52)).multiply(0.24305555555555555);
            this.dhsgcg = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)qyp24.multiply((FieldElement)cosI1)).multiply(epp2.negate())).divide(yp2.multiply(12.0));
            this.dhcg = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp5.divide((FieldElement)yp2)).multiply((FieldElement)qyp52)).multiply(-0.06076388888888889)).add(((CalculusFieldElement)((CalculusFieldElement)cosI1.multiply(epp)).divide(((CalculusFieldElement)yp2.multiply((FieldElement)sinI1)).multiply(4.0))).multiply(yp3.add(((CalculusFieldElement)((CalculusFieldElement)yp5.multiply(0.3125)).multiply((FieldElement)cC)).multiply(((CalculusFieldElement)epp2.multiply(3.0)).add(4.0)))))).add(((CalculusFieldElement)((CalculusFieldElement)yp5.multiply((FieldElement)qyp52bis)).multiply(1.875)).divide(yp2.multiply(4.0)));
            this.aC = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp2.negate()).multiply((FieldElement)C3c2)).multiply(app)).divide((FieldElement)n3);
            this.aCbis = (CalculusFieldElement)((CalculusFieldElement)y2.multiply(app)).multiply((FieldElement)C3c2);
            this.ac2g2f = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)y2.multiply(app)).multiply((FieldElement)sinI2)).multiply(3.0);
            CalculusFieldElement qe = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)y2.multiply((FieldElement)C3c2)).multiply(0.5)).multiply((FieldElement)n2)).divide((FieldElement)n6);
            this.eC = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)qe.multiply(epp)).divide(n3.add(1.0))).multiply(((CalculusFieldElement)epp2.multiply(epp2.subtract(3.0))).add(3.0));
            this.ecf = (CalculusFieldElement)qe.multiply(3.0);
            this.e2cf = (CalculusFieldElement)((CalculusFieldElement)qe.multiply(3.0)).multiply(epp);
            this.e3cf = (CalculusFieldElement)qe.multiply((FieldElement)epp2);
            qe = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)y2.multiply(0.5)).multiply((FieldElement)n2)).multiply(3.0)).multiply(((CalculusFieldElement)cosI2.negate()).add(1.0))).divide((FieldElement)n6);
            this.ec2f2g = (CalculusFieldElement)qe.multiply(epp);
            this.ecfc2f2g = (CalculusFieldElement)qe.multiply(3.0);
            this.e2cfc2f2g = (CalculusFieldElement)((CalculusFieldElement)qe.multiply(3.0)).multiply(epp);
            this.e3cfc2f2g = (CalculusFieldElement)qe.multiply((FieldElement)epp2);
            qe = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp2.multiply(-0.5)).multiply((FieldElement)n2)).multiply(((CalculusFieldElement)cosI2.negate()).add(1.0));
            this.ec2gf = (CalculusFieldElement)qe.multiply(3.0);
            this.ec2g3f = qe;
            CalculusFieldElement qi = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp2.multiply(epp)).multiply((FieldElement)cosI1)).multiply((FieldElement)sinI1);
            this.ide = (CalculusFieldElement)((CalculusFieldElement)cosI1.multiply(epp.negate())).divide(sinI1.multiply((FieldElement)n2));
            this.isfs2f2g = qi;
            this.icfc2f2g = (CalculusFieldElement)qi.multiply(2.0);
            qi = (CalculusFieldElement)((CalculusFieldElement)yp2.multiply((FieldElement)cosI1)).multiply((FieldElement)sinI1);
            this.ic2f2g = (CalculusFieldElement)qi.multiply(1.5);
            CalculusFieldElement qgl1 = (CalculusFieldElement)yp2.multiply(0.25);
            CalculusFieldElement qgl2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp2.multiply(epp)).multiply((FieldElement)n2)).multiply(0.25)).divide(this.n.add(1.0));
            this.glf = (CalculusFieldElement)((CalculusFieldElement)qgl1.multiply((FieldElement)C5c2)).multiply(-6.0);
            this.gll = (CalculusFieldElement)((CalculusFieldElement)qgl1.multiply((FieldElement)C5c2)).multiply(6.0);
            this.glsf = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)qgl1.multiply((FieldElement)C5c2)).multiply(-6.0)).multiply(epp)).add(((CalculusFieldElement)qgl2.multiply((FieldElement)C3c2)).multiply(2.0));
            this.glosf = (CalculusFieldElement)((CalculusFieldElement)qgl2.multiply((FieldElement)C3c2)).multiply(2.0);
            qgl1 = (CalculusFieldElement)qgl1.multiply(((CalculusFieldElement)cosI2.multiply(-5.0)).add(3.0));
            qgl2 = (CalculusFieldElement)((CalculusFieldElement)qgl2.multiply(3.0)).multiply(((CalculusFieldElement)cosI2.negate()).add(1.0));
            this.gls2f2g = (CalculusFieldElement)qgl1.multiply(3.0);
            this.gls2gf = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)qgl1.multiply(3.0)).multiply(epp)).add((FieldElement)qgl2);
            this.glos2gf = (CalculusFieldElement)qgl2.negate();
            this.gls2g3f = (CalculusFieldElement)((CalculusFieldElement)qgl1.multiply(epp)).add(qgl2.multiply(0.3333333333333333));
            this.glos2g3f = qgl2;
            CalculusFieldElement qh = (CalculusFieldElement)((CalculusFieldElement)yp2.multiply((FieldElement)cosI1)).multiply(3.0);
            this.hf = (CalculusFieldElement)qh.negate();
            this.hl = qh;
            this.hsf = (CalculusFieldElement)((CalculusFieldElement)qh.multiply(epp)).negate();
            this.hcfs2g2f = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp2.multiply((FieldElement)cosI1)).multiply(epp)).multiply(2.0);
            this.hs2g2f = (CalculusFieldElement)((CalculusFieldElement)yp2.multiply((FieldElement)cosI1)).multiply(1.5);
            this.hsfc2g2f = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp2.multiply((FieldElement)cosI1)).multiply(epp)).negate();
            CalculusFieldElement qedl = (CalculusFieldElement)((CalculusFieldElement)yp2.multiply((FieldElement)n3)).multiply(-0.25);
            this.edls2g = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)qyp2_4.multiply(0.041666666666666664)).multiply(epp)).multiply((FieldElement)n3)).divide((FieldElement)yp2);
            this.edlcg = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp3.divide((FieldElement)yp2)).multiply(-0.25)).multiply((FieldElement)n3)).multiply((FieldElement)sinI1)).subtract(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp5.divide((FieldElement)yp2)).multiply(0.078125)).multiply((FieldElement)n3)).multiply((FieldElement)sinI1)).multiply((FieldElement)cC)).multiply(((CalculusFieldElement)epp2.multiply(9.0)).add(4.0)));
            this.edlc3g = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp5.divide((FieldElement)yp2)).multiply((FieldElement)n3)).multiply((FieldElement)epp2)).multiply((FieldElement)cD)).multiply((FieldElement)sinI1)).multiply(0.09114583333333333);
            this.edlsf = (CalculusFieldElement)((CalculusFieldElement)qedl.multiply((FieldElement)C3c2)).multiply(2.0);
            this.edls2gf = (CalculusFieldElement)((CalculusFieldElement)qedl.multiply(3.0)).multiply(((CalculusFieldElement)cosI2.negate()).add(1.0));
            this.edls2g3f = (CalculusFieldElement)qedl.multiply(0.3333333333333333);
            this.aRate = (CalculusFieldElement)((CalculusFieldElement)app.multiply(-4.0)).divide(this.xnotDot.multiply(3.0));
            this.eRate = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp.multiply(this.n)).multiply(this.n)).multiply(-4.0)).divide(this.xnotDot.multiply(3.0));
        }

        private FieldUnivariateDerivative2<T> eMeSinE(FieldUnivariateDerivative2<T> E) {
            FieldUnivariateDerivative2 x = E.sin().multiply((CalculusFieldElement)((CalculusFieldElement)this.mean.getE().negate()).add(1.0));
            FieldUnivariateDerivative2 mE2 = E.negate().multiply(E);
            FieldUnivariateDerivative2 term = E;
            FieldUnivariateDerivative2 d = E.getField().getZero();
            FieldUnivariateDerivative2 x0 = d.add(Double.NaN);
            while (!Double.valueOf(x.getValue().getReal()).equals(x0.getValue().getReal())) {
                d = d.add(2.0);
                term = term.multiply(mE2.divide(d.multiply(d.add(1.0))));
                x0 = x;
                x = x.subtract(term);
            }
            return x;
        }

        private FieldUnivariateDerivative2<T> getEccentricAnomaly(FieldUnivariateDerivative2<T> mk) {
            FieldUnivariateDerivative2 ek;
            double k1 = 11.42477796076938;
            double k2 = 2.141592653589793;
            double k3 = 17.84955592153876;
            double A = 1.2043347651023166;
            double B = 4.64788969626918;
            CalculusFieldElement zero = (CalculusFieldElement)this.mean.getE().getField().getZero();
            FieldUnivariateDerivative2 reducedM = new FieldUnivariateDerivative2(MathUtils.normalizeAngle((CalculusFieldElement)mk.getValue(), (CalculusFieldElement)zero), mk.getFirstDerivative(), mk.getSecondDerivative());
            if (((CalculusFieldElement)reducedM.getValue().abs()).getReal() < 0.16666666666666666) {
                ek = ((CalculusFieldElement)reducedM.getValue().abs()).getReal() < Precision.SAFE_MIN ? reducedM : reducedM.add(reducedM.multiply(6).cbrt().subtract(reducedM).multiply(this.mean.getE()));
            } else if (reducedM.getValue().getReal() < 0.0) {
                FieldUnivariateDerivative2 w = reducedM.add(Math.PI);
                ek = reducedM.add(w.multiply(-1.2043347651023166).divide(w.subtract(4.64788969626918)).subtract(Math.PI).subtract(reducedM).multiply(this.mean.getE()));
            } else {
                FieldUnivariateDerivative2 minusW = reducedM.subtract(Math.PI);
                ek = reducedM.add(minusW.multiply(1.2043347651023166).divide(minusW.add(4.64788969626918)).add(Math.PI).subtract(reducedM).multiply(this.mean.getE()));
            }
            CalculusFieldElement e1 = (CalculusFieldElement)((CalculusFieldElement)this.mean.getE().negate()).add(1.0);
            boolean noCancellationRisk = ((CalculusFieldElement)e1.add(ek.getValue().multiply((FieldElement)ek.getValue()))).getReal() / 6.0 >= 0.1;
            for (int j = 0; j < 2; ++j) {
                FieldUnivariateDerivative2 fd;
                FieldUnivariateDerivative2 f;
                FieldUnivariateDerivative2 fdd = ek.sin().multiply(this.mean.getE());
                FieldUnivariateDerivative2 fddd = ek.cos().multiply(this.mean.getE());
                if (noCancellationRisk) {
                    f = ek.subtract(fdd).subtract(reducedM);
                    fd = fddd.subtract(1.0).negate();
                } else {
                    f = this.eMeSinE(ek).subtract(reducedM);
                    FieldUnivariateDerivative2 s = ek.multiply(0.5).sin();
                    fd = s.multiply(s).multiply((CalculusFieldElement)this.mean.getE().multiply(2.0)).add(e1);
                }
                FieldUnivariateDerivative2 dee = f.multiply(fd).divide(f.multiply(0.5).multiply(fdd).subtract(fd.multiply(fd)));
                FieldUnivariateDerivative2 w = fd.add(dee.multiply(0.5).multiply(fdd.add(dee.multiply(fdd).divide(3.0))));
                fd = fd.add(dee.multiply(fdd.add(dee.multiply(0.5).multiply(fdd))));
                ek = ek.subtract(f.subtract(dee.multiply(fd.subtract(w))).divide(fd));
            }
            ek = ek.add((CalculusFieldElement)mk.getValue().subtract((FieldElement)reducedM.getValue()));
            return ek;
        }

        private T T2(T cosInc) {
            CalculusFieldElement x = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosInc.multiply(cosInc)).multiply(-5.0)).add(1.0);
            CalculusFieldElement x2 = (CalculusFieldElement)x.multiply((FieldElement)x);
            CalculusFieldElement sum = (CalculusFieldElement)x.getField().getZero();
            for (int i = 0; i <= 12; ++i) {
                double sign = i % 2 == 0 ? 1.0 : -1.0;
                sum = (CalculusFieldElement)sum.add(((CalculusFieldElement)((CalculusFieldElement)FastMath.pow((CalculusFieldElement)x2, (int)i).multiply(FastMath.pow((double)BETA, (int)i))).multiply(sign)).divide(CombinatoricsUtils.factorialDouble((int)(i + 1))));
            }
            CalculusFieldElement product = (CalculusFieldElement)x.getField().getOne();
            for (int i = 0; i <= 10; ++i) {
                product = (CalculusFieldElement)product.multiply(FastMath.exp((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x2.multiply(BETA)).multiply(FastMath.scalb((double)-1.0, (int)i)))).add(1.0));
            }
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(BETA)).multiply((FieldElement)sum)).multiply((FieldElement)product));
        }

        public FieldUnivariateDerivative2<T>[] propagateParameters(FieldAbsoluteDate<T> date, T[] parameters) {
            Field<T> field = date.getField();
            CalculusFieldElement one = (CalculusFieldElement)field.getOne();
            CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
            T m2 = parameters[0];
            FieldUnivariateDerivative2 dt = new FieldUnivariateDerivative2(date.durationFrom(this.mean.getDate()), one, zero);
            FieldUnivariateDerivative2 xnot = dt.multiply(this.xnotDot);
            FieldUnivariateDerivative2 dtM2 = dt.multiply(m2);
            FieldUnivariateDerivative2 dt2M2 = dt.multiply(dtM2);
            FieldUnivariateDerivative2 lpp = new FieldUnivariateDerivative2(MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.mean.getMeanAnomaly().add(this.lt.multiply((FieldElement)xnot.getValue()))).add((FieldElement)dt2M2.getValue())), (CalculusFieldElement)((CalculusFieldElement)one.getPi())), (CalculusFieldElement)((CalculusFieldElement)this.lt.multiply(this.xnotDot)).add((FieldElement)dtM2.multiply(2.0).getValue()), (CalculusFieldElement)m2.multiply(2.0));
            FieldUnivariateDerivative2 gpp = new FieldUnivariateDerivative2(MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)this.mean.getPerigeeArgument().add(this.gt.multiply((FieldElement)xnot.getValue()))), (CalculusFieldElement)((CalculusFieldElement)one.getPi())), (CalculusFieldElement)this.gt.multiply(this.xnotDot), zero);
            FieldUnivariateDerivative2 hpp = new FieldUnivariateDerivative2(MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)this.mean.getRightAscensionOfAscendingNode().add(this.ht.multiply((FieldElement)xnot.getValue()))), (CalculusFieldElement)((CalculusFieldElement)one.getPi())), (CalculusFieldElement)this.ht.multiply(this.xnotDot), zero);
            FieldUnivariateDerivative2 appDrag = dt.multiply((CalculusFieldElement)this.aRate.multiply(m2));
            FieldUnivariateDerivative2 eppDrag = dt.multiply((CalculusFieldElement)this.eRate.multiply(m2));
            FieldUnivariateDerivative2 cg1 = gpp.cos();
            FieldUnivariateDerivative2 sg1 = gpp.sin();
            FieldUnivariateDerivative2 c2g = cg1.multiply(cg1).subtract(sg1.multiply(sg1));
            FieldUnivariateDerivative2 s2g = cg1.multiply(sg1).add(sg1.multiply(cg1));
            FieldUnivariateDerivative2 c3g = c2g.multiply(cg1).subtract(s2g.multiply(sg1));
            FieldUnivariateDerivative2 sg2 = sg1.multiply(sg1);
            FieldUnivariateDerivative2 sg3 = sg1.multiply(sg2);
            FieldUnivariateDerivative2 d1e = sg3.multiply(this.dei3sg).add(sg1.multiply(this.deisg)).add(sg2.multiply(this.de2sg)).add(this.de);
            FieldUnivariateDerivative2 lp_p_gp = s2g.multiply(this.dlgs2g).add(c3g.multiply(this.dlgc3g)).add(cg1.multiply(this.dlgcg)).add(lpp).add(gpp);
            FieldUnivariateDerivative2 hp = sg2.multiply(cg1).multiply(this.dh2sgcg).add(sg1.multiply(cg1).multiply(this.dhsgcg)).add(cg1.multiply(this.dhcg)).add(hpp);
            FieldUnivariateDerivative2<T> Ep = this.getEccentricAnomaly(lpp);
            FieldUnivariateDerivative2 cf1 = Ep.cos().subtract(this.mean.getE()).divide(Ep.cos().multiply((CalculusFieldElement)this.mean.getE().negate()).add(1.0));
            FieldUnivariateDerivative2 sf1 = Ep.sin().multiply(this.n).divide(Ep.cos().multiply((CalculusFieldElement)this.mean.getE().negate()).add(1.0));
            FieldUnivariateDerivative2 f = (FieldUnivariateDerivative2)FastMath.atan2((CalculusFieldElement)sf1, (CalculusFieldElement)cf1);
            FieldUnivariateDerivative2 c2f = cf1.multiply(cf1).subtract(sf1.multiply(sf1));
            FieldUnivariateDerivative2 s2f = cf1.multiply(sf1).add(sf1.multiply(cf1));
            FieldUnivariateDerivative2 c3f = c2f.multiply(cf1).subtract(s2f.multiply(sf1));
            FieldUnivariateDerivative2 s3f = c2f.multiply(sf1).add(s2f.multiply(cf1));
            FieldUnivariateDerivative2 cf2 = cf1.multiply(cf1);
            FieldUnivariateDerivative2 cf3 = cf1.multiply(cf2);
            FieldUnivariateDerivative2 c2g1f = cf1.multiply(c2g).subtract(sf1.multiply(s2g));
            FieldUnivariateDerivative2 c2g2f = c2f.multiply(c2g).subtract(s2f.multiply(s2g));
            FieldUnivariateDerivative2 c2g3f = c3f.multiply(c2g).subtract(s3f.multiply(s2g));
            FieldUnivariateDerivative2 s2g1f = cf1.multiply(s2g).add(c2g.multiply(sf1));
            FieldUnivariateDerivative2 s2g2f = c2f.multiply(s2g).add(c2g.multiply(s2f));
            FieldUnivariateDerivative2 s2g3f = c3f.multiply(s2g).add(c2g.multiply(s3f));
            FieldUnivariateDerivative2 eE = Ep.cos().multiply((CalculusFieldElement)this.mean.getE().negate()).add(1.0).reciprocal();
            FieldUnivariateDerivative2 eE3 = eE.multiply(eE).multiply(eE);
            FieldUnivariateDerivative2 sigma = eE.multiply((CalculusFieldElement)this.n.multiply(this.n)).multiply(eE).add(eE);
            FieldUnivariateDerivative2 a = eE3.multiply(this.aCbis).add(appDrag.add(this.mean.getA())).add(this.aC).add(eE3.multiply(c2g2f).multiply(this.ac2g2f));
            FieldUnivariateDerivative2 e = d1e.add(eppDrag.add(this.mean.getE())).add(this.eC).add(cf1.multiply(this.ecf)).add(cf2.multiply(this.e2cf)).add(cf3.multiply(this.e3cf)).add(c2g2f.multiply(this.ec2f2g)).add(c2g2f.multiply(cf1).multiply(this.ecfc2f2g)).add(c2g2f.multiply(cf2).multiply(this.e2cfc2f2g)).add(c2g2f.multiply(cf3).multiply(this.e3cfc2f2g)).add(c2g1f.multiply(this.ec2gf)).add(c2g3f.multiply(this.ec2g3f));
            FieldUnivariateDerivative2 i = d1e.multiply(this.ide).add(this.mean.getI()).add(sf1.multiply(s2g2f.multiply(this.isfs2f2g))).add(cf1.multiply(c2g2f.multiply(this.icfc2f2g))).add(c2g2f.multiply(this.ic2f2g));
            FieldUnivariateDerivative2 g_p_l = lp_p_gp.add(f.multiply(this.glf)).add(lpp.multiply(this.gll)).add(sf1.multiply(this.glsf)).add(sigma.multiply(sf1).multiply(this.glosf)).add(s2g2f.multiply(this.gls2f2g)).add(s2g1f.multiply(this.gls2gf)).add(sigma.multiply(s2g1f).multiply(this.glos2gf)).add(s2g3f.multiply(this.gls2g3f)).add(sigma.multiply(s2g3f).multiply(this.glos2g3f));
            FieldUnivariateDerivative2 h = hp.add(f.multiply(this.hf)).add(lpp.multiply(this.hl)).add(sf1.multiply(this.hsf)).add(cf1.multiply(s2g2f).multiply(this.hcfs2g2f)).add(s2g2f.multiply(this.hs2g2f)).add(c2g2f.multiply(sf1).multiply(this.hsfc2g2f));
            FieldUnivariateDerivative2 edl = s2g.multiply(this.edls2g).add(cg1.multiply(this.edlcg)).add(c3g.multiply(this.edlc3g)).add(sf1.multiply(this.edlsf)).add(s2g1f.multiply(this.edls2gf)).add(s2g3f.multiply(this.edls2g3f)).add(sf1.multiply(sigma).multiply(this.edlsf)).add(s2g1f.multiply(sigma).multiply((CalculusFieldElement)this.edls2gf.negate())).add(s2g3f.multiply(sigma).multiply((CalculusFieldElement)this.edls2g3f.multiply(3.0)));
            FieldUnivariateDerivative2 A = e.multiply(lpp.cos()).subtract(edl.multiply(lpp.sin()));
            FieldUnivariateDerivative2 B = e.multiply(lpp.sin()).add(edl.multiply(lpp.cos()));
            FieldUnivariateDerivative2 l = (FieldUnivariateDerivative2)FastMath.atan2((CalculusFieldElement)B, (CalculusFieldElement)A);
            FieldUnivariateDerivative2 g = g_p_l.subtract(l);
            FieldUnivariateDerivative2[] FTD = (FieldUnivariateDerivative2[])MathArrays.buildArray((Field)g.getField(), (int)6);
            FTD[0] = a;
            FTD[1] = e;
            FTD[2] = i;
            FTD[3] = g;
            FTD[4] = h;
            FTD[5] = l;
            return FTD;
        }
    }
}

