/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces;

import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.MathArrays;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.numerical.FieldTimeDerivativesEquations;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public interface ForceModel {
    default public void init(SpacecraftState initialState, AbsoluteDate target) {
    }

    default public <T extends CalculusFieldElement<T>> void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
        this.init(initialState.toSpacecraftState(), target.toAbsoluteDate());
    }

    default public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) {
        adder.addNonKeplerianAcceleration(this.acceleration(s, this.getParameters()));
    }

    default public <T extends CalculusFieldElement<T>> void addContribution(FieldSpacecraftState<T> s, FieldTimeDerivativesEquations<T> adder) {
        adder.addNonKeplerianAcceleration(this.acceleration(s, this.getParameters(s.getDate().getField())));
    }

    default public double[] getParameters() {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        double[] parameters = new double[drivers.size()];
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = drivers.get(i).getValue();
        }
        return parameters;
    }

    default public <T extends CalculusFieldElement<T>> T[] getParameters(Field<T> field) {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        CalculusFieldElement[] parameters = (CalculusFieldElement[])MathArrays.buildArray(field, (int)drivers.size());
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(drivers.get(i).getValue());
        }
        return parameters;
    }

    public boolean dependsOnPositionOnly();

    public Vector3D acceleration(SpacecraftState var1, double[] var2);

    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> var1, T[] var2);

    public Stream<EventDetector> getEventsDetectors();

    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> var1);

    public List<ParameterDriver> getParametersDrivers();

    public ParameterDriver getParameterDriver(String var1);

    public boolean isSupported(String var1);
}

