/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.sampling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.propagation.sampling.OrekitStepNormalizer;
import org.orekit.time.AbsoluteDate;

public class StepHandlerMultiplexer
implements OrekitStepHandler {
    private final List<OrekitStepHandler> handlers = new ArrayList<OrekitStepHandler>();
    private AbsoluteDate target;
    private SpacecraftState last;

    public void add(OrekitStepHandler handler) {
        this.handlers.add(handler);
        if (this.last != null) {
            handler.init(this.last, this.target);
        }
    }

    public void add(double h, OrekitFixedStepHandler handler) {
        OrekitStepNormalizer normalized = new OrekitStepNormalizer(h, handler);
        this.handlers.add(normalized);
        if (this.last != null) {
            normalized.init(this.last, this.target);
        }
    }

    public List<OrekitStepHandler> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public void remove(OrekitStepHandler handler) {
        Iterator<OrekitStepHandler> iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != handler) continue;
            if (this.last != null) {
                handler.finish(this.last);
            }
            iterator.remove();
            return;
        }
    }

    public void remove(OrekitFixedStepHandler handler) {
        Iterator<OrekitStepHandler> iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            OrekitStepHandler current = iterator.next();
            if (!(current instanceof OrekitStepNormalizer) || ((OrekitStepNormalizer)current).getFixedStepHandler() != handler) continue;
            if (this.last != null) {
                current.finish(this.last);
            }
            iterator.remove();
            return;
        }
    }

    public void clear() {
        if (this.last != null) {
            this.handlers.forEach(h -> h.finish(this.last));
        }
        this.handlers.clear();
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        this.target = t;
        this.last = s0;
        for (OrekitStepHandler handler : this.handlers) {
            handler.init(s0, t);
        }
    }

    @Override
    public void handleStep(OrekitStepInterpolator interpolator) {
        this.last = interpolator.getCurrentState();
        for (OrekitStepHandler handler : this.handlers) {
            handler.handleStep(interpolator);
        }
    }

    @Override
    public void finish(SpacecraftState finalState) {
        this.target = null;
        this.last = null;
        for (OrekitStepHandler handler : this.handlers) {
            handler.finish(finalState);
        }
    }
}

