/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical.cr3bp;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.numerical.cr3bp.STMEquations;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.AbstractMultipleShooting;

public class CR3BPMultipleShooter
extends AbstractMultipleShooting {
    private static final String STM = "stmEquations";
    private final List<STMEquations> stmEquations;
    private int npoints;

    @Deprecated
    public CR3BPMultipleShooter(List<SpacecraftState> initialGuessList, List<NumericalPropagator> propagatorList, List<AdditionalEquations> additionalEquations, double arcDuration, double tolerance) {
        super(initialGuessList, propagatorList, additionalEquations, arcDuration, tolerance, STM);
        this.stmEquations = additionalEquations.stream().map(ae -> (STMEquations)ae).collect(Collectors.toList());
        this.npoints = initialGuessList.size();
    }

    public CR3BPMultipleShooter(List<SpacecraftState> initialGuessList, List<NumericalPropagator> propagatorList, List<STMEquations> stmEquations, double arcDuration, double tolerance, int maxIter) {
        super(initialGuessList, propagatorList, arcDuration, tolerance, maxIter, STM);
        this.stmEquations = stmEquations;
        this.npoints = initialGuessList.size();
    }

    @Override
    protected SpacecraftState getAugmentedInitialState(int i) {
        return this.stmEquations.get(i).setInitialPhi(this.getPatchPoint(i));
    }

    @Override
    protected double[][] computeAdditionalJacobianMatrix(List<SpacecraftState> propagatedSP) {
        Map<Integer, Double> mapConstraints = this.getConstraintsMap();
        int n = mapConstraints.size() + (this.isClosedOrbit() ? 6 : 0);
        int ncolumns = this.getNumberOfFreeVariables() - 1;
        double[][] M = new double[n][ncolumns];
        int k = 0;
        if (this.isClosedOrbit()) {
            for (int i = 0; i < 6; ++i) {
                M[i][i] = -1.0;
                M[i][ncolumns - 6 + i] = 1.0;
            }
            k = 6;
        }
        for (int index : mapConstraints.keySet()) {
            M[k][index] = 1.0;
            ++k;
        }
        return M;
    }

    @Override
    protected double[][] computeEpochJacobianMatrix(List<SpacecraftState> propagatedSP) {
        int nFreeEpoch = this.getNumberOfFreeEpoch();
        int ncolumns = 1 + nFreeEpoch;
        int nrows = this.npoints - 1;
        return new double[nrows][ncolumns];
    }

    @Override
    protected double[] computeAdditionalConstraints(List<SpacecraftState> propagatedSP) {
        Map<Integer, Double> mapConstraints = this.getConstraintsMap();
        int n = mapConstraints.size() + (this.isClosedOrbit() ? 6 : 0);
        List<SpacecraftState> patchedSpacecraftStates = this.getPatchedSpacecraftState();
        double[] fxAdditionnal = new double[n];
        int i = 0;
        if (this.isClosedOrbit()) {
            AbsolutePVCoordinates apv1i = patchedSpacecraftStates.get(0).getAbsPVA();
            AbsolutePVCoordinates apvni = patchedSpacecraftStates.get(this.npoints - 1).getAbsPVA();
            fxAdditionnal[0] = apvni.getPosition().getX() - apv1i.getPosition().getX();
            fxAdditionnal[1] = apvni.getPosition().getY() - apv1i.getPosition().getY();
            fxAdditionnal[2] = apvni.getPosition().getZ() - apv1i.getPosition().getZ();
            fxAdditionnal[3] = apvni.getVelocity().getX() - apv1i.getVelocity().getX();
            fxAdditionnal[4] = apvni.getVelocity().getY() - apv1i.getVelocity().getY();
            fxAdditionnal[5] = apvni.getVelocity().getZ() - apv1i.getVelocity().getZ();
            i = 6;
        }
        this.updateAdditionalConstraints(i, fxAdditionnal);
        return fxAdditionnal;
    }
}

