/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.models.earth.troposphere.MappingFunction;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class MendesPavlisModel
implements DiscreteTroposphericModel,
MappingFunction {
    private static final double[] K_COEFFICIENTS = new double[]{238.0185, 19990.975, 57.362, 579.55174};
    private static final double[] W_COEFFICIENTS = new double[]{295.235, 2.6422, -0.03238, 0.004028};
    private static final double[][] A_COEFFICIENTS = new double[][]{{0.00121008, 1.7295E-6, 3.191E-5, -1.8478E-8}, {0.00304965, 2.344E-6, -1.035E-4, -1.856E-8}, {0.068777, 1.972E-5, -0.003458, 1.06E-7}};
    private static final double C02 = 0.99995995;
    private double lambda;
    private double P0;
    private double T0;
    private double e0;

    public MendesPavlisModel(double t0, double p0, double rh, double lambda) {
        this.P0 = p0;
        this.T0 = t0;
        this.e0 = this.getWaterVapor(rh);
        this.lambda = lambda;
    }

    public static MendesPavlisModel getStandardModel(double lambda) {
        return new MendesPavlisModel(291.15, 1013.25, 0.5, lambda);
    }

    @Override
    public double pathDelay(double elevation, GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        double[] zenithDelay = this.computeZenithDelay(point, parameters, date);
        double[] mappingFunction = this.mappingFactors(elevation, point, date);
        return zenithDelay[0] * mappingFunction[0] + zenithDelay[1] * mappingFunction[1];
    }

    @Override
    public <T extends CalculusFieldElement<T>> T pathDelay(T elevation, FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        CalculusFieldElement[] delays = this.computeZenithDelay(point, (CalculusFieldElement[])parameters, date);
        CalculusFieldElement[] mappingFunction = this.mappingFactors(elevation, point, date);
        return (T)((CalculusFieldElement)((CalculusFieldElement)delays[0].multiply((FieldElement)mappingFunction[0])).add((FieldElement)((CalculusFieldElement)delays[1].multiply((FieldElement)mappingFunction[1]))));
    }

    public double[] computeZenithDelay(GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        double fsite = this.getSiteFunctionValue(point);
        double[] delay = new double[2];
        double sigma = 1.0 / this.lambda;
        double sigma2 = sigma * sigma;
        double coef1 = K_COEFFICIENTS[0] + sigma2;
        double coef2 = K_COEFFICIENTS[0] - sigma2;
        double coef3 = K_COEFFICIENTS[2] + sigma2;
        double coef4 = K_COEFFICIENTS[2] - sigma2;
        double frac1 = coef1 / (coef2 * coef2);
        double frac2 = coef3 / (coef4 * coef4);
        double fLambdaH = 0.01 * (K_COEFFICIENTS[1] * frac1 + K_COEFFICIENTS[3] * frac2) * 0.99995995;
        delay[0] = 0.002416579 * (fLambdaH / fsite) * this.P0;
        double sigma4 = sigma2 * sigma2;
        double sigma6 = sigma4 * sigma2;
        double w1s2 = 3.0 * W_COEFFICIENTS[1] * sigma2;
        double w2s4 = 5.0 * W_COEFFICIENTS[2] * sigma4;
        double w3s6 = 7.0 * W_COEFFICIENTS[3] * sigma6;
        double fLambdaNH = 0.003101 * (W_COEFFICIENTS[0] + w1s2 + w2s4 + w3s6);
        delay[1] = 1.0E-4 * (5.316 * fLambdaNH - 3.759 * fLambdaH) * (this.e0 / fsite);
        return delay;
    }

    public <T extends CalculusFieldElement<T>> T[] computeZenithDelay(FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        T fsite = this.getSiteFunctionValue(point);
        CalculusFieldElement[] delay = (CalculusFieldElement[])MathArrays.buildArray(field, (int)2);
        CalculusFieldElement sigma = (CalculusFieldElement)zero.add(1.0 / this.lambda);
        CalculusFieldElement sigma2 = (CalculusFieldElement)sigma.multiply((FieldElement)sigma);
        CalculusFieldElement coef1 = (CalculusFieldElement)sigma2.add(K_COEFFICIENTS[0]);
        CalculusFieldElement coef2 = (CalculusFieldElement)((CalculusFieldElement)sigma2.negate()).add(K_COEFFICIENTS[0]);
        CalculusFieldElement coef3 = (CalculusFieldElement)sigma2.add(K_COEFFICIENTS[2]);
        CalculusFieldElement coef4 = (CalculusFieldElement)((CalculusFieldElement)sigma2.negate()).add(K_COEFFICIENTS[2]);
        CalculusFieldElement frac1 = (CalculusFieldElement)coef1.divide((FieldElement)((CalculusFieldElement)coef2.multiply((FieldElement)coef2)));
        CalculusFieldElement frac2 = (CalculusFieldElement)coef3.divide((FieldElement)((CalculusFieldElement)coef4.multiply((FieldElement)coef4)));
        CalculusFieldElement fLambdaH = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)frac1.multiply(K_COEFFICIENTS[1])).add((FieldElement)((CalculusFieldElement)frac2.multiply(K_COEFFICIENTS[3])))).multiply(0.009999599500000001);
        delay[0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fLambdaH.divide(fsite)).multiply(this.P0)).multiply(0.002416579);
        CalculusFieldElement sigma4 = (CalculusFieldElement)sigma2.multiply((FieldElement)sigma2);
        CalculusFieldElement sigma6 = (CalculusFieldElement)sigma4.multiply((FieldElement)sigma2);
        CalculusFieldElement w1s2 = (CalculusFieldElement)sigma2.multiply(3.0 * W_COEFFICIENTS[1]);
        CalculusFieldElement w2s4 = (CalculusFieldElement)sigma4.multiply(5.0 * W_COEFFICIENTS[2]);
        CalculusFieldElement w3s6 = (CalculusFieldElement)sigma6.multiply(7.0 * W_COEFFICIENTS[3]);
        CalculusFieldElement fLambdaNH = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)w1s2.add((FieldElement)w2s4)).add((FieldElement)w3s6)).add(W_COEFFICIENTS[0])).multiply(0.003101);
        delay[1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fLambdaNH.multiply(5.316)).subtract((FieldElement)((CalculusFieldElement)fLambdaH.multiply(3.759)))).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)fsite.divide(this.e0)).reciprocal()))).multiply(1.0E-4);
        return delay;
    }

    @Override
    public double[] mappingFactors(double elevation, GeodeticPoint point, AbsoluteDate date) {
        double sinE = FastMath.sin((double)elevation);
        double T2degree = this.T0 - 273.15;
        double a1 = this.computeMFCoeffient(A_COEFFICIENTS[0][0], A_COEFFICIENTS[0][1], A_COEFFICIENTS[0][2], A_COEFFICIENTS[0][3], T2degree, point);
        double a2 = this.computeMFCoeffient(A_COEFFICIENTS[1][0], A_COEFFICIENTS[1][1], A_COEFFICIENTS[1][2], A_COEFFICIENTS[1][3], T2degree, point);
        double a3 = this.computeMFCoeffient(A_COEFFICIENTS[2][0], A_COEFFICIENTS[2][1], A_COEFFICIENTS[2][2], A_COEFFICIENTS[2][3], T2degree, point);
        double numMP = 1.0 + a1 / (1.0 + a2 / (1.0 + a3));
        double denMP = sinE + a1 / (sinE + a2 / (sinE + a3));
        double factor = numMP / denMP;
        return new double[]{factor, factor};
    }

    @Override
    public <T extends CalculusFieldElement<T>> T[] mappingFactors(T elevation, FieldGeodeticPoint<T> point, FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        CalculusFieldElement sinE = FastMath.sin(elevation);
        double T2degree = this.T0 - 273.15;
        T a1 = this.computeMFCoeffient(A_COEFFICIENTS[0][0], A_COEFFICIENTS[0][1], A_COEFFICIENTS[0][2], A_COEFFICIENTS[0][3], T2degree, point);
        T a2 = this.computeMFCoeffient(A_COEFFICIENTS[1][0], A_COEFFICIENTS[1][1], A_COEFFICIENTS[1][2], A_COEFFICIENTS[1][3], T2degree, point);
        T a3 = this.computeMFCoeffient(A_COEFFICIENTS[2][0], A_COEFFICIENTS[2][1], A_COEFFICIENTS[2][2], A_COEFFICIENTS[2][3], T2degree, point);
        CalculusFieldElement numMP = (CalculusFieldElement)((CalculusFieldElement)a1.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)a2.divide((FieldElement)((CalculusFieldElement)a3.add(1.0)))).add(1.0)))).add(1.0);
        CalculusFieldElement denMP = (CalculusFieldElement)((CalculusFieldElement)a1.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)a2.divide((FieldElement)((CalculusFieldElement)a3.add((FieldElement)sinE)))).add((FieldElement)sinE)))).add((FieldElement)sinE);
        CalculusFieldElement factor = (CalculusFieldElement)numMP.divide((FieldElement)denMP);
        CalculusFieldElement[] mapping = (CalculusFieldElement[])MathArrays.buildArray(field, (int)2);
        mapping[0] = factor;
        mapping[1] = factor;
        return mapping;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private double getSiteFunctionValue(GeodeticPoint point) {
        return 1.0 - 0.00266 * FastMath.cos((double)(2.0 * point.getLatitude())) - 2.8E-7 * point.getAltitude();
    }

    private <T extends CalculusFieldElement<T>> T getSiteFunctionValue(FieldGeodeticPoint<T> point) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.cos((CalculusFieldElement)((CalculusFieldElement)point.getLatitude().multiply(2.0))).multiply(0.00266)).add((FieldElement)((CalculusFieldElement)point.getAltitude().multiply(2.8E-7)))).negate()).add(1.0));
    }

    private double computeMFCoeffient(double a0, double a1, double a2, double a3, double T, GeodeticPoint point) {
        return a0 + a1 * T + a2 * FastMath.cos((double)point.getLatitude()) + a3 * point.getAltitude();
    }

    private <T extends CalculusFieldElement<T>> T computeMFCoeffient(double a0, double a1, double a2, double a3, double T, FieldGeodeticPoint<T> point) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)point.getAltitude().multiply(a3)).add((FieldElement)((CalculusFieldElement)FastMath.cos(point.getLatitude()).multiply(a2)))).add(a0 + a1 * T));
    }

    private double getWaterVapor(double rh) {
        double es = 0.01 * FastMath.exp((double)(1.2378847000000001E-5 * this.T0 * this.T0 - 0.019121316 * this.T0 + 33.93711047 - 6343.164500000001 / this.T0));
        double fw = 1.00062 + 3.14E-6 * this.P0 + 5.599999999999999E-7 * FastMath.pow((double)(this.T0 - 273.15), (int)2);
        double e = rh * fw * es;
        return e;
    }
}

