/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.ITRFVersion;
import org.orekit.frames.ItrfVersionProvider;
import org.orekit.time.DateComponents;

public class ITRFVersionLoader
implements ItrfVersionProvider {
    public static final String SUPPORTED_NAMES = "itrf-versions.conf";
    private static final ITRFVersionConfiguration DEFAULT = new ITRFVersionConfiguration("", ITRFVersion.ITRF_2014, Integer.MIN_VALUE, Integer.MAX_VALUE);
    private final List<ITRFVersionConfiguration> configurations = new ArrayList<ITRFVersionConfiguration>();

    @DefaultDataContext
    public ITRFVersionLoader(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager());
    }

    public ITRFVersionLoader(String supportedNames, DataProvidersManager dataProvidersManager) {
        dataProvidersManager.feed(supportedNames, new Parser());
    }

    @DefaultDataContext
    public ITRFVersionLoader() {
        this(SUPPORTED_NAMES);
    }

    @Override
    public ITRFVersionConfiguration getConfiguration(String name, int mjd) {
        for (ITRFVersionConfiguration configuration : this.configurations) {
            if (!configuration.appliesTo(name) || !configuration.isValid(mjd)) continue;
            return configuration;
        }
        return DEFAULT;
    }

    public static class ITRFVersionConfiguration {
        private final String prefix;
        private final ITRFVersion version;
        private final int validityStart;
        private final int validityEnd;

        public ITRFVersionConfiguration(String prefix, ITRFVersion version, int validityStart, int validityEnd) {
            this.prefix = prefix;
            this.version = version;
            this.validityStart = validityStart;
            this.validityEnd = validityEnd;
        }

        public boolean appliesTo(String name) {
            int i = FastMath.max((int)name.lastIndexOf("/"), (int)name.lastIndexOf("\\"));
            return name.startsWith(this.prefix, i + 1);
        }

        public ITRFVersion getVersion() {
            return this.version;
        }

        public boolean isValid(int mjd) {
            return this.validityStart <= mjd && mjd < this.validityEnd;
        }
    }

    private class Parser
    implements DataLoader {
        private static final String START = "^";
        private static final String NON_BLANK_FIELD = "(\\S+)";
        private static final String CALENDAR_DATE = "\\s+(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)";
        private static final String INFINITY_DATE = "\\s+-+";
        private static final String ITRF = "\\s+([Ii][Tt][Rr][Ff][-_ ]?[0-9]{2,4})";
        private static final String END = "$";

        private Parser() {
        }

        @Override
        public boolean stillAcceptsData() {
            return ITRFVersionLoader.this.configurations.isEmpty();
        }

        @Override
        public void loadData(InputStream input, String name) throws IOException {
            Pattern patternII = Pattern.compile("^(\\S+)\\s+-+\\s+-+\\s+([Ii][Tt][Rr][Ff][-_ ]?[0-9]{2,4})$");
            Pattern patternID = Pattern.compile("^(\\S+)\\s+-+\\s+(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)\\s+([Ii][Tt][Rr][Ff][-_ ]?[0-9]{2,4})$");
            Pattern patternDI = Pattern.compile("^(\\S+)\\s+(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)\\s+-+\\s+([Ii][Tt][Rr][Ff][-_ ]?[0-9]{2,4})$");
            Pattern patternDD = Pattern.compile("^(\\S+)\\s+(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)\\s+(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)\\s+([Ii][Tt][Rr][Ff][-_ ]?[0-9]{2,4})$");
            int lineNumber = 0;
            String line = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                line = reader.readLine();
                while (line != null) {
                    ++lineNumber;
                    if (!(line = line.trim()).startsWith("#") && !line.isEmpty()) {
                        String prefix = null;
                        ITRFVersion version = null;
                        int validityStart = Integer.MIN_VALUE;
                        int validityEnd = Integer.MAX_VALUE;
                        Matcher matcherII = patternII.matcher(line);
                        if (matcherII.matches()) {
                            prefix = matcherII.group(1);
                            version = ITRFVersion.getITRFVersion(matcherII.group(2));
                        } else {
                            Matcher matcherID = patternID.matcher(line);
                            if (matcherID.matches()) {
                                prefix = matcherID.group(1);
                                validityEnd = new DateComponents(Integer.parseInt(matcherID.group(2)), Integer.parseInt(matcherID.group(3)), Integer.parseInt(matcherID.group(4))).getMJD();
                                version = ITRFVersion.getITRFVersion(matcherID.group(5));
                            } else {
                                Matcher matcherDI = patternDI.matcher(line);
                                if (matcherDI.matches()) {
                                    prefix = matcherDI.group(1);
                                    validityStart = new DateComponents(Integer.parseInt(matcherDI.group(2)), Integer.parseInt(matcherDI.group(3)), Integer.parseInt(matcherDI.group(4))).getMJD();
                                    version = ITRFVersion.getITRFVersion(matcherDI.group(5));
                                } else {
                                    Matcher matcherDD = patternDD.matcher(line);
                                    if (matcherDD.matches()) {
                                        prefix = matcherDD.group(1);
                                        validityStart = new DateComponents(Integer.parseInt(matcherDD.group(2)), Integer.parseInt(matcherDD.group(3)), Integer.parseInt(matcherDD.group(4))).getMJD();
                                        validityEnd = new DateComponents(Integer.parseInt(matcherDD.group(5)), Integer.parseInt(matcherDD.group(6)), Integer.parseInt(matcherDD.group(7))).getMJD();
                                        version = ITRFVersion.getITRFVersion(matcherDD.group(8));
                                    } else {
                                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                                    }
                                }
                            }
                        }
                        if (prefix.contains("\\") || prefix.contains("/")) {
                            throw new OrekitException((Localizable)OrekitMessages.ITRF_VERSIONS_PREFIX_ONLY, prefix);
                        }
                        ITRFVersionLoader.this.configurations.add(new ITRFVersionConfiguration(prefix, version, validityStart, validityEnd));
                    }
                    line = reader.readLine();
                }
            }
            catch (IllegalArgumentException e) {
                throw new OrekitException(e, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
            }
        }
    }
}

