/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.tdm;

import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.tdm.ObservationsBlock;
import org.orekit.files.ccsds.ndm.tdm.RangeUnits;
import org.orekit.files.ccsds.ndm.tdm.RangeUnitsConverter;
import org.orekit.files.ccsds.ndm.tdm.TdmMetadata;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.units.Unit;

public enum ObservationType {
    CARRIER_POWER(Unit.ONE),
    DOPPLER_COUNT(Unit.ONE),
    DOPPLER_INSTANTANEOUS(Units.KM_PER_S),
    DOPPLER_INTEGRATED(Units.KM_PER_S),
    PC_N0(Unit.ONE),
    PR_N0(Unit.ONE),
    RECEIVE_PHASE_CT_1(Unit.ONE),
    RECEIVE_PHASE_CT_2(Unit.ONE),
    RECEIVE_PHASE_CT_3(Unit.ONE),
    RECEIVE_PHASE_CT_4(Unit.ONE),
    RECEIVE_PHASE_CT_5(Unit.ONE),
    TRANSMIT_PHASE_CT_1(Unit.ONE),
    TRANSMIT_PHASE_CT_2(Unit.ONE),
    TRANSMIT_PHASE_CT_3(Unit.ONE),
    TRANSMIT_PHASE_CT_4(Unit.ONE),
    TRANSMIT_PHASE_CT_5(Unit.ONE),
    RANGE(Unit.KILOMETRE){

        @Override
        public double rawToSI(RangeUnitsConverter ruConverter, TdmMetadata metadata, AbsoluteDate date, double rawValue) {
            if (metadata.getRangeUnits() == RangeUnits.km) {
                return Unit.KILOMETRE.toSI(rawValue);
            }
            if (metadata.getRangeUnits() == RangeUnits.s) {
                return rawValue * 2.99792458E8;
            }
            if (ruConverter == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_TDM_MISSING_RANGE_UNITS_CONVERTER, new Object[0]);
            }
            return ruConverter.ruToMeters(metadata, date, rawValue);
        }

        @Override
        public double siToRaw(RangeUnitsConverter ruConverter, TdmMetadata metadata, AbsoluteDate date, double siValue) {
            if (metadata.getRangeUnits() == RangeUnits.km) {
                return Unit.KILOMETRE.fromSI(siValue);
            }
            if (metadata.getRangeUnits() == RangeUnits.s) {
                return siValue / 2.99792458E8;
            }
            if (ruConverter == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_TDM_MISSING_RANGE_UNITS_CONVERTER, new Object[0]);
            }
            return ruConverter.metersToRu(metadata, date, siValue);
        }
    }
    ,
    RECEIVE_FREQ_1(Unit.HERTZ),
    RECEIVE_FREQ_2(Unit.HERTZ),
    RECEIVE_FREQ_3(Unit.HERTZ),
    RECEIVE_FREQ_4(Unit.HERTZ),
    RECEIVE_FREQ_5(Unit.HERTZ),
    RECEIVE_FREQ(Unit.HERTZ),
    TRANSMIT_FREQ_1(Unit.HERTZ),
    TRANSMIT_FREQ_2(Unit.HERTZ),
    TRANSMIT_FREQ_3(Unit.HERTZ),
    TRANSMIT_FREQ_4(Unit.HERTZ),
    TRANSMIT_FREQ_5(Unit.HERTZ),
    TRANSMIT_FREQ_RATE_1(Units.HZ_PER_S),
    TRANSMIT_FREQ_RATE_2(Units.HZ_PER_S),
    TRANSMIT_FREQ_RATE_3(Units.HZ_PER_S),
    TRANSMIT_FREQ_RATE_4(Units.HZ_PER_S),
    TRANSMIT_FREQ_RATE_5(Units.HZ_PER_S),
    DOR(Unit.SECOND),
    VLBI_DELAY(Unit.SECOND),
    ANGLE_1(Unit.DEGREE),
    ANGLE_2(Unit.DEGREE),
    MAG(Unit.ONE),
    RCS(Units.M2),
    CLOCK_BIAS(Unit.SECOND),
    CLOCK_DRIFT(Unit.ONE),
    STEC(Unit.TOTAL_ELECTRON_CONTENT_UNIT),
    TROPO_DRY(Unit.METRE),
    TROPO_WET(Unit.METRE),
    PRESSURE(Units.HECTO_PASCAL),
    RHUMIDITY(Unit.PERCENT),
    TEMPERATURE(Unit.ONE);

    private static final Pattern SEPARATOR;
    private final Unit unit;

    private ObservationType(Unit unit) {
        this.unit = unit;
    }

    public boolean process(ParseToken token, ContextBinding context, RangeUnitsConverter ruConverter, TdmMetadata metadata, ObservationsBlock observationsBlock) {
        if (token.getType() == TokenType.ENTRY) {
            if (observationsBlock.getCurrentObservationEpoch() != null) {
                AbsoluteDate epoch = observationsBlock.getCurrentObservationEpoch();
                double rawValue = token.getContentAsDouble();
                observationsBlock.addObservationValue(this, this.rawToSI(ruConverter, metadata, epoch, rawValue));
            } else {
                String[] fields = SEPARATOR.split(token.getContentAsNormalizedString());
                if (fields.length != 2) {
                    throw token.generateException(null);
                }
                AbsoluteDate epoch = context.getTimeSystem().getConverter(context).parse(fields[0]);
                observationsBlock.addObservationEpoch(epoch);
                try {
                    double rawValue = Double.parseDouble(fields[1]);
                    observationsBlock.addObservationValue(this, this.rawToSI(ruConverter, metadata, epoch, rawValue));
                }
                catch (NumberFormatException nfe) {
                    throw token.generateException(nfe);
                }
            }
        }
        return true;
    }

    public double rawToSI(RangeUnitsConverter ruConverter, TdmMetadata metadata, AbsoluteDate date, double rawValue) {
        return this.unit.toSI(rawValue);
    }

    public double siToRaw(RangeUnitsConverter ruConverter, TdmMetadata metadata, AbsoluteDate date, double siValue) {
        return this.unit.fromSI(siValue);
    }

    static {
        SEPARATOR = Pattern.compile("\\s+");
    }
}

