/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.Collections;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.BodyFacade;
import org.orekit.files.ccsds.definitions.DutyCycleType;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.definitions.OrbitRelativeFrame;
import org.orekit.files.ccsds.definitions.SpacecraftBodyFrame;
import org.orekit.files.ccsds.ndm.odm.ocm.ManBasis;
import org.orekit.files.ccsds.ndm.odm.ocm.ManeuverFieldType;
import org.orekit.files.ccsds.ndm.odm.ocm.ManeuverHistoryMetadataKey;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.units.Unit;

public class ManeuverHistoryMetadata
extends CommentsContainer {
    private String manID;
    private String manPrevID;
    private String manNextID;
    private ManBasis manBasis = ManBasis.PLANNED;
    private String manBasisID;
    private String manDeviceID;
    private AbsoluteDate manPrevEpoch;
    private AbsoluteDate manNextEpoch;
    private FrameFacade manReferenceFrame = new FrameFacade(null, null, OrbitRelativeFrame.TNW_INERTIAL, null, OrbitRelativeFrame.TNW_INERTIAL.name());
    private AbsoluteDate manFrameEpoch;
    private List<String> manPurpose;
    private String manPredSource;
    private BodyFacade gravitationalAssist;
    private DutyCycleType dcType;
    private AbsoluteDate dcWindowOpen;
    private AbsoluteDate dcWindowClose;
    private int dcMinCycles;
    private int dcMaxCycles;
    private AbsoluteDate dcExecStart;
    private AbsoluteDate dcExecStop;
    private AbsoluteDate dcRefTime;
    private double dcTimePulseDuration;
    private double dcTimePulsePeriod;
    private Vector3D dcRefDir;
    private SpacecraftBodyFrame dcBodyFrame;
    private Vector3D dcBodyTrigger;
    private double dcPhaseStartAngle;
    private double dcPhaseStopAngle;
    private List<ManeuverFieldType> manComposition;
    private List<Unit> manUnits;

    ManeuverHistoryMetadata(AbsoluteDate epochT0) {
        this.manFrameEpoch = epochT0;
        this.manPurpose = Collections.emptyList();
        this.dcType = DutyCycleType.CONTINUOUS;
        this.dcMinCycles = 0;
        this.dcMaxCycles = 0;
        this.dcTimePulseDuration = Double.NaN;
        this.dcTimePulsePeriod = Double.NaN;
    }

    @Override
    public void validate(double version) {
        int firstNonTime;
        super.validate(version);
        this.checkNotNull(this.manID, ManeuverHistoryMetadataKey.MAN_ID);
        this.checkNotNull(this.manDeviceID, ManeuverHistoryMetadataKey.MAN_DEVICE_ID);
        if (this.dcType != DutyCycleType.CONTINUOUS) {
            this.checkNotNull(this.dcWindowOpen, ManeuverHistoryMetadataKey.DC_WIN_OPEN);
            this.checkNotNull(this.dcWindowClose, ManeuverHistoryMetadataKey.DC_WIN_CLOSE);
            this.checkNotNull(this.dcExecStart, ManeuverHistoryMetadataKey.DC_EXEC_START);
            this.checkNotNull(this.dcExecStop, ManeuverHistoryMetadataKey.DC_EXEC_STOP);
            this.checkNotNull(this.dcRefTime, ManeuverHistoryMetadataKey.DC_REF_TIME);
            this.checkNotNaN(this.dcTimePulseDuration, ManeuverHistoryMetadataKey.DC_TIME_PULSE_DURATION);
            this.checkNotNaN(this.dcTimePulsePeriod, ManeuverHistoryMetadataKey.DC_TIME_PULSE_PERIOD);
        }
        if (this.dcType == DutyCycleType.TIME_AND_ANGLE) {
            this.checkNotNull(this.dcRefDir, ManeuverHistoryMetadataKey.DC_REF_DIR);
            this.checkNotNull(this.dcBodyFrame, ManeuverHistoryMetadataKey.DC_BODY_FRAME);
            this.checkNotNull(this.dcBodyTrigger, ManeuverHistoryMetadataKey.DC_BODY_TRIGGER);
            this.checkNotNull(this.dcPhaseStartAngle, ManeuverHistoryMetadataKey.DC_PA_START_ANGLE);
            this.checkNotNull(this.dcPhaseStopAngle, ManeuverHistoryMetadataKey.DC_PA_STOP_ANGLE);
        }
        this.checkNotNull(this.manComposition, ManeuverHistoryMetadataKey.MAN_COMPOSITION);
        if (!this.manComposition.get(0).isTime()) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_MANEUVER_MISSING_TIME, this.manID);
        }
        int n = firstNonTime = this.manComposition.size() > 1 && this.manComposition.get(1).isTime() ? 2 : 1;
        if (this.manUnits != null) {
            if (this.manUnits.size() != this.manComposition.size() - firstNonTime) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_MANEUVER_UNITS_WRONG_NB_COMPONENTS, this.manID);
            }
            for (int i = 0; i < this.manUnits.size(); ++i) {
                this.manComposition.get(firstNonTime + i).checkUnit(this.manUnits.get(i));
            }
        }
    }

    public String getManID() {
        return this.manID;
    }

    public void setManID(String manID) {
        this.refuseFurtherComments();
        this.manID = manID;
    }

    public String getManPrevID() {
        return this.manPrevID;
    }

    public void setManPrevID(String manPrevID) {
        this.refuseFurtherComments();
        this.manPrevID = manPrevID;
    }

    public String getManNextID() {
        return this.manNextID;
    }

    public void setManNextID(String manNextID) {
        this.refuseFurtherComments();
        this.manNextID = manNextID;
    }

    public ManBasis getManBasis() {
        return this.manBasis;
    }

    public void setManBasis(ManBasis manBasis) {
        this.refuseFurtherComments();
        this.manBasis = manBasis;
    }

    public String getManBasisID() {
        return this.manBasisID;
    }

    public void setManBasisID(String manBasisID) {
        this.refuseFurtherComments();
        this.manBasisID = manBasisID;
    }

    public String getManDeviceID() {
        return this.manDeviceID;
    }

    public void setManDeviceID(String manDeviceID) {
        this.refuseFurtherComments();
        this.manDeviceID = manDeviceID;
    }

    public AbsoluteDate getManPrevEpoch() {
        return this.manPrevEpoch;
    }

    public void setManPrevEpoch(AbsoluteDate manPrevEpoch) {
        this.refuseFurtherComments();
        this.manPrevEpoch = manPrevEpoch;
    }

    public AbsoluteDate getManNextEpoch() {
        return this.manNextEpoch;
    }

    public void setManNextEpoch(AbsoluteDate manNextEpoch) {
        this.refuseFurtherComments();
        this.manNextEpoch = manNextEpoch;
    }

    public List<String> getManPurpose() {
        return this.manPurpose;
    }

    public void setManPurpose(List<String> manPurpose) {
        this.manPurpose = manPurpose;
    }

    public String getManPredSource() {
        return this.manPredSource;
    }

    public void setManPredSource(String manPredSource) {
        this.refuseFurtherComments();
        this.manPredSource = manPredSource;
    }

    public FrameFacade getManReferenceFrame() {
        return this.manReferenceFrame;
    }

    public void setManReferenceFrame(FrameFacade manReferenceFrame) {
        this.refuseFurtherComments();
        this.manReferenceFrame = manReferenceFrame;
    }

    public AbsoluteDate getManFrameEpoch() {
        return this.manFrameEpoch;
    }

    public void setManFrameEpoch(AbsoluteDate manFrameEpoch) {
        this.refuseFurtherComments();
        this.manFrameEpoch = manFrameEpoch;
    }

    public BodyFacade getGravitationalAssist() {
        return this.gravitationalAssist;
    }

    public void setGravitationalAssist(BodyFacade gravitationalAssist) {
        this.refuseFurtherComments();
        this.gravitationalAssist = gravitationalAssist;
    }

    public DutyCycleType getDcType() {
        return this.dcType;
    }

    public void setDcType(DutyCycleType dcType) {
        this.dcType = dcType;
    }

    public AbsoluteDate getDcWindowOpen() {
        return this.dcWindowOpen;
    }

    public void setDcWindowOpen(AbsoluteDate dcWindowOpen) {
        this.dcWindowOpen = dcWindowOpen;
    }

    public AbsoluteDate getDcWindowClose() {
        return this.dcWindowClose;
    }

    public void setDcWindowClose(AbsoluteDate dcWindowClose) {
        this.dcWindowClose = dcWindowClose;
    }

    public int getDcMinCycles() {
        return this.dcMinCycles;
    }

    public void setDcMinCycles(int dcMinCycles) {
        this.dcMinCycles = dcMinCycles;
    }

    public int getDcMaxCycles() {
        return this.dcMaxCycles;
    }

    public void setDcMaxCycles(int dcMaxCycles) {
        this.dcMaxCycles = dcMaxCycles;
    }

    public AbsoluteDate getDcExecStart() {
        return this.dcExecStart;
    }

    public void setDcExecStart(AbsoluteDate dcExecStart) {
        this.dcExecStart = dcExecStart;
    }

    public AbsoluteDate getDcExecStop() {
        return this.dcExecStop;
    }

    public void setDcExecStop(AbsoluteDate dcExecStop) {
        this.dcExecStop = dcExecStop;
    }

    public AbsoluteDate getDcRefTime() {
        return this.dcRefTime;
    }

    public void setDcRefTime(AbsoluteDate dcRefTime) {
        this.dcRefTime = dcRefTime;
    }

    public double getDcTimePulseDuration() {
        return this.dcTimePulseDuration;
    }

    public void setDcTimePulseDuration(double dcTimePulseDuration) {
        this.dcTimePulseDuration = dcTimePulseDuration;
    }

    public double getDcTimePulsePeriod() {
        return this.dcTimePulsePeriod;
    }

    public void setDcTimePulsePeriod(double dcTimePulsePeriod) {
        this.dcTimePulsePeriod = dcTimePulsePeriod;
    }

    public Vector3D getDcRefDir() {
        return this.dcRefDir;
    }

    public void setDcRefDir(Vector3D dcRefDir) {
        this.dcRefDir = dcRefDir;
    }

    public SpacecraftBodyFrame getDcBodyFrame() {
        return this.dcBodyFrame;
    }

    public void setDcBodyFrame(SpacecraftBodyFrame dcBodyFrame) {
        this.dcBodyFrame = dcBodyFrame;
    }

    public Vector3D getDcBodyTrigger() {
        return this.dcBodyTrigger;
    }

    public void setDcBodyTrigger(Vector3D dcBodyTrigger) {
        this.dcBodyTrigger = dcBodyTrigger;
    }

    public double getDcPhaseStartAngle() {
        return this.dcPhaseStartAngle;
    }

    public void setDcPhaseStartAngle(double dcPhaseStartAngle) {
        this.dcPhaseStartAngle = dcPhaseStartAngle;
    }

    public double getDcPhaseStopAngle() {
        return this.dcPhaseStopAngle;
    }

    public void setDcPhaseStopAngle(double dcPhaseStopAngle) {
        this.dcPhaseStopAngle = dcPhaseStopAngle;
    }

    public List<ManeuverFieldType> getManComposition() {
        return this.manComposition;
    }

    public void setManComposition(List<ManeuverFieldType> manComposition) {
        this.refuseFurtherComments();
        this.manComposition = manComposition;
    }

    public List<Unit> getManUnits() {
        return this.manUnits;
    }

    public void setManUnits(List<Unit> manUnits) {
        this.refuseFurtherComments();
        this.manUnits = manUnits;
    }
}

